/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.MembersKey;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.AbstractOlapServiceCaller;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.dataSource.IKDOlapServer;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.api.query.IKDQueryView;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.dataSource.KDServerManager;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.query.floatData.FloatValue;
import kd.epm.eb.olap.impl.utils.KDOlapRequestUtils;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

public class OlapServiceCaller
extends AbstractOlapServiceCaller {
    private static final Log log = LogFactory.getLog(OlapServiceCaller.class);

    @Override
    public CubeDataResult save(@NotNull IKDOlapRequest request) {
        this.verifySave(request);
        if (request.getOlapData().getCells() == null || request.getOlapData().getCells().isEmpty()) {
            return null;
        }
        IKDOlapServer server = KDServerManager.getInstance().getServer(request.getOlapServerName());
        return server.getSession(request.getCubeId(), false).execute(request);
    }

    @Override
    public CubeDataResult save(Long cubeId, SaveCommandInfo saveInfo, CellSet cellSets, Long modifierId, Long busModelId, Long datasetId) {
        IKDOlapRequest request;
        if (cubeId == null || cubeId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapServiceCaller_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (busModelId == null || busModelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u4e1a\u52a1\u6a21\u578bid\u4e0d\u80fd\u4e3a\u7a7a\u62160\u3002", (String)"OlapServiceCaller_1", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (saveInfo == null || cellSets == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapServiceCaller_2", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (modifierId == null || modifierId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\u62160\u3002", (String)"OlapServiceCaller_3", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        MembersKey key = null;
        LinkedList<IKDCell> cells = new LinkedList<IKDCell>();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)cubeId);
        int in = cellSets.getCount();
        for (int i = 0; i < in; ++i) {
            int jn = saveInfo.getMeasures().size();
            for (int j = 0; j < jn; ++j) {
                Iterator cellIter = cellSets.getMetricEntries((String)saveInfo.getMeasures().get(j));
                while (cellIter.hasNext()) {
                    int x;
                    Pair pair = (Pair)cellIter.next();
                    if (pair == null) continue;
                    BgData bgData = new BgData(cubeId);
                    key = (MembersKey)pair.getFirst();
                    int xn = saveInfo.getDimensions().size();
                    for (x = 0; x < xn; ++x) {
                        bgData.setMember((String)saveInfo.getDimensions().get(x), key.getKey(x));
                    }
                    xn = saveInfo.getFixedDimensions().size();
                    for (x = 0; x < xn; ++x) {
                        FixedDimension fix = (FixedDimension)saveInfo.getFixedDimensions().get(x);
                        bgData.setMember(fix.getName(), fix.getValue());
                    }
                    bgData.setValue(ConvertUtils.toDecimal((Object)pair.getSecond()));
                    IKDCell cell = KDCell.of(bgData, (Object)bgData.getValue(), modelCacheHelper.getDimensionList(datasetId));
                    if (cell == null || !cell.isDetail(modelCacheHelper, null, null)) continue;
                    cells.add(cell);
                }
            }
        }
        CubeDataResult result = null;
        if (!cells.isEmpty() && (request = KDOlapRequestUtils.of(modifierId, cubeId, busModelId, datasetId, cells)) != null) {
            IKDOlapServer server = KDServerManager.getInstance().getServer(request.getOlapServerName());
            result = server.getSession(request.getCubeId(), false).execute(request);
        }
        return result;
    }

    @Override
    public CubeDataResult saveByAdd(@NotNull IKDOlapRequest request) {
        this.verifySave(request);
        request.getProperties().setPropertyValue("DATA_SAVE_TYPE", KDValue.valueOf("ADDTO"));
        return this.save(request);
    }

    @Override
    public List<IKDCell> queryByRead(@NotNull IKDOlapRequest request) {
        request.getProperties().setPropertyValue("IGNORE_SAVE", KDValue.valueOf(BgConstant.TRUE_STR));
        return this.query(request);
    }

    @Override
    public List<IKDCell> query(@NotNull IKDOlapRequest request) {
        this.verifyQuery(request);
        this.verifyDimension(request, false);
        if (request.getOlapQuery().getQueries().isEmpty()) {
            return new ArrayList<IKDCell>();
        }
        if (request.getOlapQuery() != null && !request.getOlapQuery().getQueries().isEmpty()) {
            int in = request.getOlapQuery().getQueries().size();
            for (int i = 0; i < in; ++i) {
                log.info("request-query" + i + JSONObject.toJSONString(request.getOlapQuery().getQueries().get(i).getDimension()));
            }
            log.info("request-view" + JSONObject.toJSONString(request.getOlapQuery().getViews()));
        }
        List<IKDCell> cells = new ArrayList<IKDCell>();
        IKDQueryView view = this.queryView(request);
        if (view != null) {
            cells = view.getCells();
        }
        return cells;
    }

    private IKDQueryView queryView(@NotNull IKDOlapRequest request) {
        this.verifyQuery(request);
        if (request.getOlapQuery().getQueries().isEmpty()) {
            return null;
        }
        IKDOlapServer server = KDServerManager.getInstance().getServer(request.getOlapServerName());
        return server.getSession(request.getCubeId()).query(this.hasMultiView(request));
    }

    private IKDOlapRequest[] hasMultiView(@NotNull IKDOlapRequest request) {
        Map keyMaps;
        if (request == null || request.getOlapQuery() == null || request.getOlapQuery().getQueries().isEmpty()) {
            return null;
        }
        boolean hasMultiView = false;
        String viewKey = null;
        Long viewId = null;
        LinkedHashMap keySet = Maps.newLinkedHashMap();
        for (Map.Entry<String, Long> entry : request.getOlapQuery().getViews().entrySet()) {
            viewKey = entry.getKey();
            viewId = entry.getValue();
            if (viewId == null || viewId == 0L || viewKey == null || viewKey.indexOf(95) <= 0) continue;
            hasMultiView = true;
            String[] tmpStr = viewKey.split("_");
            if (tmpStr == null || tmpStr.length <= 1) continue;
            keyMaps = keySet.computeIfAbsent(tmpStr[1], f -> Maps.newHashMapWithExpectedSize((int)request.getOlapQuery().getUseDimension().length));
            keyMaps.put(tmpStr[0], viewId);
        }
        if (hasMultiView) {
            for (Map.Entry<String, Long> entry : request.getOlapQuery().getViews().entrySet()) {
                viewKey = entry.getKey();
                viewId = entry.getValue();
                if (viewId == null || viewId == 0L || viewKey == null || viewKey.indexOf(95) != -1) continue;
                for (Map _areaMap : keySet.values()) {
                    if (_areaMap.containsKey(viewKey)) continue;
                    _areaMap.put(viewKey, viewId);
                }
            }
        }
        if (hasMultiView) {
            String[] rc = null;
            IKDOlapRequest _request = null;
            ArrayList<IKDOlapRequest> requests = new ArrayList<IKDOlapRequest>(keySet.size() + 1);
            ArrayList<IKDQuery> removes = new ArrayList<IKDQuery>(request.getOlapQuery().getQueries().size());
            for (IKDQuery query : request.getOlapQuery().getQueries()) {
                if (query.getId() == null) continue;
                HashMap rcKeyMaps = Maps.newHashMapWithExpectedSize((int)32);
                rc = query.getId().split("_");
                keyMaps = (Map)keySet.get(rc[0]);
                if (keyMaps != null) {
                    rcKeyMaps.putAll(keyMaps);
                }
                if (rc.length > 1 && (keyMaps = (Map)keySet.get(rc[1])) != null) {
                    rcKeyMaps.putAll(keyMaps);
                }
                if (rcKeyMaps == null || rcKeyMaps.isEmpty()) continue;
                _request = null;
                for (IKDOlapRequest _tmpRequest : requests) {
                    for (IKDQuery _tmpQuery : _tmpRequest.getOlapQuery().getQueries()) {
                        Map tmpKeyMaps = (Map)keySet.get(_tmpQuery.getId());
                        if (tmpKeyMaps == null || !tmpKeyMaps.equals(rcKeyMaps)) continue;
                        _request = _tmpRequest;
                        break;
                    }
                    if (_request == null) continue;
                    break;
                }
                if (_request == null) {
                    _request = request.copy();
                    _request.getOlapQuery().clearQuery();
                    _request.getOlapQuery().addQuery(query);
                    _request.getOlapQuery().addViews(rcKeyMaps);
                    _request.getProperties().setPropertyValue("IGNORE_SAVE", KDValue.valueOf(BgConstant.TRUE_STR));
                    keySet.put(query.getId(), rcKeyMaps);
                    requests.add(_request);
                } else {
                    _request.getOlapQuery().addQuery(query);
                }
                removes.add(query);
            }
            request.getOlapQuery().removeQuery(removes);
            if (!request.getOlapQuery().getQueries().isEmpty()) {
                requests.add(request);
            }
            return requests.toArray(new IKDOlapRequest[requests.size()]);
        }
        return new IKDOlapRequest[]{request};
    }

    @Override
    public Map<String, Object> query(Long cubeId, Long busModelId, Long datasetId, SelectCommandInfo queryInfo) {
        List<IKDCell> cells;
        if (cubeId == null || cubeId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapServiceCaller_4", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (busModelId == null || busModelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u4e1a\u52a1\u6a21\u578bid\u4e0d\u80fd\u4e3a\u7a7a\u6216\u80050\u3002", (String)"OlapServiceCaller_5", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (datasetId == null || datasetId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\u6216\u80050\u3002", (String)"OlapServiceCaller_6", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (queryInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapServiceCaller_7", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        HashMap<String, BigDecimal> cellMap = null;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)cubeId);
        IKDOlapRequest request = KDOlapRequestUtils.of(modelCacheHelper, cubeId, busModelId, datasetId, queryInfo, null);
        if (request != null && (cells = this.query(request)) != null && !cells.isEmpty()) {
            StringBuilder str = new StringBuilder();
            cellMap = new HashMap(cells.size());
            ArrayList dims = new ArrayList(queryInfo.getDimensions().size());
            int in = queryInfo.getDimensions().size();
            for (int i = 0; i < in; ++i) {
                dims.add(queryInfo.getDimensions().get(i));
            }
            Map dimIndexMap = modelCacheHelper.getDimIndexMap(false);
            for (IKDCell cell : cells) {
                str.setLength(0);
                int in2 = dims.size();
                for (int i = 0; i < in2; ++i) {
                    str.append(cell.getMeta().getNumber()[(Integer)dimIndexMap.get(dims.get(i))]);
                }
                cellMap.put(str.toString(), cell.getValue().getDecimal());
            }
        }
        if (cellMap == null) {
            cellMap = new HashMap<String, BigDecimal>();
        }
        return cellMap;
    }

    @Override
    public List<IKDCell> get(@NotNull IKDOlapRequest request) {
        this.verifyQuery(request);
        if (request.getOlapQuery().getQueries().isEmpty()) {
            return new ArrayList<IKDCell>();
        }
        List<IKDCell> cells = new ArrayList<IKDCell>();
        IKDOlapServer server = KDServerManager.getInstance().getServer(request.getOlapServerName());
        IKDQueryView view = server.getSession(request.getCubeId()).get(request);
        if (view != null) {
            cells = view.getCells();
        }
        return cells;
    }

    @Override
    public void execute(@NotNull IKDOlapRequest request) {
        if (request == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapServiceCaller_8", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (request.getCubeId() == null || request.getCubeId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a\u62160\u3002", (String)"OlapServiceCaller_9", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (request.getOlapData() == null || !request.getOlapData().check()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6267\u884c\u9519\u8bef\uff0c\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapServiceCaller_10", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        IKDOlapServer server = KDServerManager.getInstance().getServer(request.getOlapServerName());
        server.getSession(request.getCubeId()).execute(request);
    }

    @Override
    public Map<String, List<List<FloatValue>>> floatData(@NotNull IKDOlapRequest request) {
        return new HashMap<String, List<List<FloatValue>>>();
    }

    @Override
    public boolean existData(Long cubeId, String dimensionNumber, Set<Long> memberIds) {
        if (cubeId == null || dimensionNumber == null || memberIds == null || memberIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"OlapServiceCaller_12", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        LogStats stats = new LogStats("budget-data-log : ");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)cubeId);
        Dimension dimension = modelCacheHelper.getDimension(dimensionNumber);
        if (ShrekOlapServiceHelper.isStartShrek()) {
            HashSet numbers = Sets.newHashSetWithExpectedSize((int)memberIds.size());
            HashMap datasetMap = null;
            if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
                datasetMap = Maps.newHashMapWithExpectedSize((int)memberIds.size());
                List members = dimension.getMembers(memberIds, null);
                for (Member member : members) {
                    numbers.add(member.getNumber());
                }
                for (Member member : members) {
                    Set accounts = datasetMap.computeIfAbsent(member.getDatasetId(), f -> Sets.newLinkedHashSet());
                    accounts.add(member.getNumber());
                }
            }
            List datasets = DatasetServiceHelper.getAllDatasets((Long)cubeId);
            for (Dataset dataset : datasets) {
                if (datasetMap != null && !datasetMap.containsKey(dataset.getId())) continue;
                Long busModelByDataSet = modelCacheHelper.getBusModelByDataSet(dataset.getId());
                if (View.NoViewDimNums.contains(dimensionNumber)) {
                    if (!SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
                        List members = dimension.getMembers(memberIds, null);
                        Iterator iterator = members.iterator();
                        while (iterator.hasNext()) {
                            Member member = (Member)iterator.next();
                            numbers.add(member.getNumber());
                        }
                    }
                } else {
                    for (Long memberId : memberIds) {
                        Member memberByAnyView = modelCacheHelper.getMemberByAnyView(busModelByDataSet, dimensionNumber, memberId);
                        if (memberByAnyView == null) continue;
                        numbers.add(memberByAnyView.getNumber());
                    }
                }
                SelectCommandInfo command = new SelectCommandInfo();
                command.addMeasures(new String[]{"FMONEY"});
                command.addDims(new String[]{dimensionNumber});
                if (datasetMap != null) {
                    command.addFilter(dimensionNumber, ((Set)datasetMap.get(dataset.getId())).toArray(new String[0]));
                } else {
                    command.addFilter(dimensionNumber, numbers.toArray(new String[0]));
                }
                ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)modelCacheHelper.getModelobj(), (Dataset)dataset, (SelectCommandInfo)command, (LogStats)stats);
                Throwable throwable = null;
                try {
                    while (reader.hasNext()) {
                        Object[] values = reader.next();
                        if (values != null && values[0] == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        return false;
    }
}

