/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.analysiscanvas.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.olap.analysiscanvas.model.AnalysisCanvasDataset;
import org.apache.commons.collections4.CollectionUtils;

public class AnalysisCanvasDatasetService {
    private static final Log log = LogFactory.getLog(AnalysisCanvasDatasetService.class);
    private static final String ENTITY_NAME = "eb_analysiscanvas_dataset";

    public static AnalysisCanvasDatasetService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCanvasDatasetService() {
    }

    public AnalysisCanvasDataset loadMaxSeqByDataset(Long datasetId) {
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,dataset,canvasid,analysiscubeid,analysiscubenum,boxid,bseq", (QFilter[])new QFilter[]{new QFilter("dataset", "=", (Object)datasetId)}, (String)"bseq desc", (int)1);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return null;
        }
        return this.transToModel((DynamicObject)dataList.get(0));
    }

    public AnalysisCanvasDataset loadByBox(Long boxId, Long datasetId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id,dataset,canvasid,analysiscubeid,analysiscubenum,boxid,bseq", (QFilter[])new QFilter[]{new QFilter("boxid", "=", (Object)boxId).and("dataset", "=", (Object)datasetId)});
        if (dynamicObject == null) {
            return null;
        }
        return this.transToModel(dynamicObject);
    }

    public List<AnalysisCanvasDataset> loadByBox(Long boxId) {
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,dataset,canvasid,analysiscubeid,analysiscubenum,boxid,bseq", (QFilter[])new QFilter[]{new QFilter("boxid", "=", (Object)boxId)});
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public List<AnalysisCanvasDataset> loadByCanvas(Long canvasId) {
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,dataset,canvasid,analysiscubeid,analysiscubenum,boxid,bseq", (QFilter[])new QFilter[]{new QFilter("canvasid", "=", (Object)canvasId)});
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public List<AnalysisCanvasDataset> loadByDataset(Long datasetId) {
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,dataset,canvasid,analysiscubeid,analysiscubenum,boxid,bseq", (QFilter[])new QFilter[]{new QFilter("dataset", "=", (Object)datasetId)});
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return Collections.emptyList();
        }
        return dataList.stream().map(this::transToModel).collect(Collectors.toList());
    }

    public void add(List<AnalysisCanvasDataset> models) {
        DynamicObject[] objects = (DynamicObject[])models.stream().map(this::packageDynamicObject).toArray(DynamicObject[]::new);
        try (TXHandle tx = TX.required();){
            try {
                Object[] saveRets = SaveServiceHelper.save((DynamicObject[])objects);
                for (int i = 0; i < saveRets.length; ++i) {
                    Object saveRet = saveRets[i];
                    AnalysisCanvasDataset newModel = this.transToModel((DynamicObject)saveRet);
                    AnalysisCanvasDataset model = models.get(i);
                    model.setId(newModel.getId());
                }
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void update(AnalysisCanvasDataset model) {
        DynamicObject dyObj = this.packageDynamicObject(model);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteById(List<Long> Ids) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", Ids)});
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public AnalysisCanvasDataset transToModel(DynamicObject dynamicObject) {
        AnalysisCanvasDataset model = new AnalysisCanvasDataset();
        model.setId(dynamicObject.getLong("id"));
        model.setDataset(dynamicObject.getLong("dataset"));
        model.setCanvasId(dynamicObject.getLong("canvasid"));
        model.setAnalysisCubeId(dynamicObject.getLong("analysiscubeid"));
        model.setAnalysisCubeNum(dynamicObject.getString("analysiscubenum"));
        model.setBoxId(dynamicObject.getLong("boxid"));
        model.setSeq(dynamicObject.getInt("bseq"));
        return model;
    }

    private DynamicObject packageDynamicObject(AnalysisCanvasDataset model) {
        DynamicObject dynamicObject;
        Long id = model.getId();
        if (id == null) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("dataset", (Object)model.getDataset());
        dynamicObject.set("canvasid", (Object)model.getCanvasId());
        dynamicObject.set("analysiscubeid", (Object)model.getAnalysisCubeId());
        dynamicObject.set("analysiscubenum", (Object)model.getAnalysisCubeNum());
        dynamicObject.set("boxid", (Object)model.getBoxId());
        dynamicObject.set("bseq", (Object)model.getSeq());
        return dynamicObject;
    }

    private static class InnerClass {
        private static final AnalysisCanvasDatasetService instance = new AnalysisCanvasDatasetService();

        private InnerClass() {
        }
    }
}

