/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.analysiscanvas.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.olap.analysiscanvas.model.AnalysisCanvasDataset;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCanvasDatasetService;
import kd.epm.eb.olap.service.OlapManager;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class AnalysisCubeService {
    private static final Log log = LogFactory.getLog(AnalysisCubeService.class);
    private final String CACHE_SPLIT_CHAR = ":";
    private final LoadingCache<String, AnalysisCanvasDataset> analysisDsCache;

    public static AnalysisCubeService getInstance() {
        return InnerClass.instance;
    }

    private AnalysisCubeService() {
        int MAX_SIZE = 500;
        int OVER_TIME = 2;
        this.analysisDsCache = CacheBuilder.newBuilder().maximumSize((long)MAX_SIZE).expireAfterAccess((long)OVER_TIME, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, AnalysisCanvasDataset>(){

            public AnalysisCanvasDataset load(@NotNull String key) {
                return AnalysisCubeService.this.loadAnalysisDs(key);
            }
        });
    }

    public AnalysisCanvasDataset getAnalysisDataset(long canvasId, long boxId, long datasetId) {
        String key = this.getCacheKey(canvasId, boxId, datasetId);
        return (AnalysisCanvasDataset)this.analysisDsCache.getUnchecked((Object)key);
    }

    private String getCacheKey(long canvasId, long boxId, long datasetId) {
        return canvasId + ":" + boxId + ":" + datasetId;
    }

    private AnalysisCanvasDataset loadAnalysisDs(String key) {
        String[] arr = key.split(":");
        long canvasId = Long.parseLong(arr[0]);
        long boxId = Long.parseLong(arr[1]);
        long datasetId = Long.parseLong(arr[2]);
        AnalysisCanvasDataset analysisCanvasDataset = AnalysisCanvasDatasetService.getInstance().loadByBox(boxId, datasetId);
        if (analysisCanvasDataset == null) {
            analysisCanvasDataset = this.createAnalysisDataSet(canvasId, boxId, datasetId);
        } else if (analysisCanvasDataset.getAnalysisCubeNum().startsWith("CUBE")) {
            this.createAnalysisDataSet(canvasId, boxId, datasetId);
        } else {
            DynamicObject datasetObj = BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset");
            long modelId = datasetObj.getLong("model.id");
            String sandboxName = ShrekOlapUtils.getSandboxName((int)analysisCanvasDataset.getSeq());
            OlapManager.getInstance().createSandbox(modelId, datasetId, sandboxName);
        }
        return analysisCanvasDataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnalysisCanvasDataset createAnalysisDataSet(long canvasId, long boxId, long datasetId) {
        DLock dLock = DLock.create((String)("bgm/analysis/dataset/create/" + datasetId));
        dLock.fastMode();
        boolean lockFlag = dLock.tryLock(5000L);
        if (!lockFlag) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u4ef6\u5bf9\u5e94\u7684\u6570\u636e\u6d4b\u7b97cube\u521b\u5efa\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AnalysisCubeService_1", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        try {
            Long analysisCubeId;
            DynamicObject datasetObj = BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset");
            long modelId = datasetObj.getLong("model.id");
            AnalysisCanvasDataset analysisCanvasDataset = AnalysisCanvasDatasetService.getInstance().loadByBox(boxId, datasetId);
            if (analysisCanvasDataset != null) {
                String sandboxName = ShrekOlapUtils.getSandboxName((int)analysisCanvasDataset.getSeq());
                OlapManager.getInstance().createSandbox(modelId, datasetId, sandboxName);
                analysisCanvasDataset.setAnalysisCubeNum(sandboxName);
                AnalysisCanvasDatasetService.getInstance().update(analysisCanvasDataset);
                AnalysisCanvasDataset analysisCanvasDataset2 = analysisCanvasDataset;
                return analysisCanvasDataset2;
            }
            int boxSeq = 0;
            AnalysisCanvasDataset analysisDs = AnalysisCanvasDatasetService.getInstance().loadMaxSeqByDataset(datasetId);
            if (analysisDs != null) {
                analysisCubeId = analysisDs.getAnalysisCubeId();
                boxSeq = analysisDs.getSeq() == null ? 0 : analysisDs.getSeq();
            } else {
                analysisCubeId = ID.genLongId();
            }
            String sandboxName = ShrekOlapUtils.getSandboxName((int)(++boxSeq));
            OlapManager.getInstance().createSandbox(modelId, datasetId, sandboxName);
            AnalysisCanvasDataset canvasDataset = new AnalysisCanvasDataset();
            canvasDataset.setDataset(datasetId);
            canvasDataset.setCanvasId(canvasId);
            canvasDataset.setAnalysisCubeId(analysisCubeId);
            canvasDataset.setAnalysisCubeNum(sandboxName);
            canvasDataset.setBoxId(boxId);
            canvasDataset.setSeq(boxSeq);
            AnalysisCanvasDatasetService.getInstance().add(Collections.singletonList(canvasDataset));
            AnalysisCanvasDataset analysisCanvasDataset3 = canvasDataset;
            return analysisCanvasDataset3;
        }
        finally {
            dLock.unlock();
        }
    }

    public void syncForSaveBox(long canvasId, long boxId) {
        List<AnalysisCanvasDataset> canvasDatasetList = AnalysisCanvasDatasetService.getInstance().loadByCanvas(canvasId);
        ArrayList<Long> notExistsDSIds = new ArrayList<Long>(16);
        canvasDatasetList.forEach(ds -> {
            long datasetId = ds.getDataset();
            DynamicObject datasetObj = BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset");
            if (datasetObj == null) {
                notExistsDSIds.add(ds.getId());
                return;
            }
            this.createAnalysisDataSet(canvasId, boxId, datasetId);
        });
        if (CollectionUtils.isNotEmpty(notExistsDSIds)) {
            AnalysisCanvasDatasetService.getInstance().deleteById(notExistsDSIds);
        }
    }

    public void delSandbox(List<Long> boxIdList) {
        boxIdList.forEach(boxId -> {
            List<AnalysisCanvasDataset> canvasDatasetList = AnalysisCanvasDatasetService.getInstance().loadByBox((Long)boxId);
            canvasDatasetList.forEach(ds -> {
                DynamicObject datasetObj = BusinessDataServiceHelper.loadSingleFromCache((Object)ds.getDataset(), (String)"eb_dataset");
                if (datasetObj == null || ds.getSeq() == null) {
                    return;
                }
                DynamicObject modelObj = datasetObj.getDynamicObject("model");
                if (modelObj == null) {
                    return;
                }
                Dataset dataset = Dataset.of((DynamicObject)datasetObj);
                Model model = Model.of((DynamicObject)modelObj);
                String sandboxName = ShrekOlapUtils.getSandboxName((int)ds.getSeq());
                try {
                    OlapManager.getInstance().dropSandbox(model.getId(), dataset.getId(), sandboxName);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
            if (CollectionUtils.isNotEmpty(canvasDatasetList)) {
                canvasDatasetList.forEach(ds -> {
                    String key = this.getCacheKey(ds.getCanvasId(), ds.getBoxId(), ds.getDataset());
                    this.analysisDsCache.invalidate((Object)key);
                });
                List<Long> dsIds = canvasDatasetList.stream().map(AnalysisCanvasDataset::getId).collect(Collectors.toList());
                AnalysisCanvasDatasetService.getInstance().deleteById(dsIds);
            }
        });
    }

    private static class InnerClass {
        private static final AnalysisCubeService instance = new AnalysisCubeService();

        private InnerClass() {
        }
    }
}

