/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.base;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.DataType;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.base.IKDValueType;
import kd.epm.eb.olap.impl.base.KDValueType;

public class KDValue
implements IKDValue {
    private static final long serialVersionUID = 4876066053740792702L;
    private static final int DATA_SCALA = 15;
    public static final IKDValue NULL_VALUE = new KDValue();
    public static final IKDValue TRUE = new KDValue(BgConstant.TRUE_STR);
    public static final IKDValue FALSE = new KDValue(BgConstant.FALSE_STR);
    private IKDValueType valueType = null;
    private String value_str = null;
    private BigDecimal value_decimal = null;
    private Date value_date = null;

    public KDValue() {
        this.valueType = KDValueType.NULL;
    }

    public KDValue(String value) {
        this.setString(value);
    }

    public KDValue(BigDecimal value) {
        this.setDecimal(value);
    }

    public KDValue(Date value) {
        this.setDate(value);
    }

    @Override
    public IKDValueType getValueType() {
        if (this.valueType == null) {
            this.valueType = new KDValueType();
        }
        return this.valueType;
    }

    @Override
    public void setValueType(IKDValueType valueType) {
        this.valueType = valueType;
    }

    @Override
    public boolean isString() {
        return 1 == this.getValueType().getType();
    }

    @Override
    public final void setString(String value) {
        this.setValueType(KDValueType.STRING);
        this.value_str = value;
        if (this.value_str == null) {
            this.clear();
        }
    }

    public static IKDValue valueOf(String value) {
        return value != null ? new KDValue(value) : null;
    }

    @Override
    public String getString() {
        return this.value_str;
    }

    @Override
    public boolean isDecimal() {
        return 0 == this.getValueType().getType();
    }

    @Override
    public final void setDecimal(BigDecimal value) {
        this.setValueType(KDValueType.DECIMAL);
        this.value_decimal = value;
        if (this.value_decimal != null) {
            if (this.value_decimal.scale() > 15) {
                this.value_decimal = this.value_decimal.setScale(15, 4);
            }
        } else {
            this.clear();
        }
    }

    public static IKDValue valueOf(BigDecimal value) {
        return value != null ? new KDValue(value) : NULL_VALUE;
    }

    @Override
    public BigDecimal getDecimal() {
        return this.value_decimal;
    }

    @Override
    public boolean isDate() {
        return 2 == this.getValueType().getType();
    }

    @Override
    public final void setDate(Date value) {
        this.setValueType(KDValueType.DATE);
        this.value_date = value;
        if (this.value_date == null) {
            this.clear();
        }
    }

    public static IKDValue valueOf(Date value) {
        return value != null ? new KDValue(value) : null;
    }

    @Override
    public Date getDate() {
        return this.value_date;
    }

    public static IKDValue valueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return KDValue.valueOf((BigDecimal)value);
        }
        if (value instanceof String) {
            return KDValue.valueOf((String)value);
        }
        if (value instanceof Date) {
            return KDValue.valueOf((Date)value);
        }
        if (value instanceof Number) {
            return KDValue.valueOf(ConvertUtils.toDecimal((Object)value));
        }
        return null;
    }

    @Override
    public void clear() {
        this.valueType = KDValueType.NULL;
        this.value_date = null;
        this.value_decimal = null;
        this.value_str = null;
    }

    @Override
    public boolean compareTo(IKDValue value) {
        if (this == value) {
            return true;
        }
        if (this.isEmpty() && (value == null || value.isEmpty())) {
            return true;
        }
        boolean re = false;
        int valueType = this.getValueType().getType();
        if (valueType == value.getValueType().getType()) {
            switch (valueType) {
                case 0: {
                    re = this.getDecimal().compareTo(value.getDecimal()) == 0;
                    break;
                }
                case 1: {
                    re = this.getString().equals(value.getString());
                    break;
                }
                case 2: {
                    re = this.getDate().compareTo(value.getDate()) == 0;
                    break;
                }
            }
        }
        return re;
    }

    public String toString() {
        if (this.isString()) {
            return this.getString();
        }
        if (this.isDecimal()) {
            return this.getDecimal().toPlainString();
        }
        if (this.isDate()) {
            return (String)DataType.convertValue((DataType)DataType.StringType, (Object)this.getDate());
        }
        return this.getString();
    }

    @Override
    public IKDValue copy() {
        KDValue clone = new KDValue();
        if (this.isDecimal()) {
            clone.setDecimal(this.getDecimal());
        } else if (this.isString()) {
            clone.setString(this.getString());
        } else if (this.isDate()) {
            clone.setDate(this.getDate());
        }
        return clone;
    }

    @Override
    public Object getValue() {
        if (this.isDecimal()) {
            return this.getDecimal();
        }
        if (this.isString()) {
            return this.getString();
        }
        if (this.isDate()) {
            return this.getDate();
        }
        return null;
    }
}

