/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.bizrule;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.eventbus.event.VirtualMemberAddEvent;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.olap.impl.bizrule.RuleExecutionCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleCacheContext;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.jetbrains.annotations.NotNull;

public class RuleCacheService {
    private static final Log log = LogFactory.getLog(RuleCacheService.class);
    public static final String CACHE_RULE_GRAPHNODE_Version_KEY = "epm:cacheRule:v";
    private static final long MODEL_MAX_SIZE = 16L;
    private static final long MODEL_OVER_TIME = 2L;
    private static LoadingCache<Long, RuleCacheContext> caches = CacheBuilder.newBuilder().maximumSize(16L).expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Long, RuleCacheContext>(){

        public RuleCacheContext load(Long bizModelId) {
            return RuleCacheService.getInstance().initCache(bizModelId);
        }
    });

    public static RuleCacheService getInstance() {
        return InnerClass.instance;
    }

    public RuleCacheContext listRuleFromLocalCache(Long bizModelId) {
        RuleCacheContext ruleContext;
        try {
            ruleContext = (RuleCacheContext)caches.get((Object)bizModelId);
        }
        catch (ExecutionException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        String versionNum = this.getVersionFromRedis(bizModelId);
        if (ruleContext != null && !ruleContext.getVersionId().equals(versionNum)) {
            caches.refresh((Object)bizModelId);
            try {
                ruleContext = (RuleCacheContext)caches.get((Object)bizModelId);
            }
            catch (ExecutionException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        if (ruleContext != null) {
            return ruleContext;
        }
        return new RuleCacheContext();
    }

    private String getCacheKey(Long bizModelId) {
        return CACHE_RULE_GRAPHNODE_Version_KEY + bizModelId + "v3";
    }

    public RuleCacheContext initCache(@NotNull Long bizModelId) {
        if (bizModelId == 0L) {
            throw new NullPointerException("getFromCache error.(bizModelId is null)");
        }
        RuleCacheContext ruleContext = new RuleCacheContext();
        String versionNum = this.getVersionFromRedis(bizModelId);
        log.info("\u89c4\u5219\u7f13\u5b58\u7248\u672c\u53f7\uff1a" + versionNum);
        ruleContext.setVersionId(versionNum);
        List<RuleDto> ruleDtos = RuleService.getInstance().listRule(bizModelId, (Boolean)true, null);
        ruleDtos.forEach(r -> {
            List<RuleFunction> functions = r.getFunctions();
            if (functions != null) {
                functions.forEach(f -> f.setFunctionShowStr(""));
            }
        });
        HashMap<String, Set> offSuccessorMap = new HashMap<String, Set>();
        for (RuleDto ruleDto : ruleDtos) {
            try {
                String offSuccessors = ruleDto.getOffSuccessors();
                if (StringUtils.isEmpty((String)offSuccessors)) continue;
                String[] split = offSuccessors.split(",");
                Set refRuleId = offSuccessorMap.computeIfAbsent(ruleDto.getId() + "", v -> new HashSet(16));
                refRuleId.addAll(Arrays.asList(split));
                for (String s : split) {
                    Set refRule = offSuccessorMap.computeIfAbsent(s, v -> new HashSet(16));
                    refRule.add(ruleDto.getId() + "");
                }
            }
            catch (Exception exception) {
            }
        }
        ruleContext.setRuleDtoList(Collections.unmodifiableList(ruleDtos));
        ruleContext.setOffSuccessorMap(Collections.unmodifiableMap(offSuccessorMap));
        return ruleContext;
    }

    private String getVersionFromRedis(Long bizModelId) {
        String versionStr = Cache.get().get(this.getCacheKey(bizModelId));
        if (StringUtils.isNotEmpty((String)versionStr)) {
            return versionStr;
        }
        String newVersionNum = DBServiceHelper.genStringId();
        Cache.get().set(this.getCacheKey(bizModelId), newVersionNum);
        return newVersionNum;
    }

    public void update(VirtualMemberAddEvent event) {
        if (event.getModelId() == null || event.getVirtualMemberMap() == null) {
            return;
        }
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"eb_businessmodel", (QFilter[])new QFilter("model", "=", (Object)event.getModelId()).toArray(), null, (int)1000);
        Map virtualMemberMap = event.getVirtualMemberMap();
        Set<Map.Entry<String, Map<String, String>>> entries = virtualMemberMap.entrySet();
        for (Object bizModelId : pkIds) {
            try {
                RuleCacheContext ruleContext = (RuleCacheContext)caches.get((Object)((Long)bizModelId));
                if (ruleContext == null) continue;
                List<RuleDto> ruleDtoList = ruleContext.getRuleDtoList();
                for (RuleDto ruleDto : ruleDtoList) {
                    Map<String, Set<String>> leftMembers = ruleDto.getLeftMembers();
                    Map<String, Map<String, Set<String>>> rightMembers = ruleDto.getRightMembers();
                    this.appendIn(entries, leftMembers);
                    for (Map<String, Set<String>> value : rightMembers.values()) {
                        this.appendIn(entries, value);
                    }
                }
            }
            catch (ExecutionException e) {
                log.info(CommonServiceHelper.getStackTraceStr((Throwable)e));
            }
        }
    }

    private void appendIn(Set<Map.Entry<String, Map<String, String>>> entries, Map<String, Set<String>> leftMembers) {
        for (Map.Entry<String, Map<String, String>> entry : entries) {
            String dimNumber = entry.getKey();
            Set<String> strings = leftMembers.get(dimNumber);
            if (strings.isEmpty()) continue;
            entry.getValue().forEach((k, v) -> {
                if (strings.contains(k)) {
                    strings.add((String)v);
                }
            });
        }
    }

    public void clearCache(Long bizModelId) {
        if (bizModelId == null) {
            return;
        }
        log.info("\u6e05\u9664\u89c4\u5219\u7f13\u5b58");
        Cache.get().remove(this.getCacheKey(bizModelId));
        caches.invalidate((Object)bizModelId);
        RuleExecutionCacheService.getInstance().clearCache(bizModelId);
    }

    static {
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutor.scheduleAtFixedRate(() -> {
                log.info("\u5b9a\u65f6\u6e05\u7406\u89c4\u5219\u7f13\u5b58");
                caches.cleanUp();
            }, 10L, 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.warn("\u5b9a\u65f6\u6e05\u7406\u89c4\u5219\u7f13\u5b58\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    private static class InnerClass {
        private static RuleCacheService instance = new RuleCacheService();

        private InnerClass() {
        }
    }
}

