/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.bizrule;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleExecutionCacheContext;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;

public class RuleExecutionCacheService {
    private static final Log log = LogFactory.getLog(RuleExecutionCacheService.class);
    public static final String CACHE_RULE_GRAPHNODE_Version_KEY = "epm:cacheRuleExecution:v";
    private static final long MODEL_MAX_SIZE = 16L;
    private static final long MODEL_OVER_TIME = 10L;
    private static LoadingCache<Long, RuleExecutionCacheContext> caches = CacheBuilder.newBuilder().maximumSize(16L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, RuleExecutionCacheContext>(){

        public RuleExecutionCacheContext load(Long bizModelId) {
            return RuleExecutionCacheService.getInstance().initCache(bizModelId);
        }
    });

    public static RuleExecutionCacheService getInstance() {
        return InnerClass.instance;
    }

    public RuleExecutionCacheContext listRuleScopeFromLocalCache(Long bizModelId) {
        RuleExecutionCacheContext ruleContext;
        try {
            ruleContext = (RuleExecutionCacheContext)caches.get((Object)bizModelId);
        }
        catch (ExecutionException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        String versionNum = this.getVersionFromRedis(bizModelId);
        if (ruleContext != null && !ruleContext.getVersionId().equals(versionNum)) {
            caches.refresh((Object)bizModelId);
            try {
                ruleContext = (RuleExecutionCacheContext)caches.get((Object)bizModelId);
            }
            catch (ExecutionException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        if (ruleContext != null) {
            return ruleContext;
        }
        return new RuleExecutionCacheContext();
    }

    private String getCacheKey(Long bizModelId) {
        return CACHE_RULE_GRAPHNODE_Version_KEY + bizModelId + "v1";
    }

    public RuleExecutionCacheContext initCache(Long bizModelId) {
        DynamicObject busDy = BusinessDataServiceHelper.loadSingle((String)"eb_businessmodel", (String)"model.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizModelId)});
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)busDy.getLong("model.id"));
        RuleExecutionCacheContext ruleContext = new RuleExecutionCacheContext();
        String versionNum = this.getVersionFromRedis(bizModelId);
        log.info("\u89c4\u5219\u6267\u884c\u7f13\u5b58\u7248\u672c\u53f7\uff1a" + versionNum);
        ruleContext.setVersionId(versionNum);
        List<RuleDto> ruleDtos = RuleCacheService.getInstance().listRuleFromLocalCache(bizModelId).getRuleDtoList();
        List filterRules = ruleDtos.stream().filter(rule -> {
            String ruleMet = rule.getLeftMembers().get(SysDimensionEnum.Metric.getNumber()).iterator().next();
            Member ruleMetMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, ruleMet);
            if (ruleMetMember.hasAgg()) {
                return false;
            }
            Map<String, Map<String, Set<String>>> rightMembers = rule.getRightMembers();
            for (Map<String, Set<String>> rightMemberScope : rightMembers.values()) {
                Member rMetMember;
                Set<String> rMetSet = rightMemberScope.get(SysDimensionEnum.Metric.getNumber());
                if (rMetSet == null || rMetSet.isEmpty() || !(rMetMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, rMetSet.iterator().next())).hasAgg()) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        HashMap<Long, Map<String, Set<String>>> ruleExecutionLeftMap = new HashMap<Long, Map<String, Set<String>>>(10);
        for (RuleDto rule2 : filterRules) {
            HashMap executionLeftMap = Maps.newHashMapWithExpectedSize((int)5);
            rule2.getLeftMembers().forEach((k, v) -> {
                Set newSet = executionLeftMap.computeIfAbsent(k, val -> Sets.newHashSet());
                v.forEach(e -> newSet.addAll(modelCache.getMember(k, rule2.getViewMap().get(k), e, RangeEnum.ALL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet())));
            });
            ruleExecutionLeftMap.put(rule2.getId(), executionLeftMap);
        }
        ruleContext.setRuleExecutionLeftMap(ruleExecutionLeftMap);
        return ruleContext;
    }

    private String getVersionFromRedis(Long bizModelId) {
        String versionStr = Cache.get().get(this.getCacheKey(bizModelId));
        if (StringUtils.isNotEmpty((String)versionStr)) {
            return versionStr;
        }
        String newVersionNum = DBServiceHelper.genStringId();
        Cache.get().set(this.getCacheKey(bizModelId), newVersionNum);
        return newVersionNum;
    }

    public void clearCache(Long bizModelId) {
        if (bizModelId == null) {
            return;
        }
        Cache.get().remove(this.getCacheKey(bizModelId));
        caches.invalidate((Object)bizModelId);
    }

    static {
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutor.scheduleAtFixedRate(() -> {
                log.info("\u5b9a\u65f6\u6e05\u7406\u89c4\u5219\u6267\u884c\u7f13\u5b58");
                caches.cleanUp();
            }, 10L, 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.warn("\u5b9a\u65f6\u6e05\u7406\u89c4\u5219\u6267\u884c\u7f13\u5b58", (Throwable)e);
        }
    }

    private static class InnerClass {
        private static RuleExecutionCacheService instance = new RuleExecutionCacheService();

        private InnerClass() {
        }
    }
}

