/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.bizrule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleNodeBo;
import kd.epm.eb.olap.impl.bizrule.entity.RuleRightItemDto;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import org.apache.commons.lang3.StringUtils;

public class RuleTraceHelper {
    public static void findRuleToGraph(RuleTraceContext ctx) {
        List<RuleNodeBo> matchRules = RuleTraceHelper.matchRules(ctx, ctx.getLeftScope());
        MutableGraph<RuleNodeBo> graph = ctx.getGraph();
        for (RuleNodeBo rule : matchRules) {
            graph.addNode((Object)rule);
        }
        for (RuleNodeBo rule : matchRules) {
            RuleTraceHelper.findRuleToGraph(ctx, rule);
        }
    }

    public static void findRuleToGraph(RuleTraceContext ctx, RuleNodeBo currRule) {
        List<RuleNodeBo> rightRules = RuleTraceHelper.findRightRules(ctx, currRule);
        if (rightRules.isEmpty()) {
            return;
        }
        MutableGraph<RuleNodeBo> graph = ctx.getGraph();
        Set nodes = graph.nodes();
        for (RuleNodeBo rightRule : rightRules) {
            String ruleId = rightRule.getRuleId();
            Set sameRules = nodes.stream().filter(e -> StringUtils.startsWith((CharSequence)e.getRuleId(), (CharSequence)ruleId)).collect(Collectors.toSet());
            if (!sameRules.isEmpty()) {
                if (sameRules.size() == 1) {
                    ((RuleNodeBo)sameRules.iterator().next()).setRuleId(ruleId + "_1");
                    rightRule.setRuleId(ruleId + "_2");
                } else {
                    Integer max = sameRules.stream().map(e -> Integer.parseInt(StringUtils.substringAfterLast((String)e.getRuleId(), (String)"_"))).max(Integer::compareTo).get();
                    max = max + 1;
                    rightRule.setRuleId(ruleId + "_" + max);
                }
            }
            graph.addNode((Object)rightRule);
            graph.putEdge((Object)currRule, (Object)rightRule);
            RuleTraceHelper.findRuleToGraph(ctx, rightRule);
        }
    }

    public static List<RuleNodeBo> findRightRules(RuleTraceContext ctx, RuleNodeBo currRule) {
        ArrayList rightRules = Lists.newArrayList();
        Map<String, Set<String>> leftScope = currRule.getCalcRequest().getMemberInfo();
        IModelCacheHelper modelCache = ctx.getModelCache();
        for (RuleRightItemDto rightItemDto : currRule.getRuleDto().getRuleRightItemDto()) {
            Set<String> metMemberSet;
            Map<String, Set<String>> refMemberMap = rightItemDto.getRefMemberMap();
            if (ctx.isSkipAgg() && (metMemberSet = refMemberMap.get(SysDimensionEnum.Metric.getNumber())) != null && modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metMemberSet.iterator().next()).hasAgg()) continue;
            LinkedHashMap rightRuleScope = Maps.newLinkedHashMap();
            Long rightDataSetId = rightItemDto.getDataSetId();
            List rightDimensionList = modelCache.getDimensionList(rightDataSetId);
            for (Dimension dimension : rightDimensionList) {
                String rDimNumber = dimension.getNumber();
                Set<String> rSet = refMemberMap.get(rDimNumber);
                Set<String> lSet = leftScope.get(rDimNumber);
                if (rSet != null) {
                    rightRuleScope.put(rDimNumber, rSet);
                } else if (lSet != null) {
                    rightRuleScope.put(rDimNumber, lSet);
                } else {
                    String noneNumber = modelCache.getDimension(rDimNumber).getNoneNumber();
                    rightRuleScope.put(rDimNumber, Collections.singleton(noneNumber));
                }
                if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(rDimNumber) || rightItemDto.getPeriodOffset() == null || rightItemDto.getPeriodOffset() == 0) continue;
                Set bpSet = (Set)rightRuleScope.get(SysDimensionEnum.BudgetPeriod.getNumber());
                HashSet bpNewSet = Sets.newHashSet();
                for (String bp : bpSet) {
                    Member bpMember = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), bp, rightItemDto.getPeriodOffset().intValue());
                    if (bpMember == null) continue;
                    bpNewSet.add(bpMember.getNumber());
                }
                rightRuleScope.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpNewSet);
            }
            List<RuleNodeBo> matchRules = RuleTraceHelper.matchRules(ctx, rightRuleScope);
            rightRules.addAll(matchRules);
        }
        return rightRules;
    }

    private static List<RuleNodeBo> matchRules(RuleTraceContext traceRuleContext, Map<String, Set<String>> leftScope) {
        IModelCacheHelper modelCache = traceRuleContext.getModelCache();
        List beMatchRules = traceRuleContext.beMatchRules;
        ArrayList ruleList = Lists.newArrayList();
        HashSet unMatchSet = Sets.newHashSet();
        Map<String, Long> viewMap = traceRuleContext.getViewMap();
        for (RuleDto rule : beMatchRules) {
            Map<String, Set<String>> leftMembers = rule.getLeftMembers();
            String metricNumber = leftMembers.get(SysDimensionEnum.Metric.getNumber()).iterator().next();
            LinkedHashMap exeScope = Maps.newLinkedHashMap();
            for (Map.Entry<String, Set<String>> entry : leftScope.entrySet()) {
                String dimNumber = entry.getKey();
                HashSet memSet = entry.getValue();
                HashSet memSet2 = Sets.newHashSet();
                if (modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber).hasAgg()) {
                    Long viewId = 0L;
                    if (viewMap != null) {
                        viewId = viewMap.get(dimNumber);
                    }
                    Long finalViewId = viewId;
                    memSet.forEach(mem -> {
                        List allChildrenSort = modelCache.getAllChildrenSort(modelCache.getMember(dimNumber, finalViewId, mem), true);
                        memSet2.addAll(allChildrenSort.stream().map(e -> e.getNumber()).collect(Collectors.toSet()));
                    });
                    memSet = memSet2;
                }
                Set<String> ruleMembers = leftMembers.get(dimNumber);
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && ruleMembers == null) {
                    ruleMembers = traceRuleContext.getTotalBpMemberSet();
                }
                if (ruleMembers == null) {
                    exeScope.put(dimNumber, memSet);
                    continue;
                }
                Set interSet = memSet.stream().filter(ruleMembers::contains).collect(Collectors.toSet());
                if (interSet.isEmpty()) {
                    unMatchSet.add(rule.getId());
                    break;
                }
                exeScope.put(dimNumber, interSet);
            }
            if (unMatchSet.contains(rule.getId())) continue;
            Long dsId = modelCache.getMember(SysDimensionEnum.Account.getNumber(), (String)((Set)exeScope.get(SysDimensionEnum.Account.getNumber())).iterator().next()).getDatasetId();
            AlgoCalcRequest calcRequest = new AlgoCalcRequest(modelCache.getModelobj().getId(), dsId, traceRuleContext.getViewMap(), exeScope, Collections.singletonList(rule));
            String ruleId = rule.getId().toString();
            ruleList.add(new RuleNodeBo(ruleId, rule, calcRequest));
        }
        return ruleList;
    }

    public static class RuleTraceContext {
        private Map<String, Set<String>> leftScope;
        private Map<String, Long> viewMap;
        private List<RuleDto> beMatchRules;
        private boolean skipAgg;
        private IModelCacheHelper modelCache;
        private Set<String> totalBpMemberSet = new HashSet<String>(1);
        private MutableGraph<RuleNodeBo> graph = GraphBuilder.directed().allowsSelfLoops(false).build();

        public RuleTraceContext(Map<String, Set<String>> leftScope, List<RuleDto> beMatchRules, IModelCacheHelper modelCache) {
            this.leftScope = leftScope;
            this.beMatchRules = beMatchRules;
            this.modelCache = modelCache;
        }

        public Map<String, Set<String>> getLeftScope() {
            return this.leftScope;
        }

        public void setLeftScope(Map<String, Set<String>> leftScope) {
            this.leftScope = leftScope;
        }

        public Map<String, Long> getViewMap() {
            return this.viewMap;
        }

        public void setViewMap(Map<String, Long> viewMap) {
            this.viewMap = viewMap;
        }

        public List<RuleDto> getBeMatchRules() {
            return this.beMatchRules;
        }

        public void setBeMatchRules(List<RuleDto> beMatchRules) {
            this.beMatchRules = beMatchRules;
        }

        public boolean isSkipAgg() {
            return this.skipAgg;
        }

        public void setSkipAgg(boolean skipAgg) {
            this.skipAgg = skipAgg;
        }

        public IModelCacheHelper getModelCache() {
            return this.modelCache;
        }

        public void setModelCache(IModelCacheHelper modelCache) {
            this.modelCache = modelCache;
        }

        public MutableGraph<RuleNodeBo> getGraph() {
            return this.graph;
        }

        public void setGraph(MutableGraph<RuleNodeBo> graph) {
            this.graph = graph;
        }

        public Set<String> getTotalBpMemberSet() {
            if (this.totalBpMemberSet.isEmpty()) {
                Dimension bpDimension = this.modelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
                this.totalBpMemberSet = bpDimension.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            }
            return this.totalBpMemberSet;
        }
    }
}

