/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.calc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.algo.olap.Connection;
import kd.epm.eb.algo.olap.Driver;
import kd.epm.eb.algo.olap.MdxResult;
import kd.epm.eb.algo.olap.OlapConfig;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.olapdao.BgmdOlapReader;
import kd.epm.eb.common.olapdao.BgmdShrekDao;
import kd.epm.eb.common.olapdao.FixMember;
import kd.epm.eb.common.olapdao.valueConverter.FillDefaultValueConverter;
import kd.epm.eb.common.olapdao.valueConverter.TypeDateValueConverter;
import kd.epm.eb.common.olapdao.valueConverter.ValueConverter;
import kd.epm.eb.olap.impl.bizrule.entity.RuleCalcContext;
import kd.epm.eb.olap.impl.calc.AlgoConnection;
import kd.epm.eb.olap.impl.calc.CubeInput;
import kd.epm.eb.olap.impl.calc.CubeInput2;
import kd.epm.eb.olap.impl.calc.CubeInputIterator;
import kd.epm.eb.olap.impl.calc.DimensionInput;
import kd.epm.eb.olap.impl.calc.EmptyCubeInput;
import kd.epm.eb.olap.impl.utils.OlapUtils;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.request.Options;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AlgoMdxEngine {
    private static final Log log = LogFactory.getLog(AlgoMdxEngine.class);
    private static Map<DataType, Set<MetricDataTypeEnum>> dataTypeSetMap = new HashMap<DataType, Set<MetricDataTypeEnum>>();

    public static AlgoMdxEngine getInstance() {
        return InnerClass.instance;
    }

    private AlgoMdxEngine() {
    }

    public MdxResult executeMdxQuery(Connection conn, String mdxSql, List<String[]>[] dimMemberRelation) {
        return conn.executeMdxQuery(mdxSql, (List[])dimMemberRelation);
    }

    public AlgoConnection singleOpenConnection(IModelCacheHelper modelCache, Dataset dataset, Map<String, Long> viewMap, Map<String, Set<String>> cubeMemberMap, List<QueryRequest> rightRefMemberList, List<FixMember> fixMembers, Map<String, Set<String>> refPropMap, List<String> selectDim, List<String> needAllQueryDimension, Options options, Map<String, Map<String, String>> functionVirtualMap, List<Closeable> closeableList, List<RuleCalcContext> convertRules, Map<String, Long> ruleViewMap) {
        if (functionVirtualMap == null) {
            functionVirtualMap = new HashMap<String, Map<String, String>>(16);
        }
        String xml = this.createXml(modelCache, dataset, cubeMemberMap, new HashSet<String>(), refPropMap);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        HashMap<String, Set<String>> connectionMemberMap = new HashMap<String, Set<String>>(16);
        Map baseViewMap = modelCache.getViewsByDataSet(dataset.getId());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        LinkedList<Input> cubeInputArr = new LinkedList<Input>();
        Map<String, Map<String, String>> finalFunctionVirtualMap = functionVirtualMap;
        Map<String, Set<String>> leftMembers = convertRules.get(0).getRuleDto().getLeftMembers();
        rightRefMemberList.forEach(queryRequest -> {
            Map<String, Set<String>> memberInfoNew;
            Map<String, Set<String>> memberInfo = queryRequest.getMemberInfo();
            Long datasetId = dataset.getId();
            if (datasetId.equals(queryRequest.getDatasetId())) {
                Set memberSet;
                memberInfoNew = new HashMap<String, Set<String>>(memberInfo.size());
                for (Map.Entry entry : memberInfo.entrySet()) {
                    memberSet = entry.getValue() == null ? null : new HashSet((Collection)entry.getValue());
                    memberInfoNew.put((String)entry.getKey(), memberSet);
                }
                for (Map.Entry entry : finalFunctionVirtualMap.entrySet()) {
                    String dimNumber = (String)entry.getKey();
                    Map memberRelation = (Map)entry.getValue();
                    memberSet = memberInfoNew.computeIfAbsent(dimNumber, k -> new HashSet(16));
                    memberSet.addAll(memberRelation.values());
                }
            } else {
                memberInfoNew = memberInfo;
            }
            for (RuleCalcContext ruleCalcContext : convertRules) {
                if (!datasetId.equals(ruleCalcContext.getRuleDto().getDataSetId()) || !ruleCalcContext.isHasVirMember()) continue;
                Map<String, Set<String>> _leftMembers = ruleCalcContext.getRuleDto().getLeftMembers();
                cubeMemberMap.forEach((k, v) -> {
                    Set leftMemberSet = (Set)_leftMembers.get(k);
                    Set tempMemberSet = memberInfoNew.computeIfAbsent((String)k, e -> new HashSet(16));
                    if (CollectionUtils.isEmpty((Collection)leftMemberSet)) {
                        tempMemberSet.addAll(v);
                    } else {
                        tempMemberSet.addAll(leftMemberSet);
                    }
                });
            }
            HashSet emptyDimNumSet = new HashSet(16);
            memberInfoNew.forEach((dimNum, memberNumSet) -> {
                if (CollectionUtils.isEmpty((Collection)memberNumSet)) {
                    emptyDimNumSet.add(dimNum);
                }
            });
            for (String emptyDimNum : emptyDimNumSet) {
                if (cubeMemberMap.containsKey(emptyDimNum)) {
                    memberInfoNew.put(emptyDimNum, Sets.newHashSet((Object[])new String[]{(String)((Set)cubeMemberMap.get(emptyDimNum)).iterator().next()}));
                    continue;
                }
                FixMember fixMember = fixMembers.stream().filter(e -> e.getDimNumber().equals(emptyDimNum)).findFirst().get();
                memberInfoNew.put(emptyDimNum, Sets.newHashSet((Object[])new String[]{fixMember.getMemberNumber()}));
            }
            List<Input> list = this.createCubeInput(modelCache, queryRequest.getDatasetId(), memberInfoNew, fixMembers, selectDim, dataset, finalFunctionVirtualMap, closeableList, leftMembers);
            cubeInputArr.addAll(list);
        });
        if (CollectionUtils.isEmpty(rightRefMemberList) && convertRules.stream().anyMatch(RuleCalcContext::isHasVirMember)) {
            this.handleRightRefMemEmptyByFunVirMember(modelCache, dataset, cubeMemberMap, fixMembers, selectDim, closeableList, convertRules, cubeInputArr, finalFunctionVirtualMap, leftMembers);
        }
        if (cubeInputArr.isEmpty()) {
            cubeInputArr.add((Input)new EmptyCubeInput());
        }
        paramMap.put("cubeInput", cubeInputArr.toArray(new Input[0]));
        this.appendDimMemberToParamMap(modelCache, dataset, viewMap, baseViewMap, cubeMemberMap, null, refPropMap, null, needAllQueryDimension, connectionMemberMap, paramMap, functionVirtualMap, ruleViewMap);
        OlapConfig config = this.getOlapConfig(options);
        config.useLastData = true;
        Connection connection = Driver.openConnection((InputStream)inputStream, paramMap, (OlapConfig)config);
        connection.setId(dataset.getId().toString());
        return new AlgoConnection(xml, paramMap, connectionMemberMap, connection);
    }

    private void handleRightRefMemEmptyByFunVirMember(IModelCacheHelper modelCache, Dataset dataset, Map<String, Set<String>> cubeMemberMap, List<FixMember> fixMembers, List<String> selectDim, List<Closeable> closeableList, List<RuleCalcContext> convertRules, List<Input> cubeInputArr, Map<String, Map<String, String>> finalFunctionVirtualMap, Map<String, Set<String>> leftMembers) {
        String dimensionNumber;
        if (modelCache == null || dataset == null || cubeMemberMap == null || CollectionUtils.isEmpty(convertRules) || cubeInputArr == null || finalFunctionVirtualMap == null) {
            return;
        }
        Long datasetId = dataset.getId();
        List filterRules = convertRules.stream().filter(e -> datasetId.equals(e.getRuleDto().getDataSetId()) && e.isHasVirMember()).collect(Collectors.toList());
        HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(16);
        for (Map.Entry<String, Map<String, String>> entry : finalFunctionVirtualMap.entrySet()) {
            String dimNumber = entry.getKey();
            Map<String, String> memberRelation = entry.getValue();
            Set memberSet = memberInfo.computeIfAbsent(dimNumber, k -> new HashSet(16));
            memberSet.addAll(memberRelation.values());
        }
        for (RuleCalcContext filterRule : filterRules) {
            Map<String, Set<String>> _leftMembers = filterRule.getRuleDto().getLeftMembers();
            cubeMemberMap.forEach((k, v) -> {
                Set leftMemberSet = (Set)_leftMembers.get(k);
                Set tempMemberSet = memberInfo.computeIfAbsent((String)k, e -> new HashSet(16));
                if (CollectionUtils.isEmpty((Collection)leftMemberSet)) {
                    tempMemberSet.addAll(v);
                } else {
                    tempMemberSet.addAll(leftMemberSet);
                }
            });
        }
        List dimensionList = modelCache.getDimensionList(datasetId);
        if (CollectionUtils.isNotEmpty(fixMembers)) {
            Map<String, FixMember> fixMemberMap = fixMembers.stream().collect(Collectors.toMap(FixMember::getDimNumber, v -> v, (v1, v2) -> v1));
            for (Dimension dimension : dimensionList) {
                dimensionNumber = dimension.getNumber();
                if (memberInfo.containsKey(dimensionNumber)) continue;
                FixMember fixMember = (FixMember)fixMemberMap.get(dimensionNumber);
                if (fixMember != null) {
                    memberInfo.put(fixMember.getDimNumber(), Sets.newHashSet((Object[])new String[]{fixMember.getMemberNumber()}));
                    continue;
                }
                memberInfo.put(dimensionNumber, Sets.newHashSet((Object[])new String[]{modelCache.getDimension(dimensionNumber).getNoneNumber()}));
            }
        } else {
            for (Dimension dimension : dimensionList) {
                dimensionNumber = dimension.getNumber();
                if (memberInfo.containsKey(dimensionNumber)) continue;
                memberInfo.put(dimensionNumber, Sets.newHashSet((Object[])new String[]{modelCache.getDimension(dimensionNumber).getNoneNumber()}));
            }
        }
        List<Input> cubeInput = this.createCubeInput(modelCache, datasetId, memberInfo, fixMembers, selectDim, dataset, finalFunctionVirtualMap, closeableList, leftMembers);
        cubeInputArr.addAll(cubeInput);
    }

    private OlapConfig getOlapConfig(Options options) {
        OlapConfig config = new OlapConfig();
        config.BUILD_AUTOJOINFACTSQL = false;
        if (!options.getUseAlgoAgg().booleanValue()) {
            config.useSelfData = true;
        }
        config.FOREAS = true;
        return config;
    }

    public AlgoConnection openConnection(IModelCacheHelper modelCache, Dataset dataset, Map<String, Long> viewMap, Map<String, Set<String>> cubeMemberMap, Map<String, Map<String, List<String>>> noLeafMemberNeedToLeaf, AlgoConnection mainConnection, List<FixMember> fixMembers, Map<String, Set<String>> refPropMap, List<String> funRefDim, List<String> ignoreDim, Options options, Map<String, Map<String, String>> functionVirtualMap, List<Closeable> closeableList, List<RuleCalcContext> convertRules, Map<String, Long> ruleViewMap) {
        if (viewMap == null) {
            viewMap = new HashMap<String, Long>(1);
        }
        if (noLeafMemberNeedToLeaf == null) {
            noLeafMemberNeedToLeaf = new HashMap<String, Map<String, List<String>>>(1);
        }
        if (fixMembers == null) {
            fixMembers = new ArrayList<FixMember>(1);
        }
        if (funRefDim == null) {
            funRefDim = new ArrayList<String>(1);
        }
        if (ignoreDim == null) {
            ignoreDim = new ArrayList<String>(1);
        }
        if (refPropMap == null) {
            refPropMap = new HashMap<String, Set<String>>(1);
        }
        if (functionVirtualMap == null) {
            functionVirtualMap = new HashMap<String, Map<String, String>>(16);
        }
        if (convertRules == null) {
            convertRules = new ArrayList<RuleCalcContext>(16);
        }
        String xml = this.createXml(modelCache, dataset, cubeMemberMap, noLeafMemberNeedToLeaf.keySet(), refPropMap);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        HashMap<String, Set<String>> connectionMemberMap = new HashMap<String, Set<String>>(16);
        Map baseViewMap = modelCache.getViewsByDataSet(dataset.getId());
        Map<String, Object> param = this.getParam(modelCache, dataset, viewMap, baseViewMap, cubeMemberMap, noLeafMemberNeedToLeaf, mainConnection, fixMembers, refPropMap, funRefDim, ignoreDim, connectionMemberMap, options, functionVirtualMap, closeableList, convertRules, ruleViewMap);
        OlapConfig config = this.getOlapConfig(options);
        Connection connection = Driver.openConnection((InputStream)inputStream, param, (OlapConfig)config);
        connection.setId(dataset.getId().toString());
        return new AlgoConnection(xml, param, connectionMemberMap, connection);
    }

    private Map<String, Object> getParam(IModelCacheHelper modelCache, Dataset dataset, Map<String, Long> viewMap, Map<String, Long> baseViewMap, Map<String, Set<String>> cubeMemberMap, Map<String, Map<String, List<String>>> noLeafMemberNeedToLeaf, AlgoConnection mainConnection, List<FixMember> fixMembers, Map<String, Set<String>> refPropMap, List<String> funRefDim, List<String> ignoreDim, Map<String, Set<String>> connectionMemberMap, Options options, Map<String, Map<String, String>> functionVirtualMap, List<Closeable> closeableList, List<RuleCalcContext> convertRules, Map<String, Long> ruleViewMap) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        Input[] cubeInputArr = this.createCubeInput(modelCache, dataset, viewMap, cubeMemberMap, noLeafMemberNeedToLeaf, fixMembers, ignoreDim, options, functionVirtualMap, closeableList, convertRules, ruleViewMap);
        paramMap.put("cubeInput", cubeInputArr);
        this.appendDimMemberToParamMap(modelCache, dataset, viewMap, baseViewMap, cubeMemberMap, mainConnection, refPropMap, funRefDim, ignoreDim, connectionMemberMap, paramMap, functionVirtualMap, ruleViewMap);
        return paramMap;
    }

    private void appendDimMemberToParamMap(IModelCacheHelper modelCache, Dataset dataset, Map<String, Long> viewMap, Map<String, Long> baseViewMap, Map<String, Set<String>> cubeMemberMap, AlgoConnection mainConnection, Map<String, Set<String>> refPropMap, List<String> funRefDim, List<String> ignoreDim, Map<String, Set<String>> connectionMemberMap, Map<String, Object> paramMap, Map<String, Map<String, String>> functionVirtualMap, Map<String, Long> ruleViewMap) {
        if (functionVirtualMap == null) {
            functionVirtualMap = new HashMap<String, Map<String, String>>(16);
        }
        MemberPropCache memberPropCache = null;
        for (Map.Entry<String, Set<String>> entry : cubeMemberMap.entrySet()) {
            String dimensionNum = entry.getKey();
            Dimension dimension = modelCache.getDimension(dimensionNum);
            Set memberSet = connectionMemberMap.computeIfAbsent(dimensionNum, v -> new HashSet(16));
            ArrayList fields = Lists.newArrayListWithCapacity((int)10);
            fields.add(new Field("fid", (DataType)DataType.StringType));
            fields.add(new Field("fnumber", (DataType)DataType.StringType));
            fields.add(new Field("fshownumber", (DataType)DataType.StringType));
            fields.add(new Field("fmemname", (DataType)DataType.StringType));
            fields.add(new Field("fdatatype", (DataType)DataType.StringType));
            if (dimension.isKeepTree()) {
                fields.add(new Field("fparent", (DataType)DataType.StringType));
            }
            if (dimension.hasWeight()) {
                fields.add(new Field("fweight", (DataType)DataType.IntegerType));
            }
            if (dimension.hasAggregate()) {
                fields.add(new Field("faggregate", (DataType)DataType.IntegerType));
            }
            if (dimension.hasProperty()) {
                fields.add(new Field("fdate", (DataType)DataType.LongType));
            }
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                fields.add(new Field("fignore", (DataType)DataType.BooleanType));
            }
            Set<Object> props = new HashSet(1);
            if (refPropMap != null && CollectionUtils.isNotEmpty(props = refPropMap.get(dimensionNum))) {
                memberPropCache = MemberPropCacheService.getOrCreate((Long)modelCache.getModelobj().getId());
                for (String string : props) {
                    fields.add(new Field(string, (DataType)DataType.IntegerType));
                }
            }
            ArrayList members = new ArrayList(16);
            View view = dimension.getView(ruleViewMap.get(dimensionNum));
            List allMembers = view != null ? view.getAllMemberSort() : dimension.getAllMemberSort();
            members.addAll(allMembers);
            ArrayList allMemberRows = Lists.newArrayListWithCapacity((int)members.size());
            for (Member member : members) {
                Object[] memberRow = new Object[fields.size()];
                for (int i = 0; i < fields.size(); ++i) {
                    Field field = (Field)fields.get(i);
                    if ("fid".equals(field.getName())) {
                        memberRow[i] = member.getNumber();
                        continue;
                    }
                    if ("fnumber".equals(field.getName())) {
                        memberSet.add(member.getNumber());
                        memberRow[i] = member.getNumber();
                        continue;
                    }
                    if ("fshownumber".equals(field.getName())) {
                        memberSet.add(member.getShowNumber());
                        memberRow[i] = member.getShowNumber();
                        continue;
                    }
                    if ("fmemname".equals(field.getName())) {
                        memberSet.add(member.getName());
                        memberRow[i] = member.getName();
                        continue;
                    }
                    if ("fdatatype".equals(field.getName())) {
                        memberSet.add(member.getDatatype());
                        memberRow[i] = member.getDatatype();
                        continue;
                    }
                    if ("fparent".equals(field.getName())) {
                        memberRow[i] = member.getParentNumber();
                        continue;
                    }
                    if ("fweight".equals(field.getName())) {
                        memberRow[i] = OlapUtils.getWeight(member);
                        continue;
                    }
                    if ("faggregate".equals(field.getName())) {
                        memberRow[i] = OlapUtils.getAggregate(member);
                        continue;
                    }
                    if ("fdate".equals(field.getName())) {
                        memberRow[i] = member.getPeriodDate().getTime();
                        continue;
                    }
                    if ("fignore".equals(field.getName())) {
                        memberRow[i] = MemberSourceEnum.COSMIC_INVISIBLE.getIndex().equals(member.getSource());
                        continue;
                    }
                    if (props == null || !props.contains(field.getName()) || memberPropCache == null) continue;
                    memberRow[i] = this.getPropValue(memberPropCache, dimensionNum, field.getName(), member.getNumber());
                }
                allMemberRows.add(memberRow);
            }
            Map<String, String> memRelationMap = functionVirtualMap.get(dimensionNum);
            if (memRelationMap != null && !memRelationMap.isEmpty()) {
                Member srcMember = null;
                for (Map.Entry<String, String> memRelEntry : memRelationMap.entrySet()) {
                    String srcMemNum = memRelEntry.getKey();
                    String virMemNum = memRelEntry.getValue();
                    Long viewId = ruleViewMap.getOrDefault(dimensionNum, 0L);
                    srcMember = modelCache.getMember(dimensionNum, viewId, srcMemNum);
                    if (srcMember == null) continue;
                    Object[] memberRow = new Object[fields.size()];
                    for (int i = 0; i < fields.size(); ++i) {
                        Field field = (Field)fields.get(i);
                        if ("fid".equals(field.getName())) {
                            memberRow[i] = virMemNum;
                            continue;
                        }
                        if ("fnumber".equals(field.getName())) {
                            memberSet.add(virMemNum);
                            memberRow[i] = virMemNum;
                            continue;
                        }
                        if ("fshownumber".equals(field.getName())) {
                            memberSet.add(virMemNum);
                            memberRow[i] = virMemNum;
                            continue;
                        }
                        if ("fmemname".equals(field.getName())) {
                            memberSet.add(srcMember.getName());
                            memberRow[i] = srcMember.getName();
                            continue;
                        }
                        if ("fdatatype".equals(field.getName())) {
                            memberSet.add(srcMember.getDatatype());
                            memberRow[i] = srcMember.getDatatype();
                            continue;
                        }
                        if ("fparent".equals(field.getName())) {
                            memberRow[i] = srcMember.getParentNumber();
                            continue;
                        }
                        if ("fweight".equals(field.getName())) {
                            memberRow[i] = 0;
                            continue;
                        }
                        if ("faggregate".equals(field.getName())) {
                            memberRow[i] = 1;
                            continue;
                        }
                        if ("fdate".equals(field.getName())) {
                            memberRow[i] = new Date();
                            continue;
                        }
                        if ("fignore".equals(field.getName())) {
                            memberRow[i] = true;
                            continue;
                        }
                        if (!props.contains(field.getName())) continue;
                        memberRow[i] = -1;
                    }
                    allMemberRows.add(memberRow);
                }
            }
            DimensionInput dimensionInput = new DimensionInput();
            dimensionInput.setRowMeta(new RowMeta(fields.toArray(new Field[0])));
            dimensionInput.setMembers(allMemberRows);
            paramMap.put(dimensionNum, dimensionInput);
        }
    }

    private Integer getPropValue(MemberPropCache memberPropCache, String dimNum, String propNumber, String memNumber) {
        CustomPropertyValue propertyValue = memberPropCache.getPropertyValueByMemNumber(dimNum, propNumber, memNumber);
        if (propertyValue == null) {
            return -1;
        }
        return propertyValue.getGlobalOrder();
    }

    private List<Input> createCubeInput(IModelCacheHelper modelCache, Long datasetId, Map<String, Set<String>> memberInfo, List<FixMember> fixMembers, List<String> selectDim, Dataset dataset, Map<String, Map<String, String>> finalFunctionVirtualMap, List<Closeable> closeableList, Map<String, Set<String>> leftMembers) {
        BigDecimalType dataType;
        LinkedList<Input> cubeInputs = new LinkedList<Input>();
        Set<String> metricNumbers = memberInfo.get(SysDimensionEnum.Metric.getNumber());
        Map viewsByDataSet = modelCache.getViewsByDataSet(datasetId);
        HashMap<String, String> defaultMemberMap = new HashMap<String, String>(16);
        for (String string : selectDim) {
            Long viewId;
            Dimension dimension = modelCache.getDimension(string);
            if (dimension.getMember(viewId = (Long)viewsByDataSet.get(string), dimension.getNoneNumber()) == null) continue;
            defaultMemberMap.put(string, dimension.getNoneNumber());
        }
        if (CollectionUtils.isNotEmpty(metricNumbers)) {
            Set<Member> memberMembers = modelCache.getMembers(null, SysDimensionEnum.Metric.getNumber()).stream().filter(mem -> metricNumbers.contains(mem.getNumber())).collect(Collectors.toSet());
            for (Map.Entry<DataType, Set<MetricDataTypeEnum>> entry : dataTypeSetMap.entrySet()) {
                dataType = entry.getKey();
                Set<MetricDataTypeEnum> metricEnums = entry.getValue();
                Set<String> newMetricNumbers = this.filterByMetricType(memberMembers, metricEnums);
                if (newMetricNumbers.isEmpty()) continue;
                memberInfo.put(SysDimensionEnum.Metric.getNumber(), newMetricNumbers);
                Input input = this.$createCubeInput(modelCache, datasetId, memberInfo, selectDim, defaultMemberMap, (DataType)dataType, dataset, finalFunctionVirtualMap, closeableList, leftMembers);
                cubeInputs.add(input);
            }
            memberInfo.put(SysDimensionEnum.Metric.getNumber(), metricNumbers);
        } else {
            FixMember fixMember = fixMembers.stream().filter(e -> e.getDimNumber().equals(SysDimensionEnum.Metric.getNumber())).findFirst().get();
            Member member = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, fixMember.getMemberNumber());
            MetricDataTypeEnum metricDataTypeEnum = MetricDataTypeEnum.getByIndex((String)member.getDatatype());
            dataType = DataType.BigDecimalType;
            for (Map.Entry<DataType, Set<MetricDataTypeEnum>> entry : dataTypeSetMap.entrySet()) {
                if (!entry.getValue().contains(metricDataTypeEnum)) continue;
                dataType = entry.getKey();
                break;
            }
            Input input = this.$createCubeInput(modelCache, datasetId, memberInfo, selectDim, defaultMemberMap, (DataType)dataType, dataset, finalFunctionVirtualMap, closeableList, leftMembers);
            cubeInputs.add(input);
        }
        return cubeInputs;
    }

    private Input $createCubeInput(IModelCacheHelper modelCache, Long datasetId, Map<String, Set<String>> memberInfo, List<String> selectDim, Map<String, String> defaultMemberMap, DataType dataType, Dataset dataset, Map<String, Map<String, String>> finalFunctionVirtualMap, List<Closeable> closeableList, Map<String, Set<String>> leftMembers) {
        BgmdOlapReader reader;
        ArrayList<Field> fields = new ArrayList<Field>(16);
        fields.add(new Field("fvalue", dataType));
        List<String> allDims = Arrays.asList(modelCache.getDimensionNums(datasetId));
        Map<String, Integer> indexMap = IntStream.range(0, allDims.size()).boxed().collect(Collectors.toMap(allDims::get, i -> i + 1));
        for (String dimNumber : selectDim) {
            Dimension dimension = modelCache.getDimension(dimNumber);
            String aliasDimNumber = this.getDimAlias(dimension);
            fields.add(new Field(aliasDimNumber, dimension.getNumber(), (DataType)DataType.StringType, false));
        }
        RowMeta cubeRowMeta = new RowMeta(fields.toArray(new Field[0]));
        String cubeNumber = AlgoCalcUtils.getCubeNumber(modelCache.getDataSet(datasetId));
        if (datasetId.equals(dataset.getId())) {
            reader = BgmdShrekDao.getInstance().read(modelCache.getModelobj(), cubeNumber, memberInfo, allDims, dataset, finalFunctionVirtualMap, closeableList);
            reader.setSelectDims(allDims);
            reader.setFunctionVirtualMap(finalFunctionVirtualMap);
            reader.setSingleCalc(true);
            reader.setLeftMembers(leftMembers);
        } else {
            reader = BgmdShrekDao.getInstance().read(modelCache.getModelobj(), cubeNumber, memberInfo, allDims, null, null, null);
        }
        reader.registerValueConverter((ValueConverter)FillDefaultValueConverter.getInstance());
        reader.registerValueConverter((ValueConverter)new TypeDateValueConverter(allDims, modelCache));
        CubeInputIterator cubeInputIterator = new CubeInputIterator(selectDim, indexMap, defaultMemberMap, reader);
        return new CubeInput2(cubeRowMeta, cubeInputIterator);
    }

    private Input[] createCubeInput(IModelCacheHelper modelCache, Dataset dataset, Map<String, Long> viewMap, Map<String, Set<String>> cubeMemberMap, Map<String, Map<String, List<String>>> noLeafMemberNeedToLeaf, List<FixMember> fixMembers, List<String> ignoreDim, Options options, Map<String, Map<String, String>> functionVirtualMap, List<Closeable> closeableList, List<RuleCalcContext> convertRules, Map<String, Long> ruleViewMap) {
        ArrayList<CubeInput> cubeInputs = new ArrayList<CubeInput>(2);
        Set<String> metricNumbers = cubeMemberMap.get(SysDimensionEnum.Metric.getNumber());
        if (CollectionUtils.isNotEmpty(metricNumbers)) {
            Set<Member> memberMembers = modelCache.getMembers(null, SysDimensionEnum.Metric.getNumber()).stream().filter(mem -> metricNumbers.contains(mem.getNumber())).collect(Collectors.toSet());
            for (Map.Entry<DataType, Set<MetricDataTypeEnum>> entry : dataTypeSetMap.entrySet()) {
                DataType dataType = entry.getKey();
                Set<MetricDataTypeEnum> metricEnums = entry.getValue();
                Set<String> newMetricNumbers = this.filterByMetricType(memberMembers, metricEnums);
                Set aggMetSet = newMetricNumbers.stream().filter(metNumber -> modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metNumber).hasAgg()).collect(Collectors.toSet());
                Set unAggMetSet = newMetricNumbers.stream().filter(metNumber -> !aggMetSet.contains(metNumber)).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(aggMetSet)) {
                    options.setAgg(true);
                    cubeMemberMap.put(SysDimensionEnum.Metric.getNumber(), aggMetSet);
                    this.appendInCubeInput(modelCache, dataset, viewMap, cubeMemberMap, noLeafMemberNeedToLeaf, fixMembers, ignoreDim, cubeInputs, dataType, options, functionVirtualMap, closeableList, convertRules, ruleViewMap);
                }
                if (!CollectionUtils.isNotEmpty(unAggMetSet)) continue;
                cubeMemberMap.put(SysDimensionEnum.Metric.getNumber(), unAggMetSet);
                options.setAgg(false);
                this.appendInCubeInput(modelCache, dataset, viewMap, cubeMemberMap, noLeafMemberNeedToLeaf, fixMembers, ignoreDim, cubeInputs, dataType, options, functionVirtualMap, closeableList, convertRules, ruleViewMap);
            }
            cubeMemberMap.put(SysDimensionEnum.Metric.getNumber(), metricNumbers);
        } else {
            FixMember fixMember = fixMembers.stream().filter(e -> e.getDimNumber().equals(SysDimensionEnum.Metric.getNumber())).findFirst().get();
            boolean hasAgg = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, fixMember.getMemberNumber()).hasAgg();
            options.setAgg(hasAgg);
            this.appendInCubeInput(modelCache, dataset, viewMap, cubeMemberMap, noLeafMemberNeedToLeaf, fixMembers, ignoreDim, cubeInputs, (DataType)DataType.BigDecimalType, options, functionVirtualMap, closeableList, convertRules, ruleViewMap);
        }
        return (Input[])cubeInputs.toArray(new CubeInput[0]);
    }

    private void appendInCubeInput(IModelCacheHelper modelCache, Dataset dataset, Map<String, Long> viewMap, Map<String, Set<String>> cubeMemberMap, Map<String, Map<String, List<String>>> noLeafMemberNeedToLeaf, List<FixMember> fixMembers, List<String> ignoreDim, List<CubeInput> cubeInputs, DataType dataType, Options options, Map<String, Map<String, String>> functionVirtualMap, List<Closeable> closeableList, List<RuleCalcContext> convertRules, Map<String, Long> ruleViewMap) {
        ArrayList<Field> fields = new ArrayList<Field>(16);
        fields.add(new Field("fvalue", dataType));
        List<String> allDims = Arrays.asList(modelCache.getDimensionNums(dataset.getId()));
        ArrayList selectDims = Lists.newArrayListWithExpectedSize((int)allDims.size());
        for (String dimNumber : allDims) {
            if (!cubeMemberMap.containsKey(dimNumber)) continue;
            selectDims.add(dimNumber);
            Dimension dimension = modelCache.getDimension(dimNumber);
            String aliasDimNumber = this.getDimAlias(dimension);
            fields.add(new Field(aliasDimNumber, dimension.getNumber(), (DataType)DataType.StringType, false));
        }
        RowMeta cubeRowMeta = new RowMeta(fields.toArray(new Field[0]));
        Map<String, Set<String>> shrekQueryMemberMap = this.getQueryMap(modelCache, dataset, viewMap, cubeMemberMap, noLeafMemberNeedToLeaf, fixMembers, ignoreDim, options, ruleViewMap);
        if (shrekQueryMemberMap == null || shrekQueryMemberMap.isEmpty()) {
            return;
        }
        if (functionVirtualMap == null) {
            functionVirtualMap = new HashMap<String, Map<String, String>>(16);
        }
        for (Map.Entry entry : functionVirtualMap.entrySet()) {
            Set queryMemSet;
            String dimNumber = (String)entry.getKey();
            Map memberRelation = (Map)entry.getValue();
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                for (Map.Entry memberMapEntry : memberRelation.entrySet()) {
                    String srcMem = (String)memberMapEntry.getKey();
                    Member member = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, srcMem);
                    if (member == null || !options.getAgg().equals(member.hasAgg())) continue;
                    queryMemSet = shrekQueryMemberMap.computeIfAbsent(dimNumber, k -> new HashSet(16));
                    queryMemSet.add(memberMapEntry.getValue());
                }
                continue;
            }
            queryMemSet = shrekQueryMemberMap.computeIfAbsent(dimNumber, k -> new HashSet(16));
            queryMemSet.addAll(memberRelation.values());
        }
        String cubeNumber = AlgoCalcUtils.getCubeNumber(dataset);
        BgmdOlapReader bgmdOlapReader = BgmdShrekDao.getInstance().read(modelCache.getModelobj(), cubeNumber, shrekQueryMemberMap, (List)selectDims, dataset, functionVirtualMap, closeableList);
        bgmdOlapReader.setSelectDims((List)selectDims);
        bgmdOlapReader.setFunctionVirtualMap(functionVirtualMap);
        bgmdOlapReader.registerValueConverter((ValueConverter)FillDefaultValueConverter.getInstance());
        bgmdOlapReader.registerValueConverter((ValueConverter)new TypeDateValueConverter((List)selectDims, modelCache));
        CubeInput cubeInput = new CubeInput(cubeRowMeta, bgmdOlapReader);
        cubeInputs.add(cubeInput);
    }

    private Set<String> filterByMetricType(Set<Member> memberMembers, Set<MetricDataTypeEnum> metricEnums) {
        return memberMembers.stream().filter(member -> metricEnums.contains(MetricDataTypeEnum.getByIndex((String)member.getDatatype()))).map(BaseCache::getNumber).collect(Collectors.toSet());
    }

    private Map<String, Set<String>> getQueryMap(IModelCacheHelper modelCache, Dataset dataset, Map<String, Long> viewMap, Map<String, Set<String>> cubeMemberMap, Map<String, Map<String, List<String>>> noLeafMemberNeedToLeaf, List<FixMember> fixMembers, List<String> ignoreDim, Options options, Map<String, Long> ruleViewMap) {
        HashMap<String, Set<String>> shrekQueryMemberMap = new HashMap<String, Set<String>>(cubeMemberMap.size());
        for (Map.Entry<String, Set<String>> entry : cubeMemberMap.entrySet()) {
            Set<String> memNumbers;
            Iterator dimNumber = entry.getKey();
            if (ignoreDim != null && ignoreDim.contains(dimNumber)) {
                if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                    List members = modelCache.getMembers(null, dimNumber);
                    memNumbers = members.stream().filter(member -> dataset.getId().equals(member.getDatasetId()) || SysDimensionEnum.Account.getNumber().equals(member.getNumber())).map(BaseCache::getNumber).collect(Collectors.toSet());
                } else {
                    Long viewId = ruleViewMap.getOrDefault(dimNumber, 0L);
                    memNumbers = modelCache.getMembers(viewId, dimNumber).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                }
            } else {
                memNumbers = entry.getValue();
            }
            shrekQueryMemberMap.put((String)((Object)dimNumber), (Set<String>)new HashSet<String>(memNumbers));
        }
        Set budgetPeriods = (Set)shrekQueryMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (CollectionUtils.isNotEmpty((Collection)budgetPeriods)) {
            List leafOfNumbers;
            Member member2;
            HashSet<String> newBudgetPeriods;
            if (options.getAgg().booleanValue()) {
                newBudgetPeriods = new HashSet<String>(16);
                for (String budgetPeriod : budgetPeriods) {
                    member2 = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, budgetPeriod);
                    if (member2.isLeaf()) {
                        newBudgetPeriods.add(member2.getNumber());
                        continue;
                    }
                    leafOfNumbers = modelCache.getLeafOfNumbers(member2);
                    newBudgetPeriods.addAll(leafOfNumbers);
                }
                shrekQueryMemberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), newBudgetPeriods);
            } else {
                newBudgetPeriods = new HashSet(16);
                for (String budgetPeriod : budgetPeriods) {
                    member2 = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, budgetPeriod);
                    newBudgetPeriods.add(member2.getNumber());
                    if (member2.isLeaf()) continue;
                    leafOfNumbers = modelCache.getLeafOfNumbers(member2);
                    newBudgetPeriods.addAll(leafOfNumbers);
                }
                if (newBudgetPeriods.isEmpty()) {
                    return Collections.emptyMap();
                }
                shrekQueryMemberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), newBudgetPeriods);
            }
        }
        if (options.getAgg().booleanValue()) {
            for (Map.Entry entry : shrekQueryMemberMap.entrySet()) {
                String dimNumber = (String)entry.getKey();
                Set memberSet = (Set)entry.getValue();
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || !noLeafMemberNeedToLeaf.containsKey(dimNumber)) continue;
                HashSet leafSet = Sets.newHashSetWithExpectedSize((int)16);
                if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                    for (Object member3 : memberSet) {
                        Member cacheMember = modelCache.getMember(dimNumber, null, (String)member3);
                        if (cacheMember == null || !dataset.getId().equals(cacheMember.getDatasetId()) || cacheMember.isLeaf()) continue;
                        leafSet.addAll(modelCache.getLeafOfNumbers(cacheMember));
                    }
                } else {
                    Object member3;
                    Long viewId = ruleViewMap.getOrDefault(dimNumber, 0L);
                    member3 = memberSet.iterator();
                    while (member3.hasNext()) {
                        String member4 = (String)member3.next();
                        Member cacheMember = modelCache.getMember(dimNumber, viewId, member4);
                        if (cacheMember == null || cacheMember.isLeaf()) continue;
                        leafSet.addAll(modelCache.getLeafOfNumbers(cacheMember));
                    }
                }
                memberSet.addAll(leafSet);
            }
        }
        for (Map.Entry entry : shrekQueryMemberMap.entrySet()) {
            String key = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            Map<String, List<String>> stringListMap = noLeafMemberNeedToLeaf.get(key);
            if (!MapUtils.isNotEmpty(stringListMap)) continue;
            for (Map.Entry<String, List<String>> entry1 : stringListMap.entrySet()) {
                if (SysDimensionEnum.Account.getNumber().equals(key)) {
                    String memberNum = entry1.getKey();
                    Member member5 = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, memberNum);
                    if (member5 != null && !member5.getDatasetId().equals(dataset.getId())) continue;
                }
                if (options.getAgg().booleanValue()) {
                    boolean remove = value.remove(entry1.getKey());
                    if (!remove) continue;
                    value.addAll((Collection)entry1.getValue());
                    continue;
                }
                value.add(entry1.getKey());
                value.addAll((Collection)entry1.getValue());
            }
        }
        for (FixMember fixMember : fixMembers) {
            shrekQueryMemberMap.put(fixMember.getDimNumber(), Sets.newHashSet((Object[])new String[]{fixMember.getMemberNumber()}));
        }
        return shrekQueryMemberMap;
    }

    private static List<Member> filterBpMember(Dimension dimension, List<Member> allMembers, Collection<String> queryMembers) {
        LinkedHashSet periodSet = Sets.newLinkedHashSetWithExpectedSize((int)10);
        if (queryMembers.size() == 1 && queryMembers.iterator().next().equals(SysDimensionEnum.BudgetPeriod.getNumber())) {
            return allMembers.stream().filter(member -> SysDimensionEnum.BudgetPeriod.getNumber().equals(member.getNumber())).collect(Collectors.toList());
        }
        if (queryMembers.size() == 1 && queryMembers.iterator().next().equals(SysDimensionEnum.BudgetPeriod.getNumber())) {
            return allMembers;
        }
        Set years = queryMembers.stream().filter(s -> !s.equals(SysDimensionEnum.BudgetPeriod.getNumber())).map(e -> Integer.parseInt(e.substring(2, 6))).collect(Collectors.toSet());
        int maxYear = years.stream().max(Comparator.comparingInt(Integer::intValue)).get();
        int minYear = years.stream().min(Comparator.comparingInt(Integer::intValue)).get();
        for (int i = minYear - 2; i <= maxYear + 2; ++i) {
            periodSet.add(i);
        }
        LinkedList filter = Lists.newLinkedList();
        LinkedList vxList = Lists.newLinkedList();
        for (Member member2 : allMembers) {
            if (dimension.getNumber().equals(member2.getNumber())) {
                filter.add(member2);
                continue;
            }
            int year = Integer.parseInt(member2.getNumber().substring(2, 6));
            if (!periodSet.contains(year)) continue;
            if (member2.getNumber().endsWith("._inv")) {
                vxList.add(member2);
                continue;
            }
            filter.add(member2);
        }
        filter.addAll(vxList);
        return filter;
    }

    private String createXml(IModelCacheHelper modelCache, Dataset dataset, Map<String, Set<String>> cubeMemberMap, Set<String> needPreDims, Map<String, Set<String>> refPropMap) {
        Document doc = DocumentHelper.createDocument();
        Element schema = doc.addElement("Schema").addAttribute("name", "KDOLAP");
        schema.addElement("Parameter").addAttribute("name", "cubeInput").addAttribute("type", "Table");
        for (Map.Entry<String, Set<String>> entry : cubeMemberMap.entrySet()) {
            Set<String> props;
            String string = entry.getKey();
            schema.addElement("Parameter").addAttribute("name", string).addAttribute("type", "Table");
            Dimension dimension = modelCache.getDimension(string);
            Element dimensionEle = schema.addElement("Dimension").addAttribute("name", dimension.getShortNumber()).addAttribute("primaryKey", "fid").addAttribute("table", dimension.getNumber());
            Element hierarchy = dimensionEle.addElement("Hierarchy").addAttribute("name", dimension.getShortNumber() + " hierarchy");
            Element level = hierarchy.addElement("Level").addAttribute("name", dimension.getShortNumber() + " Level").addAttribute("column", "fid");
            if (dimension.isKeepTree()) {
                level.addAttribute("parentColumn", "fparent");
            }
            if (dimension.isOrder()) {
                level.addAttribute("orderBy", "fnumber");
            }
            level.addElement("Property").addAttribute("name", "name").addAttribute("column", "fnumber");
            level.addElement("Property").addAttribute("name", "shownumber").addAttribute("column", "fshownumber");
            level.addElement("Property").addAttribute("name", "memname").addAttribute("column", "fmemname");
            level.addElement("Property").addAttribute("name", "datatype").addAttribute("column", "fdatatype");
            if (dimension.hasWeight()) {
                level.addElement("Property").addAttribute("name", "weight").addAttribute("column", "fweight");
            }
            if (dimension.hasAggregate()) {
                level.addElement("Property").addAttribute("name", "disableAgg").addAttribute("column", "faggregate");
            }
            if (dimension.hasProperty()) {
                level.addElement("Property").addAttribute("name", "date").addAttribute("column", "fdate");
            }
            if (dimension.hasProperty()) {
                level.addElement("Property").addAttribute("name", "ignore").addAttribute("column", "fignore");
            }
            if (refPropMap == null || !CollectionUtils.isNotEmpty(props = refPropMap.get(string))) continue;
            for (String prop : props) {
                level.addElement("Property").addAttribute("name", prop).addAttribute("column", prop);
            }
        }
        Element cube = schema.addElement("Cube").addAttribute("name", dataset.getNumber()).addAttribute("table", "cubeInput");
        for (String string : needPreDims) {
            if (!cubeMemberMap.containsKey(string)) continue;
            this.dimPutInXml(modelCache, cube, string);
        }
        if (!needPreDims.contains(SysDimensionEnum.BudgetPeriod.getNumber()) && cubeMemberMap.containsKey(SysDimensionEnum.BudgetPeriod.getNumber())) {
            this.dimPutInXml(modelCache, cube, SysDimensionEnum.BudgetPeriod.getNumber());
        }
        for (Map.Entry entry : cubeMemberMap.entrySet()) {
            String dimNum = (String)entry.getKey();
            if (needPreDims.contains(dimNum) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNum)) continue;
            this.dimPutInXml(modelCache, cube, dimNum);
        }
        cube.addElement("Measure").addAttribute("name", "va").addAttribute("column", "fvalue").addAttribute("aggregator", "sum");
        return doc.asXML();
    }

    private void dimPutInXml(IModelCacheHelper modelCache, Element cube, String dimNum) {
        Dimension dimension = modelCache.getDimension(dimNum);
        cube.addElement("DimensionUsage").addAttribute("name", dimension.getShortNumber()).addAttribute("foreignKey", this.getDimAlias(dimension));
    }

    private String getDimAlias(Dimension dimension) {
        return dimension.getNumber();
    }

    static {
        dataTypeSetMap.put((DataType)DataType.BigDecimalType, Sets.newHashSet((Object[])new MetricDataTypeEnum[]{MetricDataTypeEnum.CURRENCY, MetricDataTypeEnum.NONMONETARY, MetricDataTypeEnum.RATE, MetricDataTypeEnum.DATE}));
        dataTypeSetMap.put((DataType)DataType.StringType, Sets.newHashSet((Object[])new MetricDataTypeEnum[]{MetricDataTypeEnum.TEXT, MetricDataTypeEnum.ENUM}));
    }

    private static class InnerClass {
        private static AlgoMdxEngine instance = new AlgoMdxEngine();

        private InnerClass() {
        }
    }
}

