/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.calc;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.olapdao.BgmdOlapReader;

public class CubeInputIterator
implements AutoCloseable,
Iterator {
    private List<String> selectDims;
    private Map<String, Integer> indexMap;
    private Map<String, String> defaultMemberMap;
    private BgmdOlapReader reader;

    public CubeInputIterator(List<String> selectDims, Map<String, Integer> indexMap, Map<String, String> defaultMemberMap, BgmdOlapReader reader) {
        this.selectDims = selectDims;
        this.indexMap = indexMap;
        this.defaultMemberMap = defaultMemberMap;
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    public Object[] next() {
        Object[] next = this.reader.next();
        Object[] values = new Object[this.selectDims.size() + 1];
        values[0] = next[0];
        for (int i = 0; i < this.selectDims.size(); ++i) {
            String selectDim = this.selectDims.get(i);
            Integer index = this.indexMap.get(selectDim);
            values[i + 1] = index != null ? next[index] : this.defaultMemberMap.get(selectDim);
        }
        return values;
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

