/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data;

import java.util.Iterator;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockUtils;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.olap.api.base.IKDProperties;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.base.KDProperties;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.utils.PropertyUtils;

public abstract class AbstractCubeDataUtils
extends KDProperties
implements Runnable {
    private static final long serialVersionUID = -2422334403726809308L;
    private static final Log log = LogFactory.getLog(AbstractCubeDataUtils.class);
    private IKDCube cube = null;
    private IOlapData olapData = null;
    private RequestContext context = null;
    private Map<String, Long> viewIds = null;
    private CubeDataResult result = new CubeDataResult();

    protected IKDCube getCube() {
        return this.cube;
    }

    protected IOlapData getOlapData() {
        return this.olapData;
    }

    public RequestContext getContext() {
        return this.context;
    }

    public void setContext(RequestContext context) {
        this.context = context;
    }

    public void setViewIds(Map<String, Long> viewIds) {
        this.viewIds = viewIds;
    }

    public Map<String, Long> getViewIds() {
        if (this.viewIds == null) {
            this.viewIds = BusinessModelServiceHelper.getEditViewIds((Long)this.getOlapData().getBusModelId());
        }
        return this.viewIds;
    }

    protected void setResult(CubeDataResult result) {
        this.result = result;
    }

    protected CubeDataResult getResult() {
        return this.result;
    }

    public AbstractCubeDataUtils(IKDCube cube, IOlapData olapData, IKDProperties properties) {
        this.cube = cube;
        this.olapData = olapData;
        this.copyProperty(properties);
    }

    @Override
    public void run() {
        this.save();
    }

    public CubeDataResult save() {
        if (this.getCube() == null || this.getOlapData() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AbstractCubeDataUtils_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        this.beforeSave();
        IModelCacheHelper cacheHelper = this.getCube().getModelCache();
        String[] useDimension = this.getOlapData().getUseDimension();
        IKDCell _cell = null;
        Iterator<IKDCell> _cells = this.getOlapData().getCells().iterator();
        IMemberPermCache memberPermCache = null;
        if (!PropertyUtils.isIgnWritePerm(this)) {
            memberPermCache = MemberPermCacheServiceHelper.build((Long)this.getOlapData().getModifierId(), (Long)Long.valueOf(this.getCube().getId()), (Long)this.getOlapData().getBusModelId(), (String[])useDimension);
        }
        IBgmdDataLockCache dataLockCache = null;
        int[] indexs = null;
        if (!PropertyUtils.isIgnodeDataLock(this)) {
            dataLockCache = BgmdDataLockService.getInstance().getDataLockCache(cacheHelper.getModelobj().getId(), this.getOlapData().getBusModelId());
            Map controlDimNumberMap = BgmdDataLockUtils.getControlDimNumberMap();
            indexs = new int[controlDimNumberMap.size()];
            for (int i = 0; i < useDimension.length; ++i) {
                if (!controlDimNumberMap.containsKey(useDimension[i])) continue;
                indexs[((Integer)controlDimNumberMap.get((Object)useDimension[i])).intValue()] = i;
            }
        }
        while (_cells.hasNext()) {
            _cell = _cells.next();
            if (!_cell.isDetail(cacheHelper, useDimension, this.getViewIds()) || !this.isHasPerm(memberPermCache, useDimension, _cell, this.getViewIds())) continue;
            this.addCell(_cell);
        }
        this.afterSave();
        return this.getResult();
    }

    private boolean isHasPerm(IMemberPermCache memberPermCache, String[] useDimension, IKDCell _cell, Map<String, Long> viewIds) {
        if (memberPermCache == null) {
            return true;
        }
        return _cell.hasWrite(memberPermCache, useDimension, viewIds);
    }

    protected abstract void beforeSave();

    protected abstract void addCell(IKDCell var1);

    protected abstract void afterSave();
}

