/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.olap.api.base.IKDProperties;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.data.kd.CubeDataUtils;
import kd.epm.eb.olap.impl.data.shrek.ShrekCubeDataUtils;

public class CubeDataAgent {
    public static CubeDataAgent get() {
        return new CubeDataAgent();
    }

    public CubeDataResult save(IKDCube cube, IKDOlapRequest request) {
        CubeDataResult result;
        if (cube == null || request == null || request.getOlapData() == null || request.getOlapData().getCells() == null || request.getOlapData().getCells().isEmpty()) {
            return new CubeDataResult();
        }
        if (ShrekOlapServiceHelper.isStartShrek()) {
            ShrekCubeDataUtils utils = ShrekCubeDataUtils.get(cube, request.getOlapData(), request.getProperties());
            utils.setPropertyValue("traceId", KDValue.valueOf(JSON.toJSONString((Object)ShrekIdCodeUtils.getDefaultIdCodes((String)request.getId(), null))));
            result = utils.save();
        } else {
            CubeDataUtils utils = CubeDataUtils.get(cube, request.getOlapData(), request.getProperties());
            utils.setPropertyValue("traceId", KDValue.valueOf(JSON.toJSONString((Object)ShrekIdCodeUtils.getDefaultIdCodes((String)request.getId(), null))));
            result = utils.save();
        }
        return result;
    }

    public CubeDataResult save(IKDCube cube, IOlapData olapData, IKDProperties properties, Map<String, Long> viewIds) {
        CubeDataResult result;
        if (cube == null || olapData == null || olapData.getCells() == null || olapData.getCells().isEmpty()) {
            return new CubeDataResult();
        }
        if (ShrekOlapServiceHelper.isStartShrek()) {
            ShrekCubeDataUtils utils = ShrekCubeDataUtils.get(cube, olapData, properties);
            utils.setViewIds(viewIds);
            result = utils.save();
        } else {
            CubeDataUtils utils = CubeDataUtils.get(cube, olapData, properties);
            utils.setViewIds(viewIds);
            result = utils.save();
        }
        return result;
    }
}

