/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.olapdao.DeleteOlapDataLog;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IOlapData;

public class CubeDataLog {
    private static final int LOG_DAY_RANGE = -60;
    private String logTable;
    private IOlapData olapData = null;
    private static final int INDEX_VALUE = 0;
    private static final int INDEX_ORG_ID = 1;
    private static final int INDEX_ACCOUNT_ID = 2;
    private static final int INDEX_KEY = 3;

    protected IOlapData getOlapData() {
        return this.olapData;
    }

    public static CubeDataLog get() {
        return new CubeDataLog();
    }

    public void log(Long cubeId, IOlapData olapData, List<IKDCell> cells) {
        if (cubeId == null || cubeId == 0L || olapData == null || cells == null || cells.isEmpty()) {
            return;
        }
        this.olapData = olapData;
        this.logTable = DeleteOlapDataLog.getInstance().checkLogTable(cubeId);
        this.logInfo(cells);
    }

    public void log(Long cubeId, List<Object[]> cells) {
        if (cubeId == null || cubeId == 0L || cells == null || cells.isEmpty()) {
            return;
        }
        this.logTable = DeleteOlapDataLog.getInstance().checkLogTable(cubeId);
        this.logObject(cells);
    }

    private void logInfo(List<IKDCell> cells) {
        if (this.logTable == null || cells == null || cells.isEmpty()) {
            return;
        }
        ArrayList sqlParams = Lists.newArrayListWithCapacity((int)cells.size());
        Object[] params = null;
        Long modifierId = this.getOlapData().getModifierId();
        DeleteOlapDataLog.getInstance().deleteHistory(this.logTable);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        int orgIndex = this.getOlapData().getOrgDimIndex();
        int accountIndex = this.getOlapData().getAccountDimIndex();
        Dimension orgDim = this.getOlapData().getOrgDim();
        Dimension accountDim = this.getOlapData().getAccountDim();
        HashMap orgMemberMap = Maps.newHashMapWithExpectedSize((int)cells.size());
        HashMap accountMemberMap = Maps.newHashMapWithExpectedSize((int)cells.size());
        for (IKDCell cell : cells) {
            if (cell.getValue() != null && !cell.getValue().isEmpty() || cell.getOldValue() == null || !cell.getOldValue().isDecimal()) continue;
            String orgMember = cell.getMeta().getNumber()[orgIndex];
            String accountMember = cell.getMeta().getNumber()[accountIndex];
            BigDecimal value = cell.getOldValue().getDecimal();
            if (value.scale() > 8) {
                value = value.setScale(8, 4);
            }
            params = new Object[]{null, time, modifierId, this.getOrgMemberId(orgMember, orgDim, orgMemberMap), this.getAccountMemberId(accountMember, accountDim, accountMemberMap), value, cell.getKey(this.getOlapData())};
            sqlParams.add(params);
        }
        if (!sqlParams.isEmpty()) {
            long[] ids = DBServiceHelper.genLongIds((String)this.logTable, (int)sqlParams.size());
            int in = sqlParams.size();
            for (int i = 0; i < in; ++i) {
                ((Object[])sqlParams.get((int)i))[0] = ids[i];
            }
            String sql = "insert into " + this.logTable + "(fid, fmodifytime, fmodifierid, forgunitid, faccountid, fvalue, fdata) values (?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, (List)sqlParams);
        }
    }

    private void logObject(List<Object[]> cells) {
        if (cells == null || cells.isEmpty()) {
            return;
        }
        ArrayList sqlParams = Lists.newArrayListWithCapacity((int)cells.size());
        Object[] params = null;
        Timestamp time = new Timestamp(System.currentTimeMillis());
        Long modifierId = UserUtils.getUserId();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.set(6, -60);
        DB.execute((DBRoute)BgBaseConstant.epm, (String)("delete from " + this.logTable + " where fmodifytime < ?"), (Object[])new Object[]{calendar.getTime()});
        for (Object[] cell : cells) {
            if (!(cell[0] instanceof BigDecimal)) continue;
            params = new Object[]{null, time, modifierId, cell[1], cell[2], cell[0], cell[3]};
            sqlParams.add(params);
        }
        if (!sqlParams.isEmpty()) {
            long[] ids = DBServiceHelper.genLongIds((String)this.logTable, (int)sqlParams.size());
            int in = sqlParams.size();
            for (int i = 0; i < in; ++i) {
                ((Object[])sqlParams.get((int)i))[0] = ids[i];
            }
            String sql = "insert into " + this.logTable + "(fid, fmodifytime, fmodifierid, forgunitid, faccountid, fvalue, fdata) values (?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, (List)sqlParams);
        }
    }

    protected Long getOrgMemberId(String orgMember, Dimension dimension, Map<String, Long> orgMemberMap) {
        return orgMemberMap.computeIfAbsent(orgMember, f -> {
            Member member = dimension.getStructOfMember(orgMember);
            return member != null ? member.getId() : 0L;
        });
    }

    protected Long getAccountMemberId(String accountMember, Dimension dimension, Map<String, Long> accountMemberMap) {
        return accountMemberMap.computeIfAbsent(accountMember, f -> dimension.getMember(accountMember).getId());
    }

    public static Object[] of(Long orgId, Long accountId, String key, BigDecimal value) {
        if (orgId == null || accountId == null || key == null || value == null) {
            return null;
        }
        Object[] obj = new Object[]{value, orgId, accountId, key};
        return obj;
    }
}

