/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data.kd;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.data.kd.ICubeData;

public abstract class AbstractCubeData
implements ICubeData {
    private IKDCube cube;
    private Long datasetId = null;
    private IOlapData olapData;
    private CubeDataResult result;
    private boolean hasNumericData = true;

    protected IKDCube getCube() {
        return this.cube;
    }

    protected Long getDatasetId() {
        return this.datasetId;
    }

    protected IOlapData getOlapData() {
        return this.olapData;
    }

    protected CubeDataResult getResult() {
        return this.result;
    }

    protected boolean isHasNumericData() {
        return this.hasNumericData;
    }

    public AbstractCubeData(IKDCube cube, IOlapData olapData, Long datasetId, CubeDataResult result, boolean hasNumericData) {
        this.cube = cube;
        this.olapData = olapData;
        this.datasetId = datasetId;
        this.result = result;
        this.hasNumericData = hasNumericData;
    }

    protected void checkCubeId() {
        if (this.cube == null || this.cube.getId() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a0\u3002", (String)"AbstractCubeData_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
    }

    protected void checkFactTable(String factTable) {
        if (factTable == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u6570\u636e\u4e8b\u5b9e\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCubeData_1", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
    }

    protected void checkOther(List<IKDCell> cells) {
        String[] dimension;
        IKDCell cell;
        if (this.getOlapData() == null || this.getOlapData().getModifierId() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCubeData_2", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (!(cells == null || cells.isEmpty() || (cell = cells.get(0)) == null || (dimension = this.getOlapData().getUseDimension()) != null && dimension.length == cell.getMeta().getNumber().length)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u6570\u636e\u4e0a\u7684\u7ef4\u5ea6\u4fe1\u606f\u4e0e\u4f53\u7cfb\u4e2d\u7684\u7ef4\u5ea6\u4fe1\u606f\u4e0d\u4e00\u81f4\u3002", (String)"AbstractCubeData_4", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
    }

    protected Integer getDataType(IKDValue value) {
        if (value == null) {
            return 0;
        }
        if (value.isString()) {
            return Integer.valueOf(MetricDataTypeEnum.TEXT.getIndex());
        }
        if (value.isDate()) {
            return Integer.valueOf(MetricDataTypeEnum.DATE.getIndex());
        }
        if (value.isDecimal()) {
            return Integer.valueOf(MetricDataTypeEnum.TEXT.getIndex());
        }
        return 0;
    }

    protected boolean checkCell(IKDCell cell) {
        if (this.isHasNumericData()) {
            return cell.getValue().isDecimal();
        }
        return true;
    }

    protected void checkCellValue(IKDCell cell) {
        String value;
        if (cell != null && cell.getValue().isString() && StringUtils.isNotEmpty((String)(value = cell.getValue().getString())) && value.length() > 2000) {
            value = value.trim().substring(0, 2000);
            cell.getValue().setString(value);
        }
    }
}

