/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data.kd;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.data.kd.CubeDataAddnew;
import kd.epm.eb.olap.impl.data.kd.CubeDataDelete;
import kd.epm.eb.olap.impl.data.kd.CubeDataQuery;
import kd.epm.eb.olap.impl.data.kd.CubeDataUpdate;

public abstract class AbstractDataFacade
implements Callable<CubeDataResult> {
    private IKDCube cube = null;
    private IOlapData olapData = null;
    private Long datasetId = null;
    private Map<String, Long> noneMemberMap = null;
    private String factTable = null;
    private List<IKDCell> cells = null;
    private RequestContext context = null;
    private LogStats stats = null;
    private Map<String, Set<Long>> memberIdsMap = null;
    private CountDownLatch count = null;

    protected IKDCube getCube() {
        return this.cube;
    }

    protected IOlapData getOlapData() {
        return this.olapData;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public void setNoneMemberMap(Map<String, Long> noneMemberMap) {
        this.noneMemberMap = noneMemberMap;
    }

    public Map<String, Long> getNoneMemberMap() {
        return this.noneMemberMap;
    }

    protected void setFactTable(String factTable) {
        this.factTable = factTable;
    }

    protected String getFactTable() {
        return this.factTable;
    }

    protected List<IKDCell> getCells() {
        return this.cells;
    }

    protected RequestContext getContext() {
        return this.context;
    }

    protected LogStats getStats() {
        return this.stats;
    }

    public void setMemberIdsMap(Map<String, Set<Long>> memberIdsMap) {
        this.memberIdsMap = memberIdsMap;
    }

    public Map<String, Set<Long>> getMemberIdsMap() {
        return this.memberIdsMap;
    }

    public void setCount(CountDownLatch count) {
        this.count = count;
    }

    public CountDownLatch getCount() {
        return this.count;
    }

    public AbstractDataFacade(IKDCube cube, IOlapData olapData, String factTable, List<IKDCell> cells, RequestContext context, LogStats stats) {
        this.cube = cube;
        this.olapData = olapData;
        this.factTable = factTable;
        this.cells = cells;
        this.context = context;
        this.stats = stats;
    }

    @Override
    public CubeDataResult call() throws Exception {
        CubeDataResult result = null;
        try {
            result = this.saveData();
        }
        finally {
            this.getCount().countDown();
        }
        return result;
    }

    protected abstract CubeDataResult saveData();

    protected abstract boolean hasNumericData();

    public Map<String, IKDCell> query() {
        HashSet<Long> cellKeys = new HashSet<Long>(this.getCells().size());
        for (IKDCell cell : this.getCells()) {
            cellKeys.add(cell.getDimKey(this.getOlapData(), null));
        }
        return CubeDataQuery.get().query(this.getFactTable(), this.getMemberIdsMap(), cellKeys, this.hasNumericData());
    }

    public int[] executeAddNew(List<IKDCell> cells, CubeDataResult result) {
        return CubeDataAddnew.get(this.getCube(), this.getOlapData(), this.getDatasetId(), this.getNoneMemberMap(), result, this.hasNumericData()).execute(this.getFactTable(), cells);
    }

    protected int[] executeUpdate(List<IKDCell> cells, CubeDataResult result) {
        return CubeDataUpdate.get(this.getCube(), this.getOlapData(), this.getDatasetId(), result, this.hasNumericData()).execute(this.getFactTable(), cells);
    }

    public int[] executeDelete(List<IKDCell> cells, CubeDataResult result) {
        return CubeDataDelete.get(this.getCube(), this.getOlapData(), this.getDatasetId(), result, this.hasNumericData()).execute(this.getFactTable(), cells);
    }
}

