/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data.kd;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.OlapThreadPools;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.data.kd.AbstractDataFacade;
import kd.epm.eb.olap.impl.data.kd.CubeDataFacade;
import kd.epm.eb.olap.impl.data.kd.CubeOtherDataFacade;
import kd.epm.eb.olap.impl.utils.OlapTableUtils;

public class CubeData {
    private static final Log log = LogFactory.getLog(CubeData.class);
    private Map<String, List<IKDCell>> partCells = new ConcurrentHashMap<String, List<IKDCell>>();
    private Map<String, Long> tableSetMap = new ConcurrentHashMap<String, Long>();
    private List<IKDCell> otherCells = new LinkedList<IKDCell>();
    private Long cubeId = null;
    private IKDCube cube = null;
    private IOlapData olapData = null;
    private Map<String, Set<Long>> memberIdsMap = new ConcurrentHashMap<String, Set<Long>>();
    private boolean addTo = false;
    private boolean ignTransaction = false;
    private boolean ignText = false;
    private int accIndex = 0;
    private int verIndex = 0;
    private Dimension accountDim = null;
    private Dimension versionDim = null;
    private LogStats stats = null;
    private Map<String, Boolean> metric_text = new HashMap<String, Boolean>(16);
    private Map<String, String> factKeyMap = new ConcurrentHashMap<String, String>();
    private Map<String, Set<String>> factCacheMap = new ConcurrentHashMap<String, Set<String>>();
    private CubeDataResult result = new CubeDataResult();

    protected Map<String, List<IKDCell>> getPartCells() {
        return this.partCells;
    }

    protected Map<String, Long> getTableSetMap() {
        return this.tableSetMap;
    }

    protected List<IKDCell> getOtherCells() {
        return this.otherCells;
    }

    protected Map<String, Set<Long>> getMemberIdsMap() {
        return Collections.unmodifiableMap(this.memberIdsMap);
    }

    public void setAddTo(boolean addTo) {
        this.addTo = addTo;
    }

    public boolean isAddTo() {
        return this.addTo;
    }

    public void setIgnTransaction(boolean ignTransaction) {
        this.ignTransaction = ignTransaction;
    }

    public boolean isIgnTransaction() {
        return this.ignTransaction;
    }

    public void setIgnText(boolean ignText) {
        this.ignText = ignText;
    }

    public boolean isIgnText() {
        return this.ignText;
    }

    protected LogStats getStats() {
        if (this.stats == null) {
            this.stats = new LogStats("budget-data-log : ");
        }
        return this.stats;
    }

    public CubeData(IKDCube cube, IOlapData olapData) {
        this.cube = cube;
        this.olapData = olapData;
        this.init();
    }

    private void init() {
        Map<String, Dimension> dimensionMap;
        this.getStats().addInfo("begin process save cubeData.");
        this.cubeId = Long.valueOf(this.cube.getId());
        List dimensions = this.olapData.getUseDimensions();
        if (dimensions == null) {
            dimensions = this.olapData.getDatasetId() != null ? this.cube.getModelCache().getDimensionList(this.olapData.getDatasetId()) : this.cube.getModelCache().getDimensionListByBusModel(this.olapData.getBusModelId());
        }
        if ((dimensionMap = this.olapData.getDimensionMap()) == null) {
            dimensionMap = dimensions.stream().collect(Collectors.toMap(BaseCache::getNumber, dimension -> dimension));
            this.olapData.setDimensionMap(dimensionMap);
        }
        Dimension dimension2 = null;
        HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>(dimensions.size());
        int in = this.olapData.getUseDimensions().size();
        for (int i = 0; i < in; ++i) {
            dimension2 = this.olapData.getUseDimensions().get(i);
            if (dimension2 == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u7ef4\u5ea6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CubeData_6", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            dimIndexMap.put(dimension2.getNumber(), i);
        }
        this.accIndex = (Integer)dimIndexMap.get(SysDimensionEnum.Account.getNumber());
        this.verIndex = (Integer)dimIndexMap.get(SysDimensionEnum.Version.getNumber());
        this.accountDim = dimensionMap.get(SysDimensionEnum.Account.getNumber());
        this.versionDim = dimensionMap.get(SysDimensionEnum.Version.getNumber());
        this.factKeyMap.putAll(OlapTableUtils.queryFactTableKey(this.cubeId));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addCell(IKDCell cell) {
        BigDecimal value;
        if (cell == null || cell.getMeta() == null) {
            return;
        }
        if (cell.getValue().isDecimal() && ((value = cell.getValue().getDecimal()).compareTo(BgConstant.MAX_VALUE) > 0 || value.compareTo(BgConstant.MIN_VALUE) < 0)) {
            String dataStr = Arrays.toString(cell.getMeta().getNumber());
            String valueStr = value.stripTrailingZeros().toPlainString();
            throw new KDBizException(ResManager.loadResFormat((String)"\u6700\u5927\u5141\u8bb8\u8f93\u516518\u4f4d\u6570\u503c\uff0c\u201c%1\u201d\u5b58\u5728\u6570\u503c\u201c%2\u201d\u8d85\u51fa\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CubeData_10", (String)"epm-eb-olap", (Object[])new Object[]{dataStr, valueStr}));
        }
        String memberNum = null;
        Dimension dimension = null;
        View view = null;
        Member member = null;
        Set memberIds = null;
        Boolean hasNumeric = Boolean.TRUE;
        Long viewId = null;
        int in = cell.getMeta().getNumber().length;
        for (int i = 0; i < in; ++i) {
            dimension = this.olapData.getUseDimensions().get(i);
            viewId = this.olapData.getViews() != null ? this.olapData.getViews().get(dimension.getNumber()) : null;
            view = dimension.getView(viewId);
            memberNum = cell.getMeta().getNumber()[i];
            Member member2 = member = view != null ? view.getMember(memberNum) : dimension.getMember(memberNum);
            if (member == null) {
                if (view != null) {
                    member = dimension.getStructOfMember(memberNum);
                }
                if (member == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u6307\u5b9a\u7f16\u7801\u201c%2\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"CubeData_9", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getName(), memberNum}));
                }
            }
            if (SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber()) && (hasNumeric = this.getMetric_text().get(member.getNumber())) == null) {
                hasNumeric = MetricDataTypeEnum.CURRENCY.getIndex().equals(member.getDatatype()) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(member.getDatatype()) || MetricDataTypeEnum.RATE.getIndex().equals(member.getDatatype()) ? Boolean.TRUE : Boolean.FALSE;
                this.getMetric_text().put(member.getNumber(), hasNumeric);
            }
            memberIds = this.memberIdsMap.computeIfAbsent(dimension.getNumber(), f -> Sets.newLinkedHashSetWithExpectedSize((int)100));
            memberIds.add(member.getId());
        }
        if (hasNumeric.booleanValue()) {
            Set<String> factTables = this.getPartTable(cell);
            if (factTables == null || factTables.isEmpty()) throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u6570\u636e\u4e8b\u5b9e\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CubeData_0", (String)"epm-eb-olap", (Object[])new Object[0]));
            if (factTables.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u4e00\u6761\u6570\u636e\u4e0d\u80fd\u5b58\u5728\u591a\u4e2a\u6570\u636e\u4e8b\u5b9e\u8868\u3002", (String)"CubeData_5", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            String factTable = factTables.iterator().next();
            List cells = this.getPartCells().computeIfAbsent(factTable, f -> Collections.synchronizedList(new LinkedList()));
            cells.add(cell);
            return;
        } else {
            if (this.isIgnText()) return;
            this.getOtherCells().add(cell);
        }
    }

    protected Map<String, Boolean> getMetric_text() {
        return this.metric_text;
    }

    private Set<String> getPartTable(IKDCell cell) {
        String versionNumber;
        Member version;
        if (cell == null) {
            return null;
        }
        String accountNumber = cell.getMeta().getNumber()[this.accIndex];
        Member account = this.accountDim.getMember(accountNumber);
        Set<String> factTables = OlapTableUtils.getFactDataTable(this.cubeId, account, version = this.versionDim.getMember(versionNumber = cell.getMeta().getNumber()[this.verIndex]), this.factKeyMap, this.factCacheMap, null);
        if (factTables != null) {
            for (String factTable : factTables) {
                this.getTableSetMap().put(factTable, account.getDatasetId());
            }
        }
        return factTables;
    }

    public CubeDataResult update() {
        this.getStats().add("begin save cubeData.");
        try {
            this.updateData();
        }
        finally {
            this.getStats().addInfo("end save cubeData.");
            log.info(this.getStats().toString());
        }
        return this.getResult();
    }

    public CubeDataResult getResult() {
        return this.result;
    }

    protected void updateData() {
        if (this.getPartCells().isEmpty() && this.getOtherCells().isEmpty()) {
            this.getStats().addInfo("partCells is null");
            return;
        }
        this.getStats().addInfo("partCells size =" + this.getPartCells().size());
        Map.Entry<String, List<IKDCell>> entry2 = null;
        RequestContext context = RequestContextCreator.createForThreadPool();
        ArrayList<AbstractDataFacade> tasks = new ArrayList<AbstractDataFacade>(this.getPartCells().size() + 1);
        ArrayList<Future> futures = new ArrayList<Future>(this.getPartCells().size() + 1);
        Map noneMemberMap = MemberServiceHelper.queryNoneMemberIds((Long)Long.valueOf(this.cube.getId()));
        for (Map.Entry<String, List<IKDCell>> entry2 : this.getPartCells().entrySet()) {
            String factTable = entry2.getKey();
            Long datasetId = this.getTableSetMap().get(factTable);
            List<IKDCell> cells = entry2.getValue();
            CubeDataFacade task = new CubeDataFacade(this.cube, this.olapData, factTable, cells, context, this.getStats());
            task.setDatasetId(datasetId);
            task.setNoneMemberMap(noneMemberMap);
            task.setMemberIdsMap(this.getMemberIdsMap());
            task.setAddTo(this.isAddTo());
            task.setIgnTransaction(this.isIgnTransaction());
            tasks.add(task);
        }
        if (!this.getOtherCells().isEmpty()) {
            CubeOtherDataFacade task = new CubeOtherDataFacade(this.cube, this.olapData, null, this.getOtherCells(), context, this.getStats());
            task.setMemberIdsMap(this.getMemberIdsMap());
            tasks.add(task);
        }
        RequestContext _context = RequestContext.getOrCreate();
        CountDownLatch cdl = new CountDownLatch(tasks.size());
        for (AbstractDataFacade task : tasks) {
            task.setCount(cdl);
            Future result = OlapThreadPools.getOlapSavePool().submit((Callable)task, _context);
            if (result == null) continue;
            futures.add(result);
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            log.error("budget-data-log : ", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        for (Future future : futures) {
            try {
                this.getResult().merge((CubeDataResult)future.get());
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }
}

