/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data.kd;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.OlapConstant;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.data.kd.AbstractCubeData;
import kd.epm.eb.olap.impl.data.kd.ICubeData;

public class CubeDataAddnew
extends AbstractCubeData {
    private static final Log log = LogFactory.getLog(CubeDataAddnew.class);
    private Map<String, Long> noneMemberMap = null;

    protected Map<String, Long> getNoneMemberMap() {
        return this.noneMemberMap;
    }

    public static ICubeData get(IKDCube cube, IOlapData olapData, Long datasetId, Map<String, Long> noneMemberMap, CubeDataResult result, boolean hasNumericData) {
        CubeDataAddnew dataNew = new CubeDataAddnew(cube, olapData, datasetId, result, hasNumericData);
        dataNew.noneMemberMap = noneMemberMap;
        return dataNew;
    }

    public CubeDataAddnew(IKDCube cube, IOlapData olapData, Long datasetId, CubeDataResult result, boolean hasNumericData) {
        super(cube, olapData, datasetId, result, hasNumericData);
    }

    @Override
    public int[] execute(String factTable, List<IKDCell> cells) {
        List dimensions;
        if (cells == null || cells.isEmpty()) {
            return null;
        }
        this.checkCubeId();
        this.checkFactTable(factTable);
        this.checkOther(cells);
        List useDimensions = dimensions = this.getOlapData().getUseDimensions();
        int orgIndex = this.getOlapData().getOrgDimIndex();
        boolean hasTransData = false;
        if (this.getDatasetId() != null && this.getDatasetId() != 0L) {
            List datasetDims = this.getCube().getModelCache().getDimensionList(this.getDatasetId());
            Set datasetDimNums = datasetDims.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            Set useDimNums = dimensions.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            if (!useDimNums.containsAll(datasetDimNums) || !datasetDimNums.containsAll(useDimNums)) {
                dimensions = datasetDims;
                hasTransData = true;
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(factTable).append(" (fid, fmodifytime, fmodifierid, fdimid, ");
        if (this.isHasNumericData()) {
            sql.append("fvalue, ");
        } else {
            sql.append("fdata, fdatatype, ");
        }
        for (Dimension dimension : dimensions) {
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                sql.append('f').append(dimension.getFieldMapped()).append(", ");
                continue;
            }
            sql.append((String)OlapConstant.getFieldMap().get(dimension.getNumber())).append(", ");
        }
        sql.setLength(sql.length() - 2);
        sql.append(") values (");
        if (this.isHasNumericData()) {
            sql.append(SqlBatchUtils.getBatchParamsSql((int)(dimensions.size() + 5))).append(')');
        } else {
            sql.append(SqlBatchUtils.getBatchParamsSql((int)(dimensions.size() + 6))).append(')');
        }
        LinkedList<Object[]> sqlParams = new LinkedList<Object[]>();
        ArrayList sqlParam = Lists.newArrayListWithExpectedSize((int)(dimensions.size() + 5));
        String memberNum = null;
        Timestamp modifyTime = new Timestamp(System.currentTimeMillis());
        String key = null;
        HashSet keySet = Sets.newHashSetWithExpectedSize((int)cells.size());
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        Map<String, Long> viewIds = this.getOlapData().getViews();
        for (IKDCell cell : cells) {
            Long orgId;
            Member member;
            Long viewId;
            Dimension dimension;
            int i;
            int in;
            if (cell.getValue().isEmpty() || !this.checkCell(cell)) continue;
            sqlParam.clear();
            sqlParam.add(DBServiceHelper.genGlobalLongId());
            sqlParam.add(modifyTime);
            sqlParam.add(this.getOlapData().getModifierId());
            sqlParam.add(cell.getDimKey(this.getOlapData()));
            if (this.isHasNumericData()) {
                sqlParam.add(cell.getValue().getDecimal());
            } else {
                this.checkCellValue(cell);
                sqlParam.add(cell.getValue().toString());
                sqlParam.add(this.getDataType(cell.getValue()));
            }
            if (hasTransData) {
                memberMap.clear();
                in = useDimensions.size();
                for (i = 0; i < in; ++i) {
                    dimension = (Dimension)useDimensions.get(i);
                    member = dimension.getMember(viewId = viewIds.get(dimension.getNumber()), memberNum = cell.getMeta().getNumber()[i]);
                    if (member == null || member.getId() == 0L) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u65b0\u589e\u5931\u8d25\uff0c\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u6307\u5b9a\u7f16\u7801\u201c%2\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"CubeDataAddnew_0", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getName(), memberNum}));
                    }
                    memberMap.put(dimension.getShortNumber(), member.getId());
                }
                in = dimensions.size();
                for (i = 0; i < in; ++i) {
                    dimension = (Dimension)dimensions.get(i);
                    Long memberId = (Long)memberMap.get(dimension.getShortNumber());
                    if (memberId == null || memberId == 0L) {
                        memberId = this.getNoneMemberMap().get(dimension.getNumber());
                    }
                    sqlParam.add(memberId);
                }
            } else {
                in = dimensions.size();
                for (i = 0; i < in; ++i) {
                    dimension = (Dimension)dimensions.get(i);
                    member = dimension.getMember(viewId = viewIds.get(dimension.getNumber()), memberNum = cell.getMeta().getNumber()[i]);
                    if (member == null || member.getId() == 0L) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u65b0\u589e\u5931\u8d25\uff0c\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u6307\u5b9a\u7f16\u7801\u201c%2\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"CubeDataAddnew_0", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getName(), memberNum}));
                    }
                    sqlParam.add(member.getId());
                }
            }
            if (!keySet.add(key = (orgId = this.isHasNumericData() ? (Long)sqlParam.get(orgIndex + 5) : (Long)sqlParam.get(orgIndex + 6)) + "_" + cell.getDimKey(this.getOlapData()))) continue;
            sqlParams.add(sqlParam.toArray(new Object[sqlParam.size()]));
        }
        int[] re = new int[]{};
        try {
            if (!sqlParams.isEmpty()) {
                re = DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), sqlParams);
            }
        }
        catch (Throwable ex) {
            log.error("budget-data-log : ", ex);
            throw ex;
        }
        return re;
    }
}

