/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data.kd;

import java.util.LinkedList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.data.kd.AbstractCubeData;
import kd.epm.eb.olap.impl.data.kd.ICubeData;

public class CubeDataDelete
extends AbstractCubeData {
    private static final Log log = LogFactory.getLog(CubeDataDelete.class);

    public static ICubeData get(IKDCube cube, IOlapData olapData, Long datasetId, CubeDataResult result, boolean hasNumericData) {
        return new CubeDataDelete(cube, olapData, datasetId, result, hasNumericData);
    }

    public CubeDataDelete(IKDCube cube, IOlapData olapData, Long datasetId, CubeDataResult result, boolean hasNumericData) {
        super(cube, olapData, datasetId, result, hasNumericData);
    }

    @Override
    public int[] execute(String factTable, List<IKDCell> cells) {
        int[] re;
        block8: {
            if (cells == null || cells.isEmpty()) {
                return null;
            }
            this.checkCubeId();
            this.checkFactTable(factTable);
            this.checkOther(cells);
            StringBuilder sql = new StringBuilder();
            if (this.isHasNumericData()) {
                sql.append("delete from ").append(factTable).append(" where fid = ? and fvalue = ?");
            } else {
                sql.append("delete from ").append(factTable).append(" where fid = ?");
            }
            LinkedList<Object[]> sqlParams = new LinkedList<Object[]>();
            for (IKDCell cell : cells) {
                if (cell.getId() == null || cell.getId() == 0L) continue;
                if (this.isHasNumericData()) {
                    sqlParams.add(new Object[]{cell.getId(), cell.getOldValue().getDecimal()});
                    continue;
                }
                sqlParams.add(new Object[]{cell.getId()});
            }
            re = new int[]{};
            try {
                if (sqlParams.isEmpty() || (re = DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), sqlParams)) == null || this.getResult().getResult() != 1) break block8;
                int in = re.length;
                for (int i = 0; i < in; ++i) {
                    if (re[i] != 0) continue;
                    this.getResult().setResult(3);
                    break;
                }
            }
            catch (Throwable ex) {
                log.error("budget-data-log : ", ex);
                throw ex;
            }
        }
        return re;
    }
}

