/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data.kd;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.param.BgParamUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.data.CubeDataLog;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.data.kd.AbstractDataFacade;
import kd.epm.eb.olap.impl.data.kd.CubeDataUpdate;
import kd.epm.eb.olap.impl.data.kd.CubeDataUpdateAddTo;

public class CubeDataFacade
extends AbstractDataFacade {
    private static final Log log = LogFactory.getLog(CubeDataFacade.class);
    private boolean addTo = false;
    private boolean ignTransaction = false;

    public void setAddTo(boolean addTo) {
        this.addTo = addTo;
    }

    public boolean isAddTo() {
        return this.addTo;
    }

    public void setIgnTransaction(boolean ignTransaction) {
        this.ignTransaction = ignTransaction;
    }

    public boolean isIgnTransaction() {
        return this.ignTransaction;
    }

    public CubeDataFacade(IKDCube cube, IOlapData olapData, String factTable, List<IKDCell> cells, RequestContext context, LogStats stats) {
        super(cube, olapData, factTable, cells, context, stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CubeDataResult saveData() {
        CubeDataResult result = new CubeDataResult();
        if (this.getCells() == null || this.getCells().isEmpty()) {
            return result;
        }
        this.getStats().addInfo("begin save cubeData. factTable = " + this.getFactTable() + "; dataSize = " + this.getCells().size());
        try {
            this.check();
            LinkedList<IKDCell> ups = new LinkedList<IKDCell>();
            LinkedList<IKDCell> news = new LinkedList<IKDCell>();
            LinkedList<IKDCell> deletes = new LinkedList<IKDCell>();
            Map<String, IKDCell> queries = this.query();
            if (queries.isEmpty()) {
                news.addAll(this.getCells());
            } else {
                IKDCell oldCell = null;
                String cellKey = null;
                Member member = null;
                Dimension orgDim = this.getCube().getModelCache().getDimension(SysDimensionEnum.Entity.getNumber());
                int orgIndex = this.getOlapData().getOrgDimIndex();
                for (IKDCell cell : this.getCells()) {
                    member = orgDim.getStructOfMember(cell.getMeta().getNumber()[orgIndex]);
                    if (member == null) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u6307\u5b9a\u7f16\u7801\u201c%2\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"CubeDataFacade_6", (String)"epm-eb-olap", (Object[])new Object[]{orgDim.getName(), cell.getMeta().getNumber()[orgIndex]}));
                    }
                    cellKey = member.getId() + "!" + cell.getDimKey(this.getOlapData());
                    oldCell = queries.get(cellKey);
                    if (oldCell != null) {
                        cell.setId(oldCell.getId());
                        cell.setOldValue(oldCell.getValue());
                        if (this.isAddTo()) {
                            ups.add(cell);
                            continue;
                        }
                        if (cell.getValue() == null || cell.getValue().isEmpty()) {
                            if (BgParamUtils.isRemoveBudgetData()) {
                                deletes.add(cell);
                                continue;
                            }
                            cell.setValue(KDValue.valueOf(BigDecimal.ZERO));
                            ups.add(cell);
                            continue;
                        }
                        if (cell.compareValue(oldCell)) continue;
                        ups.add(cell);
                        continue;
                    }
                    if (cell.getValue() == null || cell.getValue().isEmpty()) continue;
                    news.add(cell);
                }
            }
            if (!(news.isEmpty() && ups.isEmpty() && deletes.isEmpty())) {
                if (this.isIgnTransaction()) {
                    this.execute(news, ups, deletes, result);
                } else {
                    this.executeByTrans(news, ups, deletes, result);
                }
                result.getCells().addAll(news);
                result.getCells().addAll(ups);
                result.getCells().addAll(deletes);
                if (!deletes.isEmpty() && BgParamUtils.isWriteDataOperationLog()) {
                    CubeDataLog.get().log(this.getCube().getModelCache().getModelobj().getId(), this.getOlapData(), deletes);
                }
            }
        }
        finally {
            this.getStats().add("end save cubeData.");
        }
        return result;
    }

    private void executeByTrans(List<IKDCell> news, List<IKDCell> ups, List<IKDCell> deletes, CubeDataResult result) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.executeAddNew(news, result);
                this.executeUpdate(ups, result);
                this.executeDelete(deletes, result);
            }
            catch (Exception ex) {
                log.error("budget-data-log : ", (Throwable)ex);
                result.setResult(9);
                result.setMessage(ex.getMessage());
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    private void execute(List<IKDCell> news, List<IKDCell> ups, List<IKDCell> deletes, CubeDataResult result) {
        try {
            this.executeAddNew(news, result);
            this.executeUpdate(ups, result);
            this.executeDelete(deletes, result);
        }
        catch (Exception ex) {
            log.error("budget-data-log : ", (Throwable)ex);
            result.setResult(9);
            result.setMessage(ex.getMessage());
            throw new KDBizException(ex.getMessage());
        }
    }

    @Override
    protected boolean hasNumericData() {
        return true;
    }

    @Override
    protected int[] executeUpdate(List<IKDCell> cells, CubeDataResult result) {
        if (this.isAddTo()) {
            return CubeDataUpdateAddTo.get(this.getCube(), this.getOlapData(), this.getDatasetId(), result, this.hasNumericData()).execute(this.getFactTable(), cells);
        }
        return CubeDataUpdate.get(this.getCube(), this.getOlapData(), this.getDatasetId(), result, this.hasNumericData()).execute(this.getFactTable(), cells);
    }

    private void check() {
        if (this.getCube() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a0\u3002", (String)"CubeDataFacade_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (this.getFactTable() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u6570\u636e\u4e8b\u5b9e\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CubeDataFacade_1", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
    }
}

