/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data.kd;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.metadata.KDCell;

public class CubeDataQuery {
    private static final Log log = LogFactory.getLog(CubeDataQuery.class);

    public static CubeDataQuery get() {
        return new CubeDataQuery();
    }

    public Map<String, IKDCell> query(String factTable, Map<String, Set<Long>> memberIdsMap, Set<Long> cellKeys, boolean hasNumericData) {
        LinkedHashMap cellsMap = Maps.newLinkedHashMapWithExpectedSize((int)200);
        if (cellKeys == null || cellKeys.isEmpty()) {
            return cellsMap;
        }
        Set<Long> orgUnitIds = memberIdsMap.get(SysDimensionEnum.Entity.getNumber());
        if (orgUnitIds == null || orgUnitIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u6ca1\u6709\u7ec4\u7ec7\u5b58\u5728\u6570\u636e\u3002", (String)"CubeDataQuery_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, forgunitid, fdimid, ", new Object[0]);
        if (hasNumericData) {
            sql.append("fvalue", new Object[0]);
        } else {
            sql.append("fdata, fdatatype", new Object[0]);
        }
        sql.append(" from ", new Object[0]).append(factTable, new Object[0]).append(" where ", new Object[0]);
        sql.appendIn("forgunitid", (Object[])orgUnitIds.toArray(new Long[0]));
        sql.append(" and ", new Object[0]);
        sql.appendIn("fdimid", (Object[])cellKeys.toArray(new Long[0]));
        try (DataSet ds = DB.queryDataSet((String)("queryDataSet - " + factTable), (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sql);){
            if (ds != null) {
                IKDCell cell = null;
                Object value = null;
                int dataType = 0;
                for (Row row : ds) {
                    value = hasNumericData ? KDValue.valueOf(row.getBigDecimal("fvalue")) : ((dataType = row.getInteger("fdatatype").intValue()) == 3 ? KDValue.valueOf(row.getString("fdata")) : (dataType == 4 ? KDValue.valueOf(row.getDate("fdata")) : (dataType == 6 ? null : KDValue.valueOf(row.getString("fdata")))));
                    if (value == null) continue;
                    cell = KDCell.of(row.getLong("fid"));
                    cell.setValue((IKDValue)value);
                    cellsMap.put(row.getLong("forgunitid") + "!" + row.getLong("fdimid"), cell);
                }
            }
        }
        catch (Throwable ex) {
            log.error("budget-data-log : ", ex);
            throw ex;
        }
        return cellsMap;
    }
}

