/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data.kd;

import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.data.kd.AbstractCubeData;
import kd.epm.eb.olap.impl.data.kd.ICubeData;

public class CubeDataUpdate
extends AbstractCubeData {
    private static final Log log = LogFactory.getLog(CubeDataUpdate.class);

    public static ICubeData get(IKDCube cube, IOlapData olapData, Long datasetId, CubeDataResult result, boolean hasNumericData) {
        return new CubeDataUpdate(cube, olapData, datasetId, result, hasNumericData);
    }

    public CubeDataUpdate(IKDCube cube, IOlapData olapData, Long datasetId, CubeDataResult result, boolean hasNumericData) {
        super(cube, olapData, datasetId, result, hasNumericData);
    }

    @Override
    public int[] execute(String factTable, List<IKDCell> cells) {
        int[] re;
        block4: {
            if (cells == null || cells.isEmpty()) {
                return null;
            }
            this.checkCubeId();
            this.checkFactTable(factTable);
            this.checkOther(cells);
            String sql = this.getUpdateSql(factTable);
            List<Object[]> sqlParams = this.getSqlParams(cells);
            re = new int[]{};
            try {
                if (sqlParams.isEmpty() || (re = DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, sqlParams)) == null) break block4;
                int in = re.length;
                for (int i = 0; i < in; ++i) {
                    if (re[i] != 0) continue;
                    this.getResult().setResult(3);
                    break;
                }
            }
            catch (Throwable ex) {
                log.error("budget-data-log : ", ex);
                throw ex;
            }
        }
        return re;
    }

    protected String getUpdateSql(String factTable) {
        StringBuilder sql = new StringBuilder();
        if (this.isHasNumericData()) {
            sql.append("update ").append(factTable).append(" set fvalue = ?, fmodifytime = ?, fmodifierid = ? where fid = ? and fvalue = ?");
        } else {
            sql.append("update ").append(factTable).append(" set fdata = ?, fdatatype = ?, fmodifytime = ?, fmodifierid = ? where fid = ?");
        }
        return sql.toString();
    }

    protected List<Object[]> getSqlParams(List<IKDCell> cells) {
        LinkedList<Object[]> sqlParams = new LinkedList<Object[]>();
        Timestamp modifierTime = new Timestamp(System.currentTimeMillis());
        for (IKDCell cell : cells) {
            if (cell.getValue() == null || cell.getValue().isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u9519\u8bef\uff0c\u7a7a\u6570\u636e\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"CubeDataUpdate_0", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            if (cell.getId() == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u9519\u8bef\uff0c\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CubeDataUpdate_1", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            if (this.isHasNumericData()) {
                if (!this.checkCell(cell)) continue;
                sqlParams.add(new Object[]{cell.getValue().getDecimal(), modifierTime, this.getOlapData().getModifierId(), cell.getId(), cell.getOldValue().getDecimal()});
                continue;
            }
            this.checkCellValue(cell);
            sqlParams.add(new Object[]{cell.getValue().toString(), this.getDataType(cell.getValue()), modifierTime, this.getOlapData().getModifierId(), cell.getId()});
        }
        return sqlParams;
    }
}

