/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data.kd;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.data.kd.AbstractDataFacade;
import kd.epm.eb.olap.impl.utils.OlapTableUtils;

public class CubeOtherDataFacade
extends AbstractDataFacade {
    private static final Log log = LogFactory.getLog(CubeOtherDataFacade.class);
    public static final int TEXT_DATA_LENGTH = 2000;

    public CubeOtherDataFacade(IKDCube cube, IOlapData olapData, String factTable, List<IKDCell> cells, RequestContext context, LogStats stats) {
        super(cube, olapData, factTable, cells, context, stats);
    }

    @Override
    public CubeDataResult call() throws Exception {
        CubeDataResult result = null;
        try {
            result = this.saveData();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.getCount().countDown();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CubeDataResult saveData() {
        CubeDataResult result;
        block28: {
            result = new CubeDataResult();
            Long datasetId = this.getOlapData().getDatasetId();
            if (this.getCells() == null || this.getCells().isEmpty() || datasetId == null || datasetId == 0L) {
                return result;
            }
            this.setFactTable(OlapTableUtils.getOtherTableName(datasetId));
            IModelCacheHelper modelCache = this.getCube().getModelCache();
            Long busModelByDataSet = modelCache.getBusModelByDataSet(datasetId);
            this.getStats().add("begin save cubeData. factTable = " + this.getFactTable() + "; cubeData size = " + this.getCells().size());
            LinkedList<IKDCell> ups = new LinkedList<IKDCell>();
            LinkedList<IKDCell> news = new LinkedList<IKDCell>();
            LinkedList<IKDCell> dels = new LinkedList<IKDCell>();
            try {
                if (!this.checkTable(this.getFactTable())) break block28;
                Map<String, IKDCell> queries = this.query();
                if (queries.isEmpty()) {
                    news.addAll(this.getCells());
                } else {
                    IKDCell oldCell = null;
                    String cellKey = null;
                    Member member = null;
                    Dimension orgDim = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
                    int orgIndex = this.getOlapData().getOrgDimIndex();
                    for (IKDCell cell : this.getCells()) {
                        member = modelCache.getMemberByAnyView(busModelByDataSet, orgDim.getNumber(), cell.getMeta().getNumber()[orgIndex]);
                        if (member == null) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u6307\u5b9a\u7f16\u7801\u201c%2\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"CubeOtherDataFacade_2", (String)"epm-eb-olap", (Object[])new Object[]{orgDim.getName(), cell.getMeta().getNumber()[orgIndex]}));
                        }
                        cellKey = member.getId() + "!" + cell.getDimKey(this.getOlapData());
                        if (cell.getValue() != null && cell.getValue().isString()) {
                            String _text = cell.getValue().getString();
                            if (_text != null) {
                                _text = _text.trim().replace("\u3000", "");
                            }
                            cell.setValue(KDValue.valueOf(_text));
                            if (StringUtils.isEmpty((String)_text)) continue;
                        }
                        if ((oldCell = queries.get(cellKey)) != null) {
                            cell.setId(oldCell.getId());
                            cell.setOldValue(oldCell.getValue());
                            if (cell.getValue() == null || cell.getValue().isEmpty() || cell.getValue().isString() && StringUtils.isEmpty((String)cell.getValue().getString())) {
                                dels.add(cell);
                                continue;
                            }
                            if (cell.compareValue(oldCell)) continue;
                            ups.add(cell);
                            continue;
                        }
                        if (cell.getValue() == null || cell.getValue().isEmpty()) continue;
                        news.add(cell);
                    }
                }
                if (news.isEmpty() && ups.isEmpty() && dels.isEmpty()) break block28;
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        this.executeAddNew(news, result);
                        this.executeUpdate(ups, result);
                        this.executeDelete(dels, result);
                    }
                    catch (Exception ex) {
                        log.error("budget-data-log : ", (Throwable)ex);
                        result.setResult(9);
                        result.setMessage(ex.getMessage());
                        tx.markRollback();
                        throw new KDBizException(ResManager.loadResFormat((String)"CubeOtherDataFacade_1:%1", (String)"CubeOtherDataFacade_1", (String)"epm-eb-olap", (Object[])new Object[]{ex.getMessage() != null ? ex.getMessage() : ""}));
                    }
                }
            }
            finally {
                this.getStats().add("end save cubeData. factTable = " + this.getFactTable());
            }
        }
        return result;
    }

    @Override
    protected boolean hasNumericData() {
        return false;
    }

    protected boolean checkTable(String tableName) {
        if (tableName == null) {
            return false;
        }
        if (!SqlBatchUtils.hasTable((String)tableName)) {
            try {
                this.buildTable(tableName);
            }
            catch (Exception ex) {
                log.error("budget-data-log : ", (Throwable)ex);
                throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u4e8b\u5b9e\u8868\u751f\u6210\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CubeOtherDataFacade_3", (String)"epm-eb-olap", (Object[])new Object[]{ex.getMessage() != null ? ex.getMessage() : ""}));
            }
        }
        return true;
    }

    protected void buildTable(String tableName) {
        if (tableName == null) {
            return;
        }
        String pkName = OlapTableUtils.getOtherPKName(this.getOlapData().getDatasetId());
        StringBuilder str = new StringBuilder();
        str.append("create table ").append(tableName).append(" (").append("fid bigint default 0 not null, ").append("fmodifytime datetime, ").append("fmodifierid bigint default 0 not null, ").append("forgunitid bigint default 0 not null, ").append("fdimid bigint default 0 not null, ").append("fdata nvarchar(").append(2000).append("), ").append("fdatatype int default 0 not null, ").append("faccountid bigint default 0 not null, ").append("fbgperiodid bigint default 0 not null, ").append("fcurrencyid bigint default 0 not null, ").append("fversionid bigint default 0 not null, ").append("fatid bigint default 0 not null, ").append("fctid bigint default 0 not null, ").append("fdtid bigint default 0 not null, ").append("fmetricid bigint default 0 not null, ");
        String column = null;
        for (Dimension dimension : this.getOlapData().getUseDimensions()) {
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                column = 'f' + dimension.getFieldMapped();
                column = column.toLowerCase();
            } else {
                column = SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber()) ? "ficid" : null;
            }
            if (column == null) continue;
            str.append(column).append(" bigint default 0 not null, ");
        }
        str.append("constraint ").append(pkName).append(" primary key (fid))");
        DB.execute((DBRoute)BgBaseConstant.epm, (String)str.toString());
        String uniqueIndex = OlapTableUtils.getOtherUXName(this.getOlapData().getDatasetId());
        DB.execute((DBRoute)BgBaseConstant.epm, (String)("create unique index " + uniqueIndex + " on " + tableName + " (forgunitid, fdimid)"));
        String index = OlapTableUtils.getOtherFactIndex(tableName, this.getOlapData().getUseDimensions());
        DB.execute((DBRoute)BgBaseConstant.epm, (String)index);
    }
}

