/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.data.shrek;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.param.BgParamUtils;
import kd.epm.eb.olap.api.base.IKDProperties;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.data.AbstractCubeDataUtils;
import kd.epm.eb.olap.impl.data.CubeDataLog;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.utils.PropertyUtils;
import org.jetbrains.annotations.NotNull;

public class ShrekCubeDataUtils
extends AbstractCubeDataUtils {
    private static final Log log = LogFactory.getLog(ShrekCubeDataUtils.class);
    private boolean isCompareValue = true;
    private boolean isSafe = true;
    private Map<Long, Map<MembersKey, IKDCell>> cellsMap = Maps.newLinkedHashMap();
    private Map<Long, Map<String, Set<String>>> shrekMemberMap = Maps.newLinkedHashMap();
    private boolean isIncrement = false;
    private int accIndex = -1;
    private Dimension accountDim = null;
    private Map<String, Long> accountMap = Maps.newLinkedHashMap();

    public void setCompareValue(boolean compareValue) {
        this.isCompareValue = compareValue;
    }

    public boolean isCompareValue() {
        return this.isCompareValue;
    }

    public void setSafe(boolean safe) {
        this.isSafe = safe;
    }

    public boolean isSafe() {
        return this.isSafe;
    }

    public static ShrekCubeDataUtils get(IKDCube cube, IOlapData olapData, IKDProperties properties) {
        return new ShrekCubeDataUtils(cube, olapData, properties);
    }

    public ShrekCubeDataUtils(IKDCube cube, IOlapData olapData, IKDProperties properties) {
        super(cube, olapData, properties);
    }

    @Override
    public CubeDataResult save() {
        return super.save();
    }

    protected Map<Long, Map<MembersKey, IKDCell>> getCellsMap() {
        return this.cellsMap;
    }

    protected Map<Long, Map<String, Set<String>>> getShrekMemberMap() {
        return this.shrekMemberMap;
    }

    protected void setIncrement(boolean increment) {
        this.isIncrement = increment;
    }

    protected boolean isIncrement() {
        return this.isIncrement;
    }

    @Override
    protected void beforeSave() {
        this.setIncrement(PropertyUtils.hasDataByAddTo(this));
        this.setCompareValue(PropertyUtils.isCompareValue(this));
        this.setSafe(PropertyUtils.isSafe(this));
        this.getCellsMap().clear();
        this.getShrekMemberMap().clear();
    }

    @Override
    protected void addCell(IKDCell cell) {
        if (cell == null) {
            return;
        }
        IModelCacheHelper modelCacheHelper = this.getCube().getModelCache();
        String[] dataDims = this.getOlapData().getUseDimension();
        Long datasetId = this.getOlapData().getDatasetId();
        if (IDUtils.isNull((Long)datasetId)) {
            datasetId = this.getDatasetId(modelCacheHelper, cell, dataDims);
        }
        Dimension metricDim = modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber());
        HashSet refDims = Sets.newHashSetWithExpectedSize((int)dataDims.length);
        Map memberMap = this.getShrekMemberMap().computeIfAbsent(datasetId, f -> Maps.newLinkedHashMap());
        int in = dataDims.length;
        for (int i = 0; i < in; ++i) {
            refDims.add(dataDims[i]);
            Set members = memberMap.computeIfAbsent(dataDims[i], f -> Sets.newLinkedHashSet());
            members.add(cell.getMeta().getNumber()[i]);
            if (!SysDimensionEnum.Metric.getNumber().equals(dataDims[i])) continue;
            Member member = metricDim.getMember(cell.getMeta().getNumber()[i]);
            if (member == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u6307\u5b9a\u7f16\u7801\u201c%2\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"CubeData_9", (String)"epm-eb-olap", (Object[])new Object[]{metricDim.getName(), cell.getMeta().getNumber()[i]}));
            }
            if (cell.getValue().isEmpty()) continue;
            if (MetricUtils.isNumeric((String)member.getDatatype())) {
                if (cell.getValue().isDecimal()) continue;
                cell.setValue(KDValue.valueOf(ConvertUtils.toDecimal((Object)cell.getValue().getValue())));
                continue;
            }
            if (cell.getValue().isString()) continue;
            cell.setValue(KDValue.valueOf(cell.getValue().toString()));
        }
        List dimensions = modelCacheHelper.getDimensionList(datasetId);
        for (Dimension dimension : dimensions) {
            if (refDims.contains(dimension.getNumber())) continue;
            Set members = memberMap.computeIfAbsent(dimension.getNumber(), f -> Sets.newLinkedHashSet());
            members.add(dimension.getNoneNumber());
        }
        Map cellMaps = this.getCellsMap().computeIfAbsent(datasetId, f -> Maps.newLinkedHashMap());
        cellMaps.put(MembersKey.of((String[])cell.getMeta().getNumber()), cell);
    }

    @Override
    protected void afterSave() {
        LinkedHashMap shrekOlapSaves = Maps.newLinkedHashMap();
        IModelCacheHelper modelCacheHelper = this.getCube().getModelCache();
        Model model = modelCacheHelper.getModelobj();
        Object[] dataDims = this.getOlapData().getUseDimension();
        IKDValue traceValue = this.getPropertyValue("traceId");
        Map traceInfo = !traceValue.isEmpty() ? (Map)JSON.parseObject((String)traceValue.toString(), Map.class) : new HashMap();
        IKDValue ignLock = this.getPropertyValue("IGNORE_DATA_LOCK");
        if (ignLock != null && StringUtils.equals((String)Boolean.TRUE.toString(), (String)ignLock.getString())) {
            traceInfo.put("IGNORE_DATA_LOCK", null);
        }
        LogStats stats = new LogStats("budget-data-log : ");
        try {
            for (Map.Entry<Long, Map<String, Set<String>>> entry : this.getShrekMemberMap().entrySet()) {
                Long datasetId = entry.getKey();
                Map<String, Set<String>> memberMap = entry.getValue();
                Map<MembersKey, IKDCell> cellMaps = this.getCellsMap().get(datasetId);
                if (cellMaps == null || cellMaps.isEmpty()) continue;
                DynamicObject datasetObj = DatasetServiceHelper.loadDatasets((Long)datasetId);
                Dataset dataset = Dataset.of((DynamicObject)datasetObj);
                Object[] datasetDims = modelCacheHelper.getDimensionNums(datasetId);
                IShrekSave save = shrekOlapSaves.computeIfAbsent(datasetId, arg_0 -> this.lambda$afterSave$4(model, dataset, (String[])datasetDims, traceInfo, arg_0));
                if (Arrays.equals(dataDims, datasetDims)) {
                    this.saveByEqualsDim(model, dataset, save, (String[])dataDims, memberMap, cellMaps, stats);
                    continue;
                }
                List dimensions = modelCacheHelper.getDimensionList(datasetId);
                this.saveByNotEqualsDim(save, (String[])dataDims, (String[])datasetDims, dimensions, cellMaps, stats);
            }
        }
        catch (Exception ex) {
            log.error("shrek-save-error:", (Throwable)ex);
            throw ex;
        }
        finally {
            for (IShrekSave save : shrekOlapSaves.values()) {
                try {
                    save.close();
                }
                catch (Throwable ex) {
                    log.warn("shrek save close error", ex);
                }
            }
        }
    }

    private boolean safety(Collection<IKDCell> cells) {
        return true;
    }

    private void saveByEqualsDim(@NotNull Model model, @NotNull Dataset dataset, @NotNull IShrekSave save, @NotNull String[] dataDims, @NotNull Map<String, Set<String>> memberMap, @NotNull Map<MembersKey, IKDCell> cellMaps, @NotNull LogStats stats) {
        if (this.isIncrement()) {
            for (IKDCell _cell : cellMaps.values()) {
                save.add(_cell.getMeta().getNumber(), _cell.getValue().getValue());
                this.getResult().getCells().add(_cell);
            }
        } else if (this.isCompareValue()) {
            this.saveCompareByEqualsDim(model, dataset, save, dataDims, memberMap, cellMaps, stats);
        } else {
            this.saveByEqualsDim(save, cellMaps);
        }
    }

    private void saveCompareByEqualsDim(@NotNull Model model, @NotNull Dataset dataset, @NotNull IShrekSave save, @NotNull String[] dataDims, @NotNull Map<String, Set<String>> memberMap, @NotNull Map<MembersKey, IKDCell> cellMaps, @NotNull LogStats stats) {
        if (!this.safety(cellMaps.values())) {
            log.warn("error-command:is all clear data(null).");
            return;
        }
        SelectCommandInfo command = new SelectCommandInfo();
        command.addDims(dataDims);
        command.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        for (Map.Entry<String, Set<String>> dim : memberMap.entrySet()) {
            command.addFilter(dim.getKey(), dim.getValue().toArray(new String[0]));
        }
        LinkedList removes = Lists.newLinkedList();
        try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)model, (Dataset)dataset, (SelectCommandInfo)command, (LogStats)stats);){
            while (reader.hasNext()) {
                IKDCell cell;
                Object[] values = reader.next();
                if (values == null || values[0] == null || (cell = cellMaps.remove(new MembersKey(values))) == null || ConvertUtils.equalValue((Object)cell.getValue().getValue(), (Object)values[0])) continue;
                cell.setOldValue(KDValue.valueOf(values[0]));
                if (cell.getValue().isEmpty()) {
                    removes.add(cell);
                    continue;
                }
                save.add(cell.getMeta().getNumber(), cell.getValue().getValue());
                this.getResult().getCells().add(cell);
            }
        }
        for (IKDCell _cell : cellMaps.values()) {
            if (_cell.getValue().isEmpty()) continue;
            save.add(_cell.getMeta().getNumber(), _cell.getValue().getValue());
            this.getResult().getCells().add(_cell);
        }
        if (!removes.isEmpty()) {
            stats.addInfo("begin-remove");
            stats.addInfo("removes_size:" + removes.size());
            for (IKDCell _cell : removes) {
                save.add(_cell.getMeta().getNumber(), _cell.getValue().getValue());
                this.getResult().getCells().add(_cell);
            }
            stats.add("end-remove");
            if (BgParamUtils.isWriteDataOperationLog()) {
                CubeDataLog.get().log(model.getId(), this.getOlapData(), removes);
            }
        }
    }

    private void saveByEqualsDim(@NotNull IShrekSave save, @NotNull Map<MembersKey, IKDCell> cellMaps) {
        if (!this.safety(cellMaps.values())) {
            log.warn("error-command:is all clear data(null).");
            return;
        }
        for (IKDCell _cell : cellMaps.values()) {
            save.add(_cell.getMeta().getNumber(), _cell.getValue().getValue());
        }
    }

    private void saveByNotEqualsDim(@NotNull IShrekSave save, @NotNull String[] dataDims, @NotNull String[] datasetDims, @NotNull List<Dimension> dimensions, @NotNull Map<MembersKey, IKDCell> cellMaps, @NotNull LogStats stats) {
        stats.addInfo("begin-saveByNotEqualsDim");
        for (IKDCell _cell : cellMaps.values()) {
            save.add(this.getMetas(_cell, dataDims, datasetDims, dimensions), _cell.getValue().getValue());
            this.getResult().getCells().add(_cell);
        }
        stats.add("end-saveByNotEqualsDim");
    }

    protected Long getDatasetId(IModelCacheHelper modelCacheHelper, IKDCell cell, String[] dataDims) {
        if (this.accIndex == -1) {
            int in = dataDims.length;
            for (int i = 0; i < in; ++i) {
                if (!SysDimensionEnum.Account.getNumber().equals(dataDims[i])) continue;
                this.accIndex = i;
                break;
            }
        }
        Long datasetId = this.accountMap.computeIfAbsent(cell.getMeta().getNumber()[this.accIndex], f -> {
            Member account;
            if (this.accountDim == null) {
                this.accountDim = modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber());
            }
            if ((account = this.accountDim.getMember(cell.getMeta().getNumber()[this.accIndex])) == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0b\u6307\u5b9a\u7f16\u7801\u201c%2\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"CubeData_9", (String)"epm-eb-olap", (Object[])new Object[]{this.accountDim.getName(), cell.getMeta().getNumber()[this.accIndex]}));
            }
            return account.getDatasetId();
        });
        return datasetId;
    }

    protected String[] getMetas(IKDCell cell, String[] dataDims, String[] datasetDims, List<Dimension> dimensions) {
        if (cell == null || dataDims == null || datasetDims == null || dimensions == null) {
            return null;
        }
        HashMap metaMap = Maps.newHashMapWithExpectedSize((int)datasetDims.length);
        int in = dataDims.length;
        for (int i = 0; i < in; ++i) {
            metaMap.put(dataDims[i], cell.getMeta().getNumber()[i]);
        }
        for (Dimension dimension : dimensions) {
            if (metaMap.containsKey(dimension.getNumber())) continue;
            metaMap.put(dimension.getNumber(), dimension.getNoneNumber());
        }
        String[] metas = new String[datasetDims.length];
        int in2 = datasetDims.length;
        for (int i = 0; i < in2; ++i) {
            metas[i] = (String)metaMap.get(datasetDims[i]);
        }
        return metas;
    }

    private /* synthetic */ IShrekSave lambda$afterSave$4(Model model, Dataset dataset, String[] datasetDims, Map traceInfo, Long f) {
        if (this.isIncrement()) {
            return ShrekOlapServiceHelper.saveDataByIncrement((Model)model, (Dataset)dataset, (String[])datasetDims, (Map)traceInfo);
        }
        return ShrekOlapServiceHelper.saveData((Model)model, (Dataset)dataset, (String[])datasetDims, (Map)traceInfo);
    }
}

