/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.dataSource;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import kd.epm.eb.olap.api.base.IKDProperties;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IDrillQuery;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.api.metadata.IOlapData;
import kd.epm.eb.olap.api.metadata.IOlapQuery;
import kd.epm.eb.olap.impl.base.KDProperties;
import kd.epm.eb.olap.impl.dataSource.KDOlapRequest;
import kd.epm.eb.olap.impl.dataSource.kd.KDOlapServer;
import kd.epm.eb.olap.impl.metadata.OlapData;

public abstract class AbstractKDOlapRequest
implements IKDOlapRequest,
Serializable {
    private static final long serialVersionUID = -3016137205674697733L;
    private static String olapServerName = null;
    private String id = null;
    private Long cubeId = null;
    private IOlapData olapData = null;
    private IOlapQuery olapQuery = null;
    private IDrillQuery drillQuery = null;
    private IKDProperties properties = new KDProperties();

    @Override
    public String getOlapServerName() {
        return olapServerName;
    }

    public AbstractKDOlapRequest() {
        this.id = this.createId();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setCubeId(Long cubeId) {
        this.cubeId = cubeId;
    }

    @Override
    public Long getCubeId() {
        return this.cubeId;
    }

    @Override
    public void setOlapData(IOlapData olapData) {
        this.olapData = olapData;
    }

    @Override
    public IOlapData getOlapData() {
        if (this.olapData == null) {
            this.olapData = new OlapData();
        }
        return this.olapData;
    }

    @Override
    public IOlapData from(IOlapQuery query, List<IKDCell> cells) {
        if (query == null) {
            throw new NullPointerException("olapQuery is null.");
        }
        IOlapData olapData = this.getOlapData();
        olapData.setBusModelId(query.getBusModelId());
        olapData.setDatasetId(query.getDatasetId());
        olapData.setUseDimension(query.getUseDimension());
        olapData.setDimensionMap(query.getDimensionMap());
        olapData.setCells(cells);
        return olapData;
    }

    @Override
    public void setOlapQuery(IOlapQuery olapQuery) {
        this.olapQuery = olapQuery;
    }

    @Override
    public IOlapQuery getOlapQuery() {
        return this.olapQuery;
    }

    @Override
    public void setDrillQuery(IDrillQuery drillQuery) {
        this.drillQuery = drillQuery;
    }

    @Override
    public IDrillQuery getDrillQuery() {
        return this.drillQuery;
    }

    @Override
    public IKDProperties getProperties() {
        return this.properties;
    }

    @Override
    public IKDOlapRequest copy(Set<String> orgMembers) {
        IDrillQuery drillQuery;
        IOlapQuery olapQuery;
        if (orgMembers == null || orgMembers.isEmpty()) {
            return null;
        }
        KDOlapRequest clone = new KDOlapRequest();
        clone.setId(this.getId());
        clone.setCubeId(this.getCubeId());
        clone.getProperties().copyProperty(this.getProperties());
        IOlapData olapData = this.getOlapData();
        if (olapData != null) {
            clone.setOlapData(olapData.copy());
        }
        if ((olapQuery = this.getOlapQuery()) != null) {
            clone.setOlapQuery(olapQuery.copy(orgMembers));
        }
        if ((drillQuery = this.getDrillQuery()) != null) {
            clone.setDrillQuery(drillQuery.copy());
        }
        return clone;
    }

    @Override
    public IKDOlapRequest copy() {
        IDrillQuery drillQuery;
        IOlapQuery olapQuery;
        KDOlapRequest clone = new KDOlapRequest();
        clone.setId(this.getId());
        clone.setCubeId(this.getCubeId());
        clone.getProperties().copyProperty(this.getProperties());
        IOlapData olapData = this.getOlapData();
        if (olapData != null) {
            clone.setOlapData(olapData.copy());
        }
        if ((olapQuery = this.getOlapQuery()) != null) {
            clone.setOlapQuery(olapQuery.copy());
        }
        if ((drillQuery = this.getDrillQuery()) != null) {
            clone.setDrillQuery(drillQuery.copy());
        }
        return clone;
    }

    static {
        olapServerName = System.getProperty("OLAP_SERVER_NAME", KDOlapServer.class.getName());
    }
}

