/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.dataSource;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.epm.eb.olap.api.base.IKDProperties;
import kd.epm.eb.olap.api.dataSource.IKDCubeManager;
import kd.epm.eb.olap.api.dataSource.IKDOlapServer;
import kd.epm.eb.olap.api.dataSource.IKDOlapSession;
import kd.epm.eb.olap.api.dataSource.IKDState;
import kd.epm.eb.olap.api.enums.KDStateEnum;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.impl.base.KDProperties;
import kd.epm.eb.olap.impl.dataSource.KDCubeManager;
import kd.epm.eb.olap.impl.dataSource.KDState;

public abstract class AbstractKDOlapServer
implements IKDOlapServer {
    private transient String userName = null;
    private transient String password = null;
    private IKDProperties properties = new KDProperties();
    private IKDState state = new KDState();
    private IKDCubeManager cubeManager = null;

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public IKDProperties getProperties() {
        return this.properties;
    }

    @Override
    public void initialize() {
        this.getState().run();
    }

    @Override
    public String getServerName() {
        return this.getClass().getName();
    }

    @Override
    public IKDState getState() {
        return this.state;
    }

    @Override
    public IKDCubeManager getCubeManager() {
        if (this.cubeManager == null) {
            this.cubeManager = this.createCubeManager();
        }
        return this.cubeManager;
    }

    @Override
    public IKDCubeManager createCubeManager() {
        return new KDCubeManager(this);
    }

    @Override
    public IKDOlapSession getSession(Long cubeId) {
        return this.getSession(cubeId, true);
    }

    @Override
    public IKDOlapSession getSession(Long cubeId, boolean hasCheck) {
        if (hasCheck) {
            this.checkState();
        }
        if (cubeId == null || cubeId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u591a\u7ef4\u670d\u52a1\u9519\u8bef\uff0c\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a0\u3002", (String)"AbstractKDOlapServer_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        IKDCube cube = this.getCubeManager().getCube(cubeId);
        IKDOlapSession session = this.createSession(cube);
        this.putSessionProp(session);
        return session;
    }

    protected abstract IKDOlapSession createSession(IKDCube var1);

    protected void checkState() {
        if (this.getState().getState().getState() == KDStateEnum.STOP.getState()) {
            throw new KDBizException(new ErrorCode("EB040001", ResManager.loadKDString((String)"\u591a\u7ef4\u670d\u52a1\u505c\u6b62\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AbstractKDOlapServer_1", (String)"epm-eb-olap", (Object[])new Object[0])), new Object[0]);
        }
        if (this.getState().getState().getState() == KDStateEnum.CHECK.getState()) {
            throw new KDBizException(new ErrorCode("EB040002", ResManager.loadKDString((String)"\u591a\u7ef4\u670d\u52a1\u6b63\u5728\u7ef4\u62a4\u4f53\u7cfb\u3001\u7ef4\u5ea6\u53ca\u7ef4\u5ea6\u6210\u5458\u57fa\u7840\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AbstractKDOlapServer_2", (String)"epm-eb-olap", (Object[])new Object[0])), new Object[0]);
        }
    }

    protected void putSessionProp(IKDOlapSession session) {
    }

    @Override
    public void close() {
        this.getState().stop();
        this.userName = null;
        this.password = null;
        this.cubeManager = null;
        this.getProperties().clear();
    }
}

