/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.dataSource;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.dataSource.IKDOlapServer;
import kd.epm.eb.olap.api.dataSource.IKDOlapSession;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.utils.PropertyUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractKDOlapSession
implements IKDOlapSession {
    protected static final Log log = LogFactory.getLog(AbstractKDOlapSession.class);
    private String id = null;
    private IKDCube cube = null;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private AbstractKDOlapSession() {
        this.initialize();
    }

    public AbstractKDOlapSession(IKDCube cube) {
        this();
        this.cube = cube;
    }

    @Override
    public final void initialize() {
        this.setId(this.createId());
    }

    @Override
    public IKDOlapServer getServer() {
        return this.getCube().getServer();
    }

    @Override
    public IKDCube getCube() {
        return this.cube;
    }

    protected void checkRequest(IKDOlapRequest request) {
        if (request == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u591a\u7ef4\u67e5\u8be2\u9519\u8bef\uff0c\u65e0\u6548\u7684\u8bf7\u6c42\u3002", (String)"AbstractKDOlapSession_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (request.getOlapServerName() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u591a\u7ef4\u67e5\u8be2\u9519\u8bef\uff0c\u65e0\u6548\u7684\u8bf7\u6c42\u670d\u52a1\u540d\u3002", (String)"AbstractKDOlapSession_1", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
    }

    protected void filterMemberPermission(@NotNull IKDOlapRequest request, @NotNull LogStats stats) {
        if (PropertyUtils.isIgnReadPerm(request.getProperties())) {
            stats.addInfo("ignore-read-permission.");
            return;
        }
        stats.addInfo("begin-filter-permission.");
        Long modelId = request.getCubeId();
        Long busModelId = request.getOlapQuery().getBusModelId();
        HashMap permissionMap = Maps.newHashMapWithExpectedSize((int)32);
        LinkedList<Member> noPerm = new LinkedList<Member>();
        LinkedHashSet<IKDQuery> removes = new LinkedHashSet<IKDQuery>();
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        for (IKDQuery query : request.getOlapQuery().getQueries()) {
            for (Dimension dimension : query.getDimension()) {
                Set permissions;
                if (!permissionMap.containsKey(dimension.getNumber())) {
                    Long viewId = request.getOlapQuery().getViews().get(dimension.getNumber());
                    Set _permissions = DimMembPermHelper.getPermMembNumbers((String)dimension.getNumber(), (Long)modelId, (Long)busModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
                    if (_permissions != null) {
                        permissionMap.put(dimension.getNumber(), _permissions);
                    } else {
                        permissionMap.put(dimension.getNumber(), null);
                    }
                }
                if ((permissions = (Set)permissionMap.get(dimension.getNumber())) == null) continue;
                noPerm.clear();
                for (Member member : dimension.getMembers()) {
                    if (permissions.contains(member.getNumber())) continue;
                    noPerm.add(member);
                }
                if (!noPerm.isEmpty()) {
                    dimension.remove(noPerm);
                }
                if (!dimension.getMembers().isEmpty()) continue;
                removes.add(query);
                tags.add(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u201c%1\u201d\u7ef4\u5ea6\u7684\u6210\u5458\u8bfb\u53d6\u6743\u9650\u3002", (String)"AbstractKDOlapSession_2", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getName()}));
                stats.addInfo("query-remove.(" + dimension.getNumber() + " member is null by filter permission)");
            }
        }
        if (!removes.isEmpty()) {
            request.getOlapQuery().removeQuery(removes);
            if (request.getOlapQuery().getQueries().isEmpty() && !tags.isEmpty()) {
                throw new KDBizException(StringUtils.join(tags, (char)','));
            }
        }
        stats.add("end-filter-permission.");
    }

    @Override
    public void close() {
        this.id = null;
        this.cube = null;
    }
}

