/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.dataSource;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.olap.api.base.IKDProperties;
import kd.epm.eb.olap.api.dataSource.IKDOlapServer;
import kd.epm.eb.olap.api.dataSource.IKDServerManager;
import kd.epm.eb.olap.impl.base.KDProperties;

public abstract class AbstractKDServerManager
implements IKDServerManager {
    private static final Log log = LogFactory.getLog((String)AbstractKDServerManager.class.getName());
    private String id = null;
    private Map<String, IKDOlapServer> services = new HashMap<String, IKDOlapServer>();
    private IKDProperties properties = new KDProperties();

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected AbstractKDServerManager() {
    }

    protected Map<String, IKDOlapServer> getServices() {
        return Collections.unmodifiableMap(this.services);
    }

    protected void addOlapServer(IKDOlapServer server) {
        if (server != null) {
            this.services.put(server.getServerName(), server);
        }
    }

    protected IKDOlapServer removeServer(String serverName) {
        if (serverName != null) {
            return this.services.remove(serverName);
        }
        return null;
    }

    @Override
    public IKDProperties getProperties() {
        return this.properties;
    }

    @Override
    public void initialize() {
        this.setId(this.createId());
        this.initManagerParma();
    }

    protected abstract void initManagerParma();

    @Override
    public void registerServer(String serverClass) {
        block5: {
            if (serverClass == null) {
                return;
            }
            Class<?> _class = null;
            try {
                _class = Class.forName(serverClass);
                if (_class != null && IKDOlapServer.class.isAssignableFrom(_class)) {
                    IKDOlapServer server = (IKDOlapServer)_class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (server != null) {
                        this.putManagerProps(server);
                        server.initialize();
                        this.addOlapServer(server);
                    }
                    break block5;
                }
                throw new KDBizException("server register error :" + serverClass);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                log.error((Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    protected abstract void putManagerProps(IKDOlapServer var1);
}

