/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.dataSource;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.KDBizException;
import kd.epm.eb.olap.api.dataSource.IKDCubeManager;
import kd.epm.eb.olap.api.dataSource.IKDOlapServer;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.impl.utils.CubeManagerUtils;

public class KDCubeManager
implements IKDCubeManager {
    private IKDOlapServer olapServer = null;
    private Map<Long, IKDCube> cubes = new ConcurrentHashMap<Long, IKDCube>();

    protected IKDOlapServer getOlapServer() {
        return this.olapServer;
    }

    private KDCubeManager() {
    }

    public KDCubeManager(IKDOlapServer olapServer) {
        this();
        this.olapServer = olapServer;
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.getCubes().clear();
    }

    protected Map<Long, IKDCube> getCubes() {
        return this.cubes;
    }

    @Override
    public IKDCube getCube(Long cubeId) {
        if (cubeId == null || cubeId == 0L) {
            throw new KDBizException("cubeId is null or 0.");
        }
        IKDCube cube = this.getCubes().get(cubeId);
        if (cube == null) {
            cube = this.buildCube(cubeId);
            if (cube == null) {
                throw new KDBizException("cube is null.");
            }
        } else {
            cube.reBuilder();
        }
        return cube;
    }

    @Override
    public Collection<Long> getAllCubeIds() {
        return Collections.unmodifiableCollection(this.cubes.keySet());
    }

    @Override
    public Collection<IKDCube> getAllCubes() {
        return Collections.unmodifiableCollection(this.cubes.values());
    }

    @Override
    public synchronized IKDCube buildCube(Long cubeId) {
        if (cubeId == null || cubeId == 0L) {
            throw new KDBizException("cubeId is null or 0.");
        }
        IKDCube cube = CubeManagerUtils.loadCube(cubeId, this.getOlapServer());
        if (cube != null) {
            this.getCubes().put(cubeId, cube);
        }
        return cube;
    }

    @Override
    public synchronized void updateCube(IKDCube cube, Long versionNo) {
        if (cube == null) {
            throw new KDBizException("error parameter! cube is null.");
        }
        try {
            this.getOlapServer().getState().check();
            cube.getStrategy().updateCube();
        }
        finally {
            this.getOlapServer().getState().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkCube(Long cubeId, Long datasetId) {
        try {
            this.getOlapServer().getState().check();
            IKDCube cube = this.getCube(cubeId);
            if (cube != null) {
                CubeManagerUtils.CHECK_CUBE.checkCube(cube, datasetId, new Long[0]);
            }
        }
        finally {
            this.getOlapServer().getState().run();
        }
    }

    @Override
    public void checkCube(Long cubeId, Long[] versionIds) {
        try {
            this.getOlapServer().getState().check();
            CubeManagerUtils.CHECK_CUBE.checkCube(this.getCube(cubeId), null, versionIds);
        }
        finally {
            this.getOlapServer().getState().run();
        }
    }

    @Override
    public void checkDeleteCube(Long cubeId) {
        CubeManagerUtils.CHECK_CUBE.checkDeleteCube(cubeId);
    }

    @Override
    public void deleteCube(Long cubeId) {
        try {
            this.getOlapServer().getState().check();
            this.removeCube(cubeId);
            CubeManagerUtils.CHECK_CUBE.deleteCube(cubeId);
        }
        finally {
            this.getOlapServer().getState().run();
        }
    }

    private void removeCube(Long cubeId) {
        if (cubeId == null || cubeId == 0L) {
            throw new KDBizException("cubeId is null or 0.");
        }
        IKDCube cube = this.getCubes().get(cubeId);
        if (cube != null) {
            cube.getStrategy().removeCube();
            this.getCubes().remove(cubeId);
        }
    }

    @Override
    public void checkBusModel(Long cubeId, Long busModelId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        CubeManagerUtils.CHECK_CUBE.checkParamByBusModel(busModelId);
        IKDCube cube = this.getCube(cubeId);
        if (cube != null) {
            cube.getModelCache().getModelobj().reBuilderByBusModel(busModelId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkDataset(Long cubeId, Long datasetId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        CubeManagerUtils.CHECK_CUBE.checkParamByDataset(datasetId);
        try {
            this.getOlapServer().getState().check();
            IKDCube cube = this.getCube(cubeId);
            if (cube != null) {
                cube.getModelCache().getModelobj().reBuilderByDataset(datasetId);
                CubeManagerUtils.CHECK_DATASET.check(cube, datasetId);
            }
        }
        finally {
            this.getOlapServer().getState().run();
        }
    }

    @Override
    public void checkDeleteDataset(Long cubeId, Long datasetId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        CubeManagerUtils.CHECK_CUBE.checkParamByDataset(datasetId);
        CubeManagerUtils.CHECK_CUBE.checkDeleteCube(cubeId, datasetId);
    }

    @Override
    public void deleteDataset(Long cubeId, Long datasetId) {
        CubeManagerUtils.CHECK_CUBE.checkParam(cubeId);
        CubeManagerUtils.CHECK_CUBE.checkParamByDataset(datasetId);
        try {
            this.getOlapServer().getState().check();
            CubeManagerUtils.CHECK_CUBE.deleteCube(cubeId, datasetId);
        }
        finally {
            this.getOlapServer().getState().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkMember(Long cubeId, Long dimensionId, Long viewId, Long[] memberIds) {
        try {
            this.getOlapServer().getState().check();
            CubeManagerUtils.CHECK_MEMBER.checkMember(this.getCube(cubeId), dimensionId, viewId, memberIds);
        }
        finally {
            this.getOlapServer().getState().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMember(Long cubeId, Long dimensionId, Long viewId, Long[] memberIds) {
        try {
            this.getOlapServer().getState().check();
            CubeManagerUtils.CHECK_MEMBER.deleteMember(this.getCube(cubeId), dimensionId, viewId, memberIds);
        }
        finally {
            this.getOlapServer().getState().run();
        }
    }

    @Override
    public void checkDeleteMember(Long cubeId, Long dimensionId, Long viewId, Long[] memberIds) {
        CubeManagerUtils.CHECK_MEMBER.checkDeleteMember(this.getCube(cubeId), dimensionId, memberIds);
    }

    @Override
    public void checkDimension(Long cubeId, Long[] dimensionIds) {
        try {
            this.getOlapServer().getState().check();
            CubeManagerUtils.CHECK_DIMENSION.check(this.getCube(cubeId), dimensionIds);
        }
        finally {
            this.getOlapServer().getState().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkDimension(Long cubeId, Long dimensionId, Long viewId) {
        try {
            this.getOlapServer().getState().check();
            CubeManagerUtils.CHECK_DIMENSION.check(this.getCube(cubeId), dimensionId, viewId);
        }
        finally {
            this.getOlapServer().getState().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkDimension(Long cubeId, Long datasetId, Long dimensionId, Long viewId) {
        try {
            this.getOlapServer().getState().check();
            CubeManagerUtils.CHECK_DIMENSION.check(this.getCube(cubeId), datasetId, dimensionId, viewId);
        }
        finally {
            this.getOlapServer().getState().run();
        }
    }

    @Override
    public void deleteDimension(Long cubeId, Long datasetId, Long dimensionId) {
        CubeManagerUtils.CHECK_DIMENSION.check(this.getCube(cubeId), datasetId, dimensionId);
    }

    @Override
    public void checkDeleteDimension(Long cubeId, Long datasetId, Long dimensionId) {
        CubeManagerUtils.CHECK_DIMENSION.checkDelete(this.getCube(cubeId), datasetId, dimensionId);
    }

    @Override
    public void checkView(Long cubeId, Long dimensionId, Long viewId) {
        CubeManagerUtils.CHECK_VIEW.check(this.getCube(cubeId), dimensionId, viewId);
    }

    @Override
    public void checkDeleteView(Long cubeId, Long dimensionId, Long viewId) {
        CubeManagerUtils.CHECK_VIEW.checkDelete(this.getCube(cubeId), dimensionId, viewId);
    }

    @Override
    public void deleteView(Long cubeId, Long dimensionId, Long viewId) {
        CubeManagerUtils.CHECK_VIEW.delete(this.getCube(cubeId), dimensionId, viewId);
    }

    @Override
    public void close() {
        Collection<IKDCube> cubes = this.getAllCubes();
        for (IKDCube cube : cubes) {
            cube.close();
        }
    }
}

