/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.dataSource;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.api.query.IKDQueryView;
import kd.epm.eb.olap.impl.dataSource.AbstractKDOlapRequest;

public class KDOlapRequest
extends AbstractKDOlapRequest {
    private Map<String, Set<String>> refMember = null;
    private Map<String, Set<String>> refMemberByCalc = null;
    private Map<String, Set<String>> refMemberByAll = null;
    private IKDQueryView view = null;

    @Override
    public Map<String, Set<String>> getRefMember() {
        if (this.refMember == null) {
            HashMap<String, Set> _refMember = new HashMap<String, Set>();
            Set tmpSet = null;
            for (IKDQuery query : this.getOlapQuery().getQueries()) {
                for (Dimension dimension : query.getDimension()) {
                    List members = dimension.getMembers();
                    if (members == null) continue;
                    tmpSet = (Set)_refMember.get(dimension.getNumber());
                    if (tmpSet == null) {
                        tmpSet = Sets.newHashSetWithExpectedSize((int)members.size());
                        _refMember.put(dimension.getNumber(), tmpSet);
                    }
                    for (Member member : members) {
                        tmpSet.add(member.getNumber());
                    }
                }
            }
            this.refMember = Collections.unmodifiableMap(_refMember);
        }
        return this.refMember;
    }

    protected void setRefMember(Map<String, Set<String>> refMember) {
        this.refMember = refMember;
    }

    @Override
    public Map<String, Set<String>> getRefMemberByCalc(IKDCube cube, boolean hasScope) {
        if (hasScope) {
            if (this.refMemberByAll == null) {
                this.refMemberByAll = new HashMap<String, Set<String>>(16);
            }
            return this.refMemberByAll;
        }
        if (this.refMemberByCalc == null) {
            this.refMemberByCalc = new HashMap<String, Set<String>>(16);
        }
        return this.refMemberByCalc;
    }

    protected void setRefMemberByAll(Map<String, Set<String>> refMemberByAll) {
        this.refMemberByAll = refMemberByAll;
    }

    protected Map<String, Set<String>> getRefMemberByAll() {
        return this.refMemberByAll;
    }

    protected void setRefMemberByCalc(Map<String, Set<String>> refMemberByCalc) {
        this.refMemberByCalc = refMemberByCalc;
    }

    protected Map<String, Set<String>> getRefMemberByCalc() {
        return this.refMemberByCalc;
    }

    @Override
    public void setView(IKDQueryView view) {
        this.view = view;
    }

    @Override
    public IKDQueryView getView() {
        return this.view;
    }

    @Override
    public IKDOlapRequest copy(Set<String> orgMembers) {
        IKDOlapRequest clone = super.copy(orgMembers);
        ((KDOlapRequest)clone).setRefMember(this.getRefMember());
        ((KDOlapRequest)clone).setRefMemberByCalc(this.getRefMemberByCalc());
        ((KDOlapRequest)clone).setRefMemberByAll(this.getRefMemberByAll());
        return clone;
    }

    @Override
    public IKDOlapRequest copy() {
        IKDOlapRequest clone = super.copy();
        ((KDOlapRequest)clone).setRefMemberByCalc(this.getRefMemberByCalc());
        ((KDOlapRequest)clone).setRefMemberByAll(this.getRefMemberByAll());
        return clone;
    }
}

