/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.dataSource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.query.IKDQueryView;
import kd.epm.eb.olap.impl.data.CubeDataAgent;
import kd.epm.eb.olap.impl.data.CubeDataResult;
import kd.epm.eb.olap.impl.dataSource.AbstractKDOlapSession;
import kd.epm.eb.olap.impl.query.floatData.FloatValue;
import kd.epm.eb.olap.impl.query.queryData.KDDataQueryAgent;

public class KDOlapSession
extends AbstractKDOlapSession {
    private static final long serialVersionUID = 8114918014108349380L;

    public KDOlapSession(IKDCube cube) {
        super(cube);
    }

    @Override
    public IKDQueryView query(IKDOlapRequest request) {
        this.checkRequest(request);
        LogStats stats = new LogStats("budget-olap-log : ");
        stats.addInfo("begin-query. sessionId = " + this.getId() + "; requestId = " + request.getId());
        IKDQueryView view = null;
        try {
            if (request.getOlapQuery().check()) {
                this.filterMemberPermission(request, stats);
                view = KDDataQueryAgent.get(stats).query(this.getCube(), request);
            }
        }
        catch (Throwable ex) {
            log.error("budget-olap-log : ", ex);
            throw ex;
        }
        finally {
            stats.addInfo("end-query");
            log.info(stats.toString());
        }
        return view;
    }

    @Override
    public IKDQueryView query(IKDOlapRequest[] requests) {
        if (requests == null || requests.length == 0) {
            return null;
        }
        IKDQueryView view = null;
        try {
            if (requests.length == 1) {
                return this.query(requests[0]);
            }
            for (IKDOlapRequest request : requests) {
                if (view == null) {
                    view = this.query(request);
                    continue;
                }
                IKDQueryView _tmpView = this.query(request);
                if (_tmpView == null) continue;
                view.getCells().addAll(_tmpView.getCells());
            }
        }
        catch (Throwable ex) {
            log.error("budget-olap-log : ", ex);
            throw ex;
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CubeDataResult execute(IKDOlapRequest request) {
        this.checkRequest(request);
        LogStats stats = new LogStats("budget-data-log : ");
        stats.addInfo("begin-execute. sessionId = " + this.getId() + "; requestId = " + request.getId());
        CubeDataResult result = null;
        try {
            if (request.getOlapData().check()) {
                result = CubeDataAgent.get().save(this.getCube(), request);
                stats.add("end-updateData");
            }
        }
        finally {
            stats.addInfo("end-execute");
            log.info(stats.toString());
        }
        return result;
    }

    @Override
    public IKDQueryView get(IKDOlapRequest request) {
        this.checkRequest(request);
        LogStats stats = new LogStats("budget-olap-log : ");
        stats.addInfo("begin-getData. sessionId = " + this.getId() + "; requestId = " + request.getId());
        IKDQueryView view = null;
        try {
            if (request.getOlapQuery().check()) {
                this.filterMemberPermission(request, stats);
                view = KDDataQueryAgent.get(stats).get(this.getCube(), request);
            }
        }
        catch (Throwable ex) {
            log.error("budget-olap-log : ", ex);
            throw ex;
        }
        finally {
            stats.addInfo("end-getData");
            log.info(stats.toString());
        }
        return view;
    }

    @Override
    public Map<String, List<List<FloatValue>>> floatData(IKDOlapRequest request) {
        return new HashMap<String, List<List<FloatValue>>>();
    }

    @Override
    public Map<MembersKey, Object[]> drill(IKDOlapRequest request) {
        return null;
    }
}

