/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.dataSource;

import java.math.BigDecimal;
import kd.epm.eb.olap.api.dataSource.IKDOlapServer;
import kd.epm.eb.olap.api.dataSource.IKDServerManager;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.dataSource.AbstractKDServerManager;
import kd.epm.eb.olap.impl.dataSource.kd.KDOlapServer;

public class KDServerManager
extends AbstractKDServerManager {
    private static IKDServerManager serverManager = null;

    public static synchronized IKDServerManager getInstance() {
        if (serverManager == null) {
            serverManager = new KDServerManager();
            serverManager.initialize();
        }
        return serverManager;
    }

    private KDServerManager() {
    }

    @Override
    public void initialize() {
        super.initialize();
        this.registerServer(KDOlapServer.class.getName());
    }

    @Override
    protected void initManagerParma() {
        this.getProperties().setPropertyValue("MAX_THREAD_SIZE", KDValue.valueOf(new BigDecimal("4")));
        this.getProperties().setPropertyValue("MAX_DATAFACT_SIZE", KDValue.valueOf(new BigDecimal(String.valueOf(32))));
    }

    @Override
    public void registerServer(String serverClass) {
        super.registerServer(serverClass);
    }

    @Override
    public void closeServer(String serverName) {
        if (serverName == null) {
            return;
        }
        IKDOlapServer server = this.removeServer(serverName);
        if (server != null) {
            server.close();
        }
    }

    @Override
    public void closeServer() {
        for (IKDOlapServer server : this.getServices().values()) {
            server.close();
        }
    }

    @Override
    public void close() {
        this.closeServer();
    }

    @Override
    public IKDOlapServer getServer(String serverName) {
        return this.getServices().get(serverName);
    }

    @Override
    protected void putManagerProps(IKDOlapServer server) {
    }
}

