/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.algo.olap.impl.ScopeBuilderImpl;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.query.kd.mdx.MdxUtils;
import kd.epm.eb.olap.impl.utils.OlapUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BizCalcQuery {
    private static final Log log = LogFactory.getLog(BizCalcQuery.class);
    private static final String ACCOUNT_REPLAMENT = "${account}";
    private static final boolean EPORT_QUERY_STAT = Boolean.parseBoolean(System.getProperty("eb_report_query_stat", "false"));
    private IModelCacheHelper modelCache;
    private IKDCube cube;
    private IKDOlapRequest request;
    private Long reportId;
    private Set<Long> bizruleIds;

    public static BizCalcQuery getInstance(IKDOlapRequest request, IKDCube cube, Long reportId) {
        return new BizCalcQuery(request, cube, reportId);
    }

    public static BizCalcQuery getInstance(IKDOlapRequest request, IKDCube cube, Set<Long> bizruleIds) {
        return new BizCalcQuery(request, cube, bizruleIds);
    }

    private BizCalcQuery(IKDOlapRequest request, IKDCube cube, Set<Long> bizruleIds) {
        this.request = request;
        this.cube = cube;
        this.modelCache = cube.getModelCache();
        this.bizruleIds = bizruleIds;
    }

    private BizCalcQuery(IKDOlapRequest request, IKDCube cube, Long reportId) {
        this.request = request;
        this.cube = cube;
        this.modelCache = cube.getModelCache();
        this.reportId = reportId;
    }

    public List<RuleDto> queryBizCalc3() {
        List<Object> ruleDtos = new ArrayList(10);
        if (CollectionUtils.isNotEmpty(this.bizruleIds)) {
            ruleDtos = RuleService.getInstance().listRule(null, (Boolean)true, this.bizruleIds);
        } else if (this.reportId != null && this.reportId > 0L) {
            Set<Long> templateRuleIds = RuleService.getInstance().getDirectRuleByTempId(this.reportId);
            ruleDtos = RuleService.getInstance().listRule(null, (Boolean)true, templateRuleIds);
            log.info("\u6267\u884c\u62a5\u8868\u5173\u8054\u7684\u89c4\u5219\uff1a" + JSON.toJSONString(ruleDtos.stream().map(RuleDto::getNumber).collect(Collectors.toSet())));
            this.addNewLog(this.modelCache.getModelobj().getId(), this.reportId, ruleDtos);
        }
        if (CollectionUtils.isNotEmpty(ruleDtos)) {
            this.filterRuleByScope(ruleDtos, this.request.getRefMember());
        }
        ArrayList<RuleDto> ruleList = new ArrayList<RuleDto>(10);
        if (CollectionUtils.isNotEmpty(ruleDtos)) {
            Set<String> accountNumbers = this.request.getRefMember().get(SysDimensionEnum.Account.getNumber());
            for (RuleDto ruleDto : ruleDtos) {
                ruleDto.setDataSetId(this.request.getOlapQuery().getDatasetId());
                String leftDataSetNumber = this.modelCache.getDataSetNumberByDataSet(ruleDto.getDataSetId());
                HashSet rightDataSetNumbers = new HashSet(2);
                Map<String, Map<String, Set<String>>> rightMembers = ruleDto.getRightMembers();
                String accountDimNumber = SysDimensionEnum.Account.getNumber();
                rightMembers.forEach((memberKey, itemScope) -> {
                    String dataSetNumber;
                    Member member;
                    Set itemAccountNumbers = (Set)itemScope.get(accountDimNumber);
                    if (CollectionUtils.isNotEmpty((Collection)itemAccountNumbers) && (member = this.modelCache.getMember(accountDimNumber, null, (String)itemAccountNumbers.iterator().next())) != null && StringUtils.isNotBlank((CharSequence)(dataSetNumber = this.modelCache.getDataSetNumberByDataSet(member.getDatasetId())))) {
                        rightDataSetNumbers.add(dataSetNumber);
                    }
                });
                String mdxLeft = ruleDto.getMdxLeft();
                String mdxRight = ruleDto.getMdxRight();
                String r = "LinkValue(\"" + leftDataSetNumber + "\",\"";
                String[] items = StringUtils.splitByWholeSeparator((String)mdxRight, (String)"LinkValue");
                StringBuilder sb = new StringBuilder();
                boolean skipFirst = true;
                if (mdxRight.startsWith("LinkValue")) {
                    skipFirst = false;
                }
                for (int i = 0; i < items.length; ++i) {
                    String newItem;
                    String item = items[i];
                    if (i == 0 && skipFirst) {
                        sb.append(item);
                        continue;
                    }
                    item = "LinkValue" + item;
                    if (!item.equals(newItem = StringUtils.replace((String)item, (String)r, (String)"("))) {
                        newItem = StringUtils.replace((String)newItem, (String)"\")", (String)")");
                    } else if (newItem.contains("\"Value(")) {
                        newItem = newItem.replaceFirst("\"Value\\(", "\"").replaceFirst("\\)\"", "\"");
                    }
                    sb.append(newItem);
                }
                ruleDto.setMdxRight(sb.toString());
                HashSet<String> tempSet = new HashSet<String>(accountNumbers);
                Set<String> accountMemberSet = ruleDto.getLeftMembers().get(accountDimNumber);
                tempSet.retainAll(accountMemberSet);
                if (StringUtils.contains((CharSequence)mdxLeft, (CharSequence)ACCOUNT_REPLAMENT)) {
                    int index = 0;
                    for (String accountNumber : tempSet) {
                        String mdxString = this.getMdxString(accountNumber);
                        RuleDto obj = new RuleDto();
                        try {
                            BeanUtils.copyProperties((Object)obj, (Object)ruleDto);
                        }
                        catch (Exception e) {
                            log.error("\u5bf9\u8c61\u590d\u5236\u5f02\u5e38", (Throwable)e);
                        }
                        obj.setNumber(obj.getNumber() + index++);
                        obj.setMdxLeft(StringUtils.replace((String)mdxLeft, (String)ACCOUNT_REPLAMENT, (String)mdxString));
                        obj.setMdxRight(StringUtils.replace((String)obj.getMdxRight(), (String)ACCOUNT_REPLAMENT, (String)mdxString));
                        ruleList.add(obj);
                    }
                    continue;
                }
                ruleList.add(ruleDto);
            }
        }
        this.setMemberScope(ruleList);
        this.computeCountFunction(ruleList);
        return ruleList;
    }

    private String getMdxString(String accountNumber) {
        Member member = this.modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, accountNumber);
        String dimHeadStr = OlapUtils.handlerDimShortNum(SysDimensionEnum.Account.getShortNumber());
        String mdxLongNumber = MemberServiceHelper.getMdx((String)member.getLongNumber());
        return dimHeadStr + '.' + mdxLongNumber;
    }

    private void filterRuleByScope(List<RuleDto> dtos, Map<String, Set<String>> queryRefMember) {
        ListIterator<RuleDto> iterator = dtos.listIterator();
        while (iterator.hasNext()) {
            RuleDto dto = (RuleDto)iterator.next();
            boolean isremove = false;
            Map<String, Set<String>> leftRefMembers = dto.getLeftMembers();
            for (Map.Entry<String, Set<String>> entry : leftRefMembers.entrySet()) {
                String dimNumber = entry.getKey();
                Set<String> currentPojoRefMembers = entry.getValue();
                Set<String> queryRefMembers = queryRefMember.get(dimNumber);
                HashSet intersection = Sets.newHashSet();
                if (queryRefMembers != null) {
                    intersection = Sets.intersection(currentPojoRefMembers, queryRefMembers);
                }
                if (!intersection.isEmpty()) continue;
                isremove = true;
                break;
            }
            if (!isremove) continue;
            iterator.remove();
        }
    }

    private void setMemberScope(List<RuleDto> ruleDtos) {
        StringBuilder mdxStr = new StringBuilder();
        for (RuleDto ruleDto : ruleDtos) {
            String metricDimNumber;
            ScopeBuilderImpl scopeBuilder = new ScopeBuilderImpl();
            Map<String, Set<String>> leftMembers = ruleDto.getLeftMembers();
            if (!leftMembers.containsKey(metricDimNumber = SysDimensionEnum.Metric.getNumber())) {
                Set<String> metricNumberSet = this.request.getRefMember().get(SysDimensionEnum.Metric.getNumber());
                Set numberMember = this.modelCache.getMembers(metricDimNumber).stream().filter(e -> MetricDataTypeEnum.isNumber((String)e.getDatatype())).map(BaseCache::getNumber).collect(Collectors.toSet());
                Set filterSet = metricNumberSet.stream().filter(numberMember::contains).collect(Collectors.toSet());
                leftMembers.put(metricDimNumber, filterSet);
                log.info("\u516c\u5f0f\u8303\u56f4\u5185\u6ca1\u6709\u5ea6\u91cf\uff0c\u8fc7\u6ee4\u51fa\u8bf7\u6c42\u91cc\u7684\u6570\u503c\u5ea6\u91cf\u653e\u8fdb\u6765:" + JSON.toJSONString(filterSet));
            }
            leftMembers.forEach((k, v) -> {
                if (!SysDimensionEnum.Account.getNumber().equals(k)) {
                    Dimension dimension = this.modelCache.getDimension(k);
                    mdxStr.setLength(0);
                    String dimShortNum = OlapUtils.handlerDimShortNum(dimension.getShortNumber());
                    mdxStr.append('{');
                    boolean isMetric = "Metric".equals(dimension.getNumber());
                    for (String number : v) {
                        Member metricMember;
                        if (isMetric && !MetricDataTypeEnum.isNumber((String)(metricMember = this.modelCache.getMember(dimension.getNumber(), null, number)).getDatatype())) {
                            log.info("\u8df3\u8fc7\u975e\u6570\u503c\u7c7b\u578b\u7684\u5ea6\u91cf\u6210\u5458\uff1a" + number);
                            continue;
                        }
                        MdxUtils.appendMember(mdxStr, dimShortNum, number);
                    }
                    mdxStr.setLength(mdxStr.length() - 1);
                    mdxStr.append('}');
                    scopeBuilder.addExpression(dimension.getShortNumber(), mdxStr.toString());
                }
            });
            scopeBuilder.setName(ruleDto.getNumber());
        }
    }

    private void computeCountFunction(List<RuleDto> ruleList) {
        if (CollectionUtils.isEmpty(ruleList)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (RuleDto ruleDto : ruleList) {
            Map viweIds = this.modelCache.getViewsByDataSet(ruleDto.getDataSetId());
            List<RuleFunction> functions = ruleDto.getFunctions();
            if (CollectionUtils.isEmpty(functions)) continue;
            HashMap<String, Integer> replateInfo = new HashMap<String, Integer>(16);
            for (IRuleFunction iRuleFunction : functions) {
                if (!iRuleFunction.getFunctionName().equals(RuleFunctionEnum.Count.getName())) continue;
                String dimNum = (String)iRuleFunction.getValue(FunctionItemEnum.DIMENSIONLIST.getKey());
                Long viewId = (Long)viweIds.get(dimNum);
                int count = 0;
                stringBuilder.append("Count(").append(dimNum).append("!!");
                String membRange = (String)iRuleFunction.getValue(FunctionItemEnum.DIMEMBERRANGE.getKey());
                List memberConditions = (List)SerializationUtils.deSerializeFromBase64((String)membRange);
                for (MemberCondition condition : memberConditions) {
                    String membNum = condition.getNumber();
                    String range = condition.getRange();
                    stringBuilder.append(membNum).append('_').append(range).append('!');
                    count += this.modelCache.getMember(dimNum, viewId, membNum, Integer.parseInt(range)).size();
                }
                stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
                replateInfo.put(stringBuilder.toString(), count);
                stringBuilder.setLength(0);
            }
            if (replateInfo.isEmpty()) continue;
            String mdxStr = ruleDto.getMdxRight();
            for (Map.Entry entry : replateInfo.entrySet()) {
                mdxStr = mdxStr.replace((CharSequence)entry.getKey(), ((Integer)entry.getValue()).toString());
            }
            ruleDto.setMdxRight(mdxStr);
        }
    }

    private void addNewLog(long modelId, long templateId, List<RuleDto> ruleDtos) {
        if (EPORT_QUERY_STAT) {
            Set ruleIds = ruleDtos.stream().map(RuleDto::getId).collect(Collectors.toSet());
            SqlBuilder sql = new SqlBuilder();
            sql.append("select d.fbizrule as ruleid, t.fnumber as templatenumber from t_eb_leafbizruletempdis d", new Object[0]).append(" inner join t_eb_template t on t.fid=d.ftemplate", new Object[0]).append(" where", new Object[0]).append(" t.fmodelid = ? ", new Object[]{modelId}).append(" and", new Object[0]).appendIn("d.fbizrule", ruleIds.toArray());
            HashSet tempSet = Sets.newHashSet();
            try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                for (Row row : ds) {
                    tempSet.add(row.getString("templatenumber"));
                }
            }
            DynamicObject dymLog = BusinessDataServiceHelper.newDynamicObject((String)"eb_rule_instance");
            dymLog.set("model", (Object)modelId);
            dymLog.set("template", (Object)templateId);
            dymLog.set("exetype", (Object)"2");
            dymLog.set("creator", (Object)UserUtils.getUserId());
            dymLog.set("createtime", (Object)new Date());
            dymLog.set("rulecount", (Object)ruleDtos.size());
            dymLog.set("synccount", (Object)ruleDtos.size());
            dymLog.set("syncrule", (Object)ruleDtos.stream().map(RuleDto::getNumber).collect(Collectors.joining(",")));
            dymLog.set("asynccount", (Object)0);
            dymLog.set("executestatus", (Object)"2");
            String reltemplate = tempSet.stream().collect(Collectors.joining(","));
            dymLog.set("reltemplate", (Object)reltemplate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dymLog});
        }
    }
}

