/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.algo.olap.util.Pair;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCube;
import kd.epm.eb.olap.api.rule.IKDBizRule;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.execute.BizCalcQuery;
import kd.epm.eb.olap.impl.utils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;

public class BizRuleManager {
    private static final BizRuleManager instance = new BizRuleManager();
    private static final Log log = LogFactory.getLog(BizRuleManager.class);

    public static BizRuleManager getInstance() {
        return instance;
    }

    private BizRuleManager() {
    }

    public void initBizRules(IKDOlapRequest request, IKDCube cube) {
        boolean isCalcBizRule = PropertyUtils.isCalcBizRule(request.getProperties());
        if (!isCalcBizRule) {
            return;
        }
        List<IKDBizRule> testFormulas = request.getOlapQuery().getPrefFormulas();
        Set<Long> otherBizRuleIds = request.getOlapQuery().getBizRuleIds();
        IKDValue reportValue = request.getProperties().getPropertyValue("REPORT_ID");
        Long reportId = reportValue == null ? null : Long.valueOf(reportValue.getString());
        List<Object> ruleDtos = new ArrayList(1);
        ArrayList<IKDBizRule> prefFormulas = new ArrayList(1);
        long begin = System.nanoTime();
        try {
            if (testFormulas != null && !testFormulas.isEmpty()) {
                prefFormulas = testFormulas;
            } else if (!CollectionUtils.isEmpty(otherBizRuleIds)) {
                ruleDtos = BizCalcQuery.getInstance(request, cube, otherBizRuleIds).queryBizCalc3();
            } else if (reportId != null && reportId != 0L) {
                ruleDtos = BizCalcQuery.getInstance(request, cube, reportId).queryBizCalc3();
            }
        }
        catch (Throwable ex) {
            log.error(ex);
            throw new KDBizException(new ErrorCode("EB040050", ResManager.loadResFormat((String)"\u4e1a\u52a1\u89c4\u5219\u8868\u8fbe\u5f0f\u89e3\u6790\u9519\u8bef\u201c%1\u201d", (String)"BizRuleManager_0", (String)"epm-eb-olap", (Object[])new Object[]{ex.getMessage()})), new Object[0]);
        }
        request.getOlapQuery().setFormulas(ruleDtos);
        String bizruleLog = this.toStringBizRule(ruleDtos, prefFormulas);
        if (StringUtils.isNotEmpty((String)bizruleLog)) {
            log.info("budget-olap-log : bizruleinfo:\r\n" + bizruleLog);
        }
        log.info("budget-olap-log : end load calc rule. use = " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - begin) + "ms. size = " + request.getOlapQuery().getFormulas().size());
    }

    private String toStringBizRule(List<RuleDto> formulas, List<IKDBizRule> metricFormulas) {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    private void appendMemberExpr(StringBuilder sb, List<Pair<String, String>> memberExpressions) {
        if (memberExpressions != null && !memberExpressions.isEmpty()) {
            sb.append("scope:");
            for (Pair<String, String> memberExpression : memberExpressions) {
                sb.append((String)memberExpression.getValue0()).append(':').append((String)memberExpression.getValue1());
            }
            sb.append("\r\n");
        }
    }
}

