/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.dao;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.f7.FormulaCondition;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.StringUtils;

public class RuleManageJsonUtil {
    public static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static String writeValueAsString(Object obj) {
        if (obj == null) {
            throw new KDBizException("object is empty");
        }
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\u5bf9\u8c61\u5e8f\u5217\u5316\u5931\u8d25\uff1a\u201c%1\u201d\u3002", (String)"RuleManageJsonUtil_0", (String)"epm-eb-olap", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public static List<FormulaCondition> getConditions2(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return Collections.emptyList();
        }
        try {
            return SerializationUtils.fromJsonStringToList((String)s, FormulaCondition.class);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\u5bf9\u8c61\u5173\u7cfb\u4fe1\u606f\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff1a\u201c%1\u201d\u3002", (String)"RuleManageJsonUtil_1", (String)"epm-eb-olap", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public static Map<String, List<FormulaCondition>> getConditions(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            return (Map)objectMapper.readValue(s, (TypeReference)new TypeReference<HashMap<String, List<FormulaCondition>>>(){});
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\u5bf9\u8c61\u5173\u7cfb\u4fe1\u606f\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff1a\u201c%1\u201d\u3002", (String)"RuleManageJsonUtil_1", (String)"epm-eb-olap", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public static DynamicInfoCollection getDyInfoCollection(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        String[] split = s.split("`");
        DynamicInfoCollection infoColl = new DynamicInfoCollection(ResManager.loadKDString((String)"\u89c4\u5219\u7ba1\u7406\u7ef4\u5ea6\u4fe1\u606f", (String)"RuleManageJsonUtil_2", (String)"epm-eb-olap", (Object[])new Object[0]), new String[]{"id", "number", "longnumber", "name", "dimNum", "shortnumber", "datasetnumber"});
        for (String s1 : split) {
            String substring = s1.substring(1, s1.length() - 1).replace(" ", "");
            String[] split1 = substring.split(",");
            infoColl.addInfo((Object[])split1);
        }
        return infoColl;
    }

    public static FormulaMemberPojo getRefDimMembers(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        FormulaMemberPojo formulaMemberPojo = new FormulaMemberPojo(null);
        List refMembs = SerializationUtils.fromJsonStringToList((String)s, DimMemberPojo.class);
        formulaMemberPojo.getRefDimMembers().addAll(refMembs);
        return formulaMemberPojo;
    }

    public static String writeInfoAsString(DynamicInfoCollection obj) {
        if (obj == null) {
            throw new KDBizException("info is empty");
        }
        StringBuilder buffer = new StringBuilder(128);
        List info = obj.getValues();
        for (DynamicInfoCollection.InfoObject infoObject : info) {
            List values = infoObject.getValues();
            buffer.append(values);
            buffer.append('`');
        }
        return buffer.toString();
    }

    public static String writeInfoAsString(FormulaMemberPojo obj) {
        if (obj == null) {
            throw new KDBizException("info is empty");
        }
        return SerializationUtils.toJsonString((Object)obj.getRefDimMembers());
    }
}

