/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.face;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.AnalysisContext;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.rule.edit.FormulaMembPojo;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.BinaryExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.Parse2RPN;
import kd.epm.eb.olap.impl.execute.impl.visit.FormulaVisit;
import kd.epm.eb.olap.impl.execute.impl.visit.FormulaVisitContext;
import kd.epm.eb.olap.impl.execute.impl.visit.FormulaVisitResult;
import kd.epm.eb.olap.service.FormulaStrProxyHandler;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.ShowBizRuleUtils;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.Options;
import org.apache.commons.collections4.CollectionUtils;

public interface IExpress {
    public FunReturnType getReturnType();

    public String toMdx(Environment var1);

    public List<ExprPanel> toPanel(PanelEnvironment var1);

    public String toShrekString(Environment var1);

    public void doCheck(CheckEnvironment var1);

    default public FunReturnType getReturnType(CheckEnvironment env) {
        return this.getReturnType();
    }

    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> var1, Evaluator var2);

    default public Map<String, Set<String>> createIgnoreRange() {
        HashMap ignoreMap = Maps.newHashMapWithExpectedSize((int)1);
        ignoreMap.put("ignore", null);
        return ignoreMap;
    }

    default public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        return Sets.newLinkedHashSet();
    }

    default public Set<String> getRuleEnlarge(Set<String> leftDim, Set<String> rightDim) {
        if (leftDim == null && rightDim == null) {
            return Sets.newLinkedHashSet();
        }
        if (leftDim == null) {
            return rightDim;
        }
        if (rightDim == null) {
            return leftDim;
        }
        leftDim.addAll(rightDim);
        return leftDim;
    }

    default public boolean checkRightHasNumber() {
        return false;
    }

    default public boolean checkRightHasCalcFuncValue() {
        return false;
    }

    default public String handleMainMemMdxByFunVirtualMem(Environment env) {
        env.setHasVirMember(true);
        Map<String, Set<String>> leftMembers = env.getLeftMembers();
        String mainDimNumber = env.getMainDimNumber();
        Set<String> leftMemberSet = leftMembers.get(mainDimNumber);
        String memberNumber = leftMemberSet.iterator().next();
        IModelCacheHelper modelCache = env.getModelCache();
        Map viewMap = modelCache.getViewsByDataSet(env.getBizModelId());
        Map<String, Long> analyzeViewMap = env.getAnalyzeViewMap();
        Long viewId = analyzeViewMap.containsKey(mainDimNumber) ? analyzeViewMap.get(mainDimNumber) : (Long)viewMap.get(mainDimNumber);
        Dimension dimension = modelCache.getDimension(mainDimNumber);
        Member member = modelCache.getMember(mainDimNumber, viewId, memberNumber);
        Map<String, Map<String, String>> functionVirtualMap = env.getFunctionVirtualMap();
        Map memberMap = functionVirtualMap.computeIfAbsent(mainDimNumber, f -> new HashMap(16));
        String funVirMemNumber = this.getFunVirMemNumber(memberNumber);
        memberMap.put(memberNumber, funVirMemNumber);
        String funVirMemLongNumber = member.getLongNumber().replace(memberNumber, funVirMemNumber);
        return ParseUtils.genLongNumberMdx(dimension.getShortNumber(), funVirMemLongNumber);
    }

    default public String getFunVirMemNumber(String member) {
        String funVirMemNum = "";
        if (StringUtils.isEmpty((String)member)) {
            return funVirMemNum;
        }
        funVirMemNum = member + "._fvm";
        if (funVirMemNum.length() > 50) {
            int digital = funVirMemNum.length() - 50;
            String randomNum = this.getRandomNum(digital);
            member = member.substring(0, 50 - digital * 2);
            funVirMemNum = member + randomNum + "._fvm";
        }
        return funVirMemNum;
    }

    default public String getRandomNum(int digital) {
        SecureRandom random = new SecureRandom();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < digital; ++i) {
            int randomNum = random.nextInt(10);
            stringBuilder.append(randomNum);
        }
        return stringBuilder.toString();
    }

    default public void handleMainMemShrekStringByFunVirtualMem(Environment env, StringBuilder mdx) {
        if (env == null || mdx == null) {
            return;
        }
        Map<String, Set<String>> leftMembers = env.getLeftMembers();
        String mainDimNumber = env.getMainDimNumber();
        Set<String> leftMemberSet = leftMembers.get(mainDimNumber);
        String memberNumber = leftMemberSet.iterator().next();
        mdx.append("v('").append(mainDimNumber).append("@").append(memberNumber).append("')");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Object getFuncMockCalcValue(PanelEnvironment env) {
        Object funcValue = "";
        try {
            List<BGCell> bgCells;
            AlgoCalcRequest request = new AlgoCalcRequest();
            request.setModelId(env.getModelCache().getModelobj().getId());
            request.setDatasetId(env.getLeftDataSetId());
            Parse2RPN parse2RPN = new Parse2RPN(env.getRuleDto().getFormulaString());
            parse2RPN.parse();
            IExpress expr = parse2RPN.getExpr();
            FormulaVisit formulaVisit = new FormulaVisit();
            FormulaVisitResult leftResult = formulaVisit.visit(((BinaryExpr)expr).getLeft(), new FormulaVisitContext());
            FormulaVisitResult rightResult = formulaVisit.visit(this, new FormulaVisitContext());
            String mockFormulaStr = leftResult.getFormulaStr() + " = " + rightResult.getFormulaStr();
            RuleDto mockRuleDto = (RuleDto)new FormulaStrProxyHandler(env.getRuleDto(), mockFormulaStr).bind();
            request.setRules(Lists.newArrayList((Object[])new RuleDto[]{mockRuleDto}));
            request.setMemberInfo(env.getLeftMemberCollect());
            request.setViewMap(env.getViewMap());
            if (env.getAnalysisContext() != null) {
                Options options = new Options();
                options.setUseAnalysis(true);
                options.setUseAlgoAgg(false);
                request.setOptions(options);
                AnalysisContext newAnalysisContext = ShowBizRuleUtils.getAnalysisContext(env.getAnalysisContext(), env.getLeftDataSetId());
                OlapContext.setAnalysisContext((AnalysisContext)newAnalysisContext);
            }
            if (!(bgCells = OlapManager.getInstance().singleCalc(request)).isEmpty()) {
                funcValue = bgCells.get(0).getValue();
            }
        }
        finally {
            OlapContext.clearAnalysisContext();
        }
        return funcValue;
    }

    default public void handleFuncValueMap(PanelEnvironment env, String funKey, String funcValue, String showInPageFuncKey) {
        if (funKey != null) {
            env.getFuncValueMap().put(funKey, funcValue);
        } else {
            Map<String, Integer> showInPageFuncCountMap = env.getShowInPageFuncCountMap();
            Integer count = showInPageFuncCountMap.computeIfAbsent(showInPageFuncKey, k -> 1);
            Map<String, Map<Integer, String>> showInPageFuncValueMap = env.getShowInPageFuncValueMap();
            Map countValueMap = showInPageFuncValueMap.computeIfAbsent(showInPageFuncKey, k -> new HashMap(16));
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            countValueMap.put(n, funcValue);
            showInPageFuncCountMap.put(showInPageFuncKey, count);
        }
    }

    default public void checkRangeAndGetNumberGetNameContain(CheckEnvironment env, String funcName) {
        boolean canContain;
        ToolEnum parentToolEnum = env.getParentToolEnum();
        boolean bl = canContain = ToolEnum.rangeFunctionBoolean((ToolEnum)parentToolEnum) || ToolEnum.getNumberAndGetNameFunctionBoolean((ToolEnum)parentToolEnum);
        if (!canContain) {
            ParseExceptionCatcher.throwRangeAndGetNumberGetNameException(funcName);
        }
    }

    default public String getDimRangeInfoToString(Map<String, Object> allVal, String key, char separate, boolean needBracket, Environment env) {
        String keyInfo = (String)allVal.get(key);
        FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)keyInfo, FormulaMemberPojo.class);
        IModelCacheHelper modelCache = env.getModelCache();
        Map<String, Long> viewMap = env.getRuleDto().getViewMap();
        Set<String> fixDimension = env.getFixDimension();
        StringBuilder memberStr = new StringBuilder();
        if (needBracket) {
            memberStr.append('(');
        }
        for (DimMemberPojo refDimMember : formulaMemberPojo.getRefDimMembers()) {
            String dimNumber = refDimMember.getDimNumber();
            Dimension dimension = modelCache.getDimension(dimNumber);
            if (fixDimension.contains(dimNumber)) continue;
            Member member = dimension.getMember(viewMap.get(dimNumber), refDimMember.getNumber());
            if (dimension.isKeepTree()) {
                memberStr.append(ParseUtils.genLongNumberMdx(dimension.getShortNumber(), member.getLongNumber()));
            } else {
                memberStr.append(ParseUtils.genLongNumberMdx(dimension.getShortNumber(), member.getNumber()));
            }
            memberStr.append(separate);
        }
        memberStr.deleteCharAt(memberStr.length() - 1);
        if (needBracket) {
            memberStr.append(')');
        }
        return memberStr.toString();
    }

    default public Long getRangeDatasetId(CheckEnvironment env, String memberName) {
        Long rangeDatasetId = 0L;
        if (env == null || StringUtils.isEmpty((String)memberName)) {
            return rangeDatasetId;
        }
        FormulaPojo formulaPojo = env.getFormulaPojoMap().get(memberName);
        if (formulaPojo == null) {
            return rangeDatasetId;
        }
        String numberString = "";
        if (env.getMainDimNumber().equals(SysDimensionEnum.Account.getNumber())) {
            numberString = formulaPojo.getNumberString();
        } else {
            List notMainMemberList = formulaPojo.getNotMainMemberList();
            if (CollectionUtils.isNotEmpty((Collection)notMainMemberList)) {
                for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
                    if (!formulaMembPojo.getDimNumber().equals(SysDimensionEnum.Account.getNumber())) continue;
                    numberString = formulaMembPojo.getNumberString();
                    break;
                }
            }
        }
        IModelCacheHelper modelCache = env.getModelCache();
        Member member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, numberString);
        if (member != null) {
            rangeDatasetId = member.getDatasetId();
        }
        return rangeDatasetId;
    }
}

