/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class RangeMapUtils {
    public static Map<String, Set<String>> intersection(String[] dimensionNums, Map<String, Set<String>> leftMap, Map<String, Set<String>> rightMap) {
        if (leftMap != null && leftMap.size() == 1 && "ignore".equals(leftMap.entrySet().iterator().next().getKey())) {
            return rightMap;
        }
        if (rightMap != null && rightMap.size() == 1 && "ignore".equals(rightMap.entrySet().iterator().next().getKey())) {
            return leftMap;
        }
        if (leftMap == null || rightMap == null) {
            return leftMap == null ? rightMap : leftMap;
        }
        if (leftMap.isEmpty() || rightMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)dimensionNums.length);
        for (String dimNumber : dimensionNums) {
            Set<String> leftR = leftMap.get(dimNumber);
            Set<String> rightR = rightMap.get(dimNumber);
            if (CollectionUtils.isEmpty(leftR) || CollectionUtils.isEmpty(rightR)) {
                return Collections.emptyMap();
            }
            HashSet<String> strings = new HashSet<String>(leftR);
            strings.retainAll(rightR);
            if (strings.isEmpty()) {
                return Collections.emptyMap();
            }
            returnMap.put(dimNumber, strings);
        }
        return returnMap;
    }

    public static Map<String, Set<String>> union(String[] dimensionNums, Map<String, Set<String>> leftMap, Map<String, Set<String>> rightMap) {
        if (leftMap != null && leftMap.size() == 1 && "ignore".equals(leftMap.entrySet().iterator().next().getKey())) {
            return rightMap;
        }
        if (rightMap != null && rightMap.size() == 1 && "ignore".equals(rightMap.entrySet().iterator().next().getKey())) {
            return leftMap;
        }
        if (leftMap == null || rightMap == null) {
            return null;
        }
        if (leftMap.isEmpty() || rightMap.isEmpty()) {
            return leftMap.isEmpty() ? rightMap : leftMap;
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)dimensionNums.length);
        for (String dimNumber : dimensionNums) {
            Set<String> leftR = leftMap.get(dimNumber);
            Set<String> rightR = rightMap.get(dimNumber);
            if (CollectionUtils.isEmpty(leftR) || CollectionUtils.isEmpty(rightR)) {
                return Collections.emptyMap();
            }
            HashSet<String> strings = new HashSet<String>(leftR);
            strings.addAll(rightR);
            returnMap.put(dimNumber, strings);
        }
        return returnMap;
    }
}

