/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr;

import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AncestorFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AttributeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.ChildrenFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.DateFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.GetAttributeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.GetNameFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.GetNumberFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.ListFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MemberFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.ParentFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.RelativeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SiblingFun;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.ParseException;

public class ParseUtils {
    private static final char[] OPERATIONS = new char[]{'+', '-', '*', '/', '=', '<', '>', ','};
    private static final char TAB = '\t';
    private static final char ENTER = '\r';
    private static final char LINE_FEED = '\n';
    private static final char WHITE = ' ';

    public static String getExpressDimNumber(IExpress iExpress) {
        if (iExpress instanceof AttributeFun) {
            return ((AttributeFun)iExpress).getDimNumber();
        }
        if (iExpress instanceof GetAttributeFun) {
            return ((GetAttributeFun)iExpress).getDimNumber();
        }
        if (iExpress instanceof AncestorFun) {
            return ((AncestorFun)iExpress).getDimNumber();
        }
        if (iExpress instanceof ParentFun) {
            return ((ParentFun)iExpress).getDimNumber();
        }
        if (iExpress instanceof ChildrenFun) {
            return ((ChildrenFun)iExpress).getDimNumber();
        }
        if (iExpress instanceof RelativeFun) {
            return ((RelativeFun)iExpress).getDimNumber();
        }
        if (iExpress instanceof SiblingFun) {
            return ((SiblingFun)iExpress).getDimNumber();
        }
        if (iExpress instanceof ListFun) {
            return ((ListFun)iExpress).getDimNumber();
        }
        if (iExpress instanceof DateFun) {
            return ((DateFun)iExpress).getDimNumber();
        }
        if (iExpress instanceof GetNumberFun) {
            return ((GetNumberFun)iExpress).getDimNumber();
        }
        if (iExpress instanceof GetNameFun) {
            return ((GetNameFun)iExpress).getDimNumber();
        }
        if (iExpress instanceof MemberFun) {
            return ((MemberFun)iExpress).getDimNumber();
        }
        ParseExceptionCatcher.throwParseUtils1(iExpress.getClass().getSimpleName());
        return null;
    }

    public static String getExpressAttributeNumber(IExpress iExpress) {
        if (iExpress instanceof AttributeFun) {
            return ((AttributeFun)iExpress).getAttribute();
        }
        if (iExpress instanceof GetAttributeFun) {
            return ((GetAttributeFun)iExpress).getAttribute();
        }
        ParseExceptionCatcher.throwParseUtils1(iExpress.getClass().getSimpleName());
        return null;
    }

    public static String genLongNumberMdx(String dimShortNumber, String longNumber) {
        String[] split;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("`").append(dimShortNumber).append("`");
        for (String number : split = longNumber.split("!")) {
            stringBuilder.append(".").append("`").append(number).append("`");
        }
        return stringBuilder.toString();
    }

    public static void expected(String errStr) {
        throw new ParseException(" cannot Parse, sorry : " + errStr);
    }

    public static char toDBC(char look) {
        return kd.epm.eb.common.utils.ParseUtils.toDBC((char)look);
    }

    public static boolean isOperation(char look) {
        for (char tmpChar : OPERATIONS) {
            if (tmpChar != look) continue;
            return true;
        }
        return false;
    }

    public static boolean isWhite(char look) {
        return look == ' ' || look == '\t' || look == '\r' || look == '\n';
    }

    public static void checkReturnIsNumber(IExpress left, CheckEnvironment env) {
        FunReturnType returnType = left.getReturnType(env);
        if (FunReturnType.Numeric != returnType) {
            throw new ParseException(ResManager.loadKDString((String)"\u8fd4\u56de\u503c\u5fc5\u987b\u4e3a\u6570\u503c\u7c7b\u578b", (String)"RuleManagePlugin2_96", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkReturnIsDate(IExpress left, CheckEnvironment env) {
        FunReturnType returnType = left.getReturnType(env);
        if (FunReturnType.Date != returnType) {
            throw new ParseException(ResManager.loadKDString((String)"\u8fd4\u56de\u503c\u5fc5\u987b\u4e3a\u65e5\u671f\u7c7b\u578b", (String)"RuleManagePlugin2_94", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public static void checkReturnIsNumberORNull(IExpress left, CheckEnvironment env) {
        FunReturnType returnType = left.getReturnType(env);
        if (FunReturnType.Numeric != returnType && FunReturnType.Word != returnType) {
            throw new ParseException(ResManager.loadKDString((String)"\u8fd4\u56de\u503c\u5fc5\u987b\u4e3a\u6570\u503c\u7c7b\u578b", (String)"RuleManagePlugin2_96", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public static boolean isBalanced(String brackets) {
        Stack<Character> stack = new Stack<Character>();
        block4: for (char ch : brackets.toCharArray()) {
            switch (ch) {
                case '(': 
                case '[': 
                case '{': {
                    stack.push(Character.valueOf(ch));
                    continue block4;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (stack.isEmpty()) {
                        return false;
                    }
                    char top = ((Character)stack.pop()).charValue();
                    if (ParseUtils.matches(top, ch)) continue block4;
                    return false;
                }
            }
        }
        return stack.isEmpty();
    }

    private static boolean matches(char open, char close) {
        String opens = "([{";
        String closers = ")]}";
        return opens.indexOf(open) == closers.indexOf(close);
    }
}

