/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import org.apache.commons.collections4.CollectionUtils;

public class AncestorFun
extends SingleMemberExpr {
    private SingleMemberExpr memberExpr;
    private Integer level;

    public void setMemberExpr(SingleMemberExpr memberExpr) {
        memberExpr.setDimNumber(this.getDimNumber());
        this.memberExpr = memberExpr;
    }

    public SingleMemberExpr getMemberExpr() {
        return this.memberExpr;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    @Override
    public String toMdx(Environment env) {
        return "AncestorExcludeNull(" + this.memberExpr.toMdx(env) + "," + this.level + ")";
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        int seq = 0;
        ExprPanel panel1 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        Dimension dimension = env.getModelCache().getDimension(this.getDimNumber());
        panel1.addShowStringAndValue("@Ancestor(" + dimension.getName() + ",", null);
        panel1.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel1);
        panels.addAll(this.memberExpr.toPanel(env));
        ExprPanel panel2 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel2.addShowStringAndValue("," + this.level, null);
        panel2.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel2);
        ExprPanel panel3 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel3.addShowStringAndValue(")", null);
        panel3.addBackStageKeyAndSeq(this.getFunKey(), seq);
        panels.add(panel3);
        return panels;
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        String parentDimNumber;
        String funcName = RuleFunctionEnum.Ancestor.getName();
        this.checkRangeAndGetNumberGetNameContain(env, funcName);
        String currentFunDimNumber = this.getDimNumber();
        if (!env.getCurrentDataSetDimSet().contains(currentFunDimNumber)) {
            ParseExceptionCatcher.throwException4();
        }
        env.addFunRefDimension(this.getFunKey(), currentFunDimNumber);
        IExpress parentExpress = env.getParentExpress();
        if (parentExpress != null && !currentFunDimNumber.equals(parentDimNumber = ParseUtils.getExpressDimNumber(parentExpress))) {
            ParseExceptionCatcher.throwException2(parentDimNumber, this.getDimNumber());
        }
        env.setParentExpress(this);
        this.memberExpr.doCheck(env);
        env.setParentExpress(null);
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        String dimNumber = this.getDimNumber();
        Map<String, Set<String>> childMap = this.memberExpr.analyzeRange(leftRange, evaluator);
        Set<String> childMembers = childMap.get(dimNumber);
        LinkedHashSet members = Sets.newLinkedHashSet();
        Long viewId = evaluator.getRuleDto().getViewMap().getOrDefault(dimNumber, 0L);
        IModelCacheHelper modelCache = evaluator.getModelCache();
        for (String memNum : childMembers) {
            Member member = modelCache.getMember(dimNumber, viewId, memNum);
            List parents = modelCache.getParents(viewId, member, false);
            if (!CollectionUtils.isNotEmpty((Collection)parents) || parents.size() < this.level) continue;
            members.add(((Member)parents.get(this.level - 1)).getNumber());
        }
        childMap.put(dimNumber, members);
        return childMap;
    }

    @Override
    public List<IExpress> getChildren() {
        return Lists.newArrayList((Object[])new IExpress[]{this.memberExpr});
    }
}

