/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.RangeMapUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.IfExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.NumberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.OtherFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.WordExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.AbstractOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.AndOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.DivOper;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.OperationType;
import kd.epm.eb.olap.impl.execute.impl.expr.oper.OrOper;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.ParseException;

public class BinaryExpr
implements IExpress {
    private AbstractOper operType;
    private IExpress left = null;
    private IExpress right = null;

    public BinaryExpr(AbstractOper operType) {
        this.operType = operType;
    }

    public BinaryExpr(String oper) {
        this.operType = OperationType.getOperByStr(oper);
    }

    public AbstractOper getOperType() {
        return this.operType;
    }

    public void setOperType(AbstractOper operType) {
        this.operType = operType;
    }

    public void setLeft(IExpress left) {
        this.left = left;
    }

    public IExpress getLeft() {
        return this.left;
    }

    public void setRight(IExpress right) {
        this.right = right;
    }

    public IExpress getRight() {
        return this.right;
    }

    @Override
    public String toMdx(Environment env) {
        StringBuilder mdx = new StringBuilder();
        if (this.left instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)this.left;
            if (OperationType.comparePRI(this.getOperType().getSID(), _left.getOperType().getSID()) >= 0) {
                mdx.append('(').append(this.left.toMdx(env)).append(')');
            } else {
                mdx.append(this.left.toMdx(env));
            }
        } else {
            mdx.append(this.left.toMdx(env));
        }
        mdx.append(' ').append(this.getOperType().getOper()).append(' ');
        if (this.getOperType().getSID() == 20) {
            mdx.append(this.right.toMdx(env));
        } else if (this.right instanceof BinaryExpr) {
            BinaryExpr _right = (BinaryExpr)this.right;
            if (OperationType.comparePRI(this.getOperType().getSID(), _right.getOperType().getSID()) >= 0) {
                mdx.append('(').append(this.right.toMdx(env)).append(')');
            } else {
                mdx.append(this.right.toMdx(env));
            }
        } else {
            mdx.append(this.right.toMdx(env));
        }
        return mdx.toString();
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        if (this.getOperType() instanceof AndOper || this.getOperType() instanceof OrOper) {
            this.appendStringPanel(env, panels, this.getOperType().getOper());
            this.appendStringPanel(env, panels, "(");
            this.appendPartPanel(env, panels, false, this.left);
            this.appendStringPanel(env, panels, ",");
            this.appendPartPanel(env, panels, false, this.right);
            this.appendStringPanel(env, panels, ")");
        } else {
            boolean leftAddParenthesis = this.isAddParenthesis(this.left);
            boolean rightAddParenthesis = this.isAddParenthesis(this.right);
            this.appendPartPanel(env, panels, leftAddParenthesis, this.left);
            this.appendStringPanel(env, panels, this.getOperType().getOper());
            this.appendPartPanel(env, panels, rightAddParenthesis, this.right);
        }
        return panels;
    }

    public boolean isAddParenthesis(IExpress express) {
        if (express instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)express;
            return OperationType.comparePRI(this.getOperType().getSID(), _left.getOperType().getSID()) >= 0;
        }
        return false;
    }

    private void appendPartPanel(PanelEnvironment env, List<ExprPanel> panels, boolean leftAddParenthesis, IExpress left) {
        if (leftAddParenthesis) {
            this.appendStringPanel(env, panels, "(");
        }
        panels.addAll(left.toPanel(env));
        if (leftAddParenthesis) {
            this.appendStringPanel(env, panels, ")");
        }
    }

    private void appendStringPanel(PanelEnvironment env, List<ExprPanel> panels, String s) {
        ExprPanel panel1 = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel1.addShowStringAndValue(s, null);
        panels.add(panel1);
    }

    @Override
    public String toShrekString(Environment env) {
        StringBuilder mdx = new StringBuilder();
        if (this.getOperType() instanceof DivOper) {
            mdx.append("div(").append(this.left.toShrekString(env)).append(" , ").append(this.right.toShrekString(env)).append(" , ").append("null )");
            return mdx.toString();
        }
        if (this.left instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)this.left;
            if (OperationType.comparePRI(this.getOperType().getSID(), _left.getOperType().getSID()) >= 0) {
                mdx.append('(').append(this.left.toShrekString(env)).append(')');
            } else {
                mdx.append(this.left.toShrekString(env));
            }
        } else {
            mdx.append(this.left.toShrekString(env));
        }
        mdx.append(' ').append(this.getOperType().getOperForShrek()).append(' ');
        if (this.getOperType().getSID() == 20) {
            mdx.append(this.right.toShrekString(env));
        } else if (this.right instanceof BinaryExpr) {
            BinaryExpr _right = (BinaryExpr)this.right;
            if (OperationType.comparePRI(this.getOperType().getSID(), _right.getOperType().getSID()) >= 0) {
                mdx.append('(').append(this.right.toShrekString(env)).append(')');
            } else {
                mdx.append(this.right.toShrekString(env));
            }
        } else {
            mdx.append(this.right.toShrekString(env));
        }
        return mdx.toString();
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map<String, Set<String>> leftAnalyzeRange = this.left.analyzeRange(leftRange, evaluator);
        Map<String, Set<String>> rightAnalyzeRange = this.right.analyzeRange(leftRange, evaluator);
        boolean union = this.getOperType().isUnion();
        if (union) {
            return RangeMapUtils.union(evaluator.getDimensionNum(), leftAnalyzeRange, rightAnalyzeRange);
        }
        return RangeMapUtils.intersection(evaluator.getDimensionNum(), leftAnalyzeRange, rightAnalyzeRange);
    }

    @Override
    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        Set<String> leftDim = this.left.checkRuleEnlarge(evaluator);
        Set<String> rightDim = this.right.checkRuleEnlarge(evaluator);
        if (leftDim == null && rightDim == null) {
            return Sets.newLinkedHashSet();
        }
        if (leftDim == null) {
            return rightDim;
        }
        if (rightDim == null) {
            return leftDim;
        }
        boolean union = this.getOperType().isUnion();
        if (union) {
            leftDim.addAll(rightDim);
            return leftDim;
        }
        leftDim.retainAll(rightDim);
        return leftDim;
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        int sid = this.getOperType().getSID();
        if (env.isMain()) {
            if (sid != 20) {
                throw new ParseException(ResManager.loadKDString((String)"\u975e\u8d4b\u503c\u8868\u8fbe\u5f0f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e", (String)"RuleManagePlugin2_102", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!(this.getLeft() instanceof MdxMemberExpr)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u5de6\u5f0f\u5fc5\u987b\u662f\u6210\u5458\u3002", (String)"RuleManagePlugin2_93", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if (!OperationType.logicCompare.contains(sid) && !OperationType.jiajianchengchu.contains(sid)) {
            throw new ParseException(ResManager.loadResFormat((String)"\u89e3\u6790\u51fa\u9519,\u4e0d\u652f\u6301\u7684\u7b26\u53f7\uff1a\u201c%1\u201d\u3002", (String)"RuleManagePlugin2_42", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getOperType().getOper()}));
        }
        this.getLeft().doCheck(env);
        env.setMain(false);
        this.getRight().doCheck(env);
        if (env.isIfHasNotParam() && (this.getLeft() instanceof IfExpr || this.getRight() instanceof IfExpr) && OperationType.jiajianchengchu.contains(sid)) {
            throw new ParseException(ResManager.loadKDString((String)"\u5f53\u4f7f\u7528\u5305\u542b\u7a7a\u53c2\u6570\u7684IF\u51fd\u6570\u65f6\uff0cIF\u51fd\u6570\u4e4b\u5916\u4e0d\u5141\u8bb8\u4f7f\u7528\u4efb\u4f55\u8ba1\u7b97\u7b26\u53f7\u3002", (String)"RuleManagePlugin2_128", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (sid == 22 || sid == 23) {
            this.checkAndOrExpr(this.getLeft(), env);
            this.checkAndOrExpr(this.getRight(), env);
        } else {
            FunReturnType leftReturnType = this.getLeft().getReturnType(env);
            FunReturnType rightReturnType = this.getRight().getReturnType(env);
            if (leftReturnType == null || rightReturnType == null) {
                throw new ParseException(ResManager.loadKDString((String)"\u7b49\u5f0f\u53f3\u4fa7\u4e0d\u80fd\u51fa\u73b0\u8d4b\u503c\u8868\u8fbe\u5f0f", (String)"RuleManagePlugin2_103", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (leftReturnType == FunReturnType.Word || rightReturnType == FunReturnType.Word) {
                FunReturnType otherFunReturnType;
                FunReturnType funReturnType = otherFunReturnType = leftReturnType == FunReturnType.Word ? rightReturnType : leftReturnType;
                if (otherFunReturnType != FunReturnType.Word && otherFunReturnType != FunReturnType.Numeric) {
                    String lName = leftReturnType == FunReturnType.Word ? "NULL" : leftReturnType.getName();
                    String rName = rightReturnType == FunReturnType.Word ? "NULL" : rightReturnType.getName();
                    throw new ParseException(ResManager.loadResFormat((String)"\u7c7b\u578b\u65e0\u6cd5\u6bd4\u8f83/\u52a0\u51cf(%1 %2 %3)", (String)"RuleManagePlugin2_105", (String)"epm-eb-formplugin", (Object[])new Object[]{lName, this.operType.getOper(), rName}));
                }
            } else {
                if (leftReturnType != rightReturnType) {
                    throw new ParseException(ResManager.loadResFormat((String)"\u4e0d\u80fd\u8de8\u6570\u636e\u7c7b\u578b\u8fdb\u884c\u6bd4\u8f83\u6216\u52a0\u51cf(%1 %2 %3)", (String)"RuleManagePlugin2_106", (String)"epm-eb-formplugin", (Object[])new Object[]{leftReturnType.getName(), this.operType.getOper(), rightReturnType.getName()}));
                }
                if (OperationType.jiajianchengchu.contains(sid)) {
                    if (FunReturnType.Numeric != leftReturnType) {
                        throw new ParseException(ResManager.loadResFormat((String)"\u53ea\u80fd\u5bf9\u6570\u503c\u7c7b\u578b\u52a0\u51cf\u4e58\u9664(%1 %2 %3)", (String)"RuleManagePlugin2_107", (String)"epm-eb-formplugin", (Object[])new Object[]{leftReturnType.getName(), this.operType.getOper(), rightReturnType.getName()}));
                    }
                } else if (OperationType.logicCompare.contains(sid)) {
                    if (FunReturnType.Numeric == leftReturnType || FunReturnType.String == leftReturnType || FunReturnType.Date == leftReturnType) {
                        if (FunReturnType.String == leftReturnType) {
                            if (20 != sid && 18 != sid) {
                                throw new ParseException(ResManager.loadResFormat((String)"\u6587\u672c\u7c7b\u578b\u6bd4\u8f83\u53ea\u80fd\u7528=/<>(%1 %2 %3)", (String)"RuleManagePlugin2_108", (String)"epm-eb-formplugin", (Object[])new Object[]{leftReturnType.getName(), this.operType.getOper(), rightReturnType.getName()}));
                            }
                            if (this.getLeft() instanceof MdxMemberExpr && this.getRight() instanceof MdxMemberExpr) {
                                throw new ParseException(ResManager.loadResFormat((String)"\u65e0\u6cd5\u6bd4\u8f83\u4e24\u4e2a\u6587\u672c\u7c7b\u578b\u7684\u6210\u5458(%1 %2 %3)", (String)"RuleManagePlugin2_111", (String)"epm-eb-formplugin", (Object[])new Object[]{leftReturnType.getName(), this.operType.getOper(), rightReturnType.getName()}));
                            }
                        }
                    } else {
                        throw new ParseException(ResManager.loadResFormat((String)"\u8be5\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u6bd4\u8f83(%1 %2 %3)", (String)"RuleManagePlugin2_100", (String)"epm-eb-formplugin", (Object[])new Object[]{leftReturnType.getName(), this.operType.getOper(), rightReturnType.getName()}));
                    }
                }
            }
        }
        if (env.isIfCondition() && sid == 20) {
            WordExpr wordExpr;
            boolean notCheck;
            boolean bl = notCheck = this.getLeft() instanceof MdxMemberExpr || this.getLeft() instanceof NumberExpr;
            if (!notCheck && this.getLeft().getReturnType(env) == FunReturnType.Numeric && this.getRight() instanceof WordExpr && "null".equalsIgnoreCase((wordExpr = (WordExpr)this.getRight()).getName())) {
                throw new ParseException(ResManager.loadKDString((String)"IF\u51fd\u6570\u5224\u65ad\u6761\u4ef6\u51fd\u6570\u4e0d\u80fd\u8bbe\u7f6e\u6210\u7b49\u4e8enull\uff0c\u8bf7\u8bbe\u7f6e\u6210\u7b49\u4e8e0", (String)"RuleManagePlugin2_129", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkAndOrExpr(IExpress express, CheckEnvironment env) {
        if (express instanceof BinaryExpr || express instanceof OtherFun) {
            FunReturnType returnType = express.getReturnType(env);
            if (FunReturnType.Boolean != returnType) {
                throw new ParseException(ResManager.loadResFormat((String)"\u89e3\u6790\u51fa\u9519,AND/OR\u51fd\u6570\u7684\u53c2\u6570\u5fc5\u987b\u8fd4\u56de\u5e03\u5c14\u7c7b\u578b\u3002", (String)"RuleManagePlugin2_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            throw new ParseException(ResManager.loadResFormat((String)"\u89e3\u6790\u51fa\u9519\u3002\u903b\u8f91\u8868\u8fbe\u5f0f%1\u5185\u90e8\u542b\u6709\u975e\u4e8c\u5143\u8868\u8fbe\u5f0f\u3002", (String)"RuleManagePlugin2_104", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getOperType().getOper()}));
        }
    }

    @Override
    public FunReturnType getReturnType(CheckEnvironment env) {
        int sid = this.getOperType().getSID();
        if (OperationType.logicCompare.contains(sid)) {
            return FunReturnType.Boolean;
        }
        if (OperationType.jiajianchengchu.contains(sid)) {
            FunReturnType lReturnType = this.getLeft().getReturnType(env);
            if (FunReturnType.Word == lReturnType) {
                return this.getRight().getReturnType(env);
            }
            return lReturnType;
        }
        return null;
    }

    @Override
    public FunReturnType getReturnType() {
        int sid = this.getOperType().getSID();
        if (OperationType.logicCompare.contains(sid)) {
            return FunReturnType.Boolean;
        }
        if (OperationType.jiajianchengchu.contains(sid)) {
            FunReturnType lReturnType = this.getLeft().getReturnType();
            if (FunReturnType.Word == lReturnType) {
                return this.getRight().getReturnType();
            }
            return lReturnType;
        }
        return null;
    }

    @Override
    public boolean checkRightHasNumber() {
        boolean leftHave = this.getLeft().checkRightHasNumber();
        boolean rightHave = this.getRight().checkRightHasNumber();
        boolean union = this.getOperType().isUnion();
        if (union) {
            return leftHave || rightHave;
        }
        return leftHave && rightHave;
    }
}

