/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class CurrentMemberFun
extends SingleMemberExpr {
    @Override
    public String toMdx(Environment env) {
        IModelCacheHelper modelCache = env.getModelCache();
        Dimension dimension = modelCache.getDimension(this.getDimNumber());
        return '`' + dimension.getShortNumber() + "`.CurrentMember";
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        int seq = 0;
        ExprPanel panel1 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        Dimension dimension = env.getModelCache().getDimension(this.getDimNumber());
        panel1.addShowStringAndValue("@CurrMBR(" + dimension.getName() + ")", null);
        panel1.addBackStageKeyAndSeq(this.getFunKey(), seq);
        panels.add(panel1);
        return panels;
    }

    @Override
    public String toShrekString(Environment env) {
        throw new KDBizException("unsupported toShrek");
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        return leftRange;
    }

    @Override
    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        return Sets.newLinkedHashSet();
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        String parentDimNumber;
        String funcName = RuleFunctionEnum.CurrMBR.getName();
        this.checkRangeAndGetNumberGetNameContain(env, funcName);
        String currentFunDimNumber = this.getDimNumber();
        if (!env.getCurrentDataSetDimSet().contains(currentFunDimNumber)) {
            ParseExceptionCatcher.throwException4();
        }
        env.addFunRefDimension(this.getFunKey(), currentFunDimNumber);
        IExpress parentExpress = env.getParentExpress();
        if (parentExpress != null && !currentFunDimNumber.equals(parentDimNumber = ParseUtils.getExpressDimNumber(parentExpress))) {
            ParseExceptionCatcher.throwException2(parentDimNumber, this.getDimNumber());
        }
    }

    @Override
    public FunReturnType getReturnType() {
        return FunReturnType.Member;
    }
}

