/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.RangeMapUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AbstractFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.StringExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.ParseException;
import org.apache.commons.lang3.StringUtils;

public class DateDifFun
extends AbstractFun {
    private static String[] dateFmt = new String[]{"D", "M", "Y"};
    private IExpress begin;
    private IExpress end;
    private IExpress dateType;

    public DateDifFun() {
    }

    public DateDifFun(IExpress begin, IExpress end, IExpress dateType) {
        this.begin = begin;
        this.end = end;
        this.dateType = dateType;
    }

    @Override
    public List<IExpress> getChildren() {
        return Lists.newArrayList((Object[])new IExpress[]{this.begin, this.end});
    }

    @Override
    public FunReturnType getReturnType() {
        return FunReturnType.Numeric;
    }

    @Override
    public String toMdx(Environment env) {
        StringBuilder stringBuilder = new StringBuilder("DateDif(");
        stringBuilder.append(this.begin.toMdx(env));
        stringBuilder.append(",");
        stringBuilder.append(this.end.toMdx(env));
        stringBuilder.append(",");
        stringBuilder.append(this.dateType.toMdx(env));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        String funcValue = ObjUtils.getString((Object)this.getFuncMockCalcValue(env));
        if (StringUtils.isEmpty((CharSequence)funcValue)) {
            funcValue = "NULL";
        }
        String funKey = this.getFunKey();
        this.handleFuncValueMap(env, funKey, funcValue, "@DateDif(");
        LinkedList exprPanelList = Lists.newLinkedList();
        String finalFuncValue = funcValue;
        LambdaUtils.run(() -> {
            ExprPanel exprPanel = new ExprPanel(GlobalIdUtil.genStringId(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue("@DateDif(", finalFuncValue);
            exprPanel.addBackStageKeyAndSeq(exprPanel.getKey(), 0);
            exprPanelList.add(exprPanel);
        });
        exprPanelList.addAll(this.begin.toPanel(env));
        ExprPanel firstSplit = new ExprPanel(GlobalIdUtil.genStringId(), ExprPanelType.String, false);
        firstSplit.addShowStringAndValue(",", null);
        firstSplit.addBackStageKeyAndSeq(firstSplit.getKey(), 0);
        exprPanelList.add(firstSplit);
        exprPanelList.addAll(this.end.toPanel(env));
        ExprPanel secondSplit = new ExprPanel(GlobalIdUtil.genStringId(), ExprPanelType.String, false);
        secondSplit.addShowStringAndValue(",", null);
        secondSplit.addBackStageKeyAndSeq(secondSplit.getKey(), 0);
        exprPanelList.add(secondSplit);
        exprPanelList.addAll(this.dateType.toPanel(env));
        LambdaUtils.run(() -> {
            ExprPanel exprPanel = new ExprPanel(GlobalIdUtil.genStringId(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue(")", null);
            exprPanel.addBackStageKeyAndSeq(exprPanel.getKey(), 0);
            exprPanelList.add(exprPanel);
        });
        return exprPanelList;
    }

    @Override
    public String toShrekString(Environment env) {
        throw new ParseException(ResManager.loadKDString((String)"\u591a\u7ef4\u8ba1\u7b97\u4e0d\u652f\u6301@DateDif\u51fd\u6570\uff01", (String)"DateDifFun_1", (String)"epm-eb-olap", (Object[])new Object[0]));
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        String dateStr;
        env.setYearOrMonth(true);
        this.begin.doCheck(env);
        this.end.doCheck(env);
        env.setYearOrMonth(false);
        if (this.begin.getReturnType(env) != FunReturnType.Date) {
            throw new ParseException(ResManager.loadKDString((String)"@DateDif \u7b2c1\u4e2a\u53c2\u6570\u5fc5\u987b\u662fDate\u51fd\u6570\u6216\u8005\u53f3\u5f0f\u5ea6\u91cf\u4e3a\u65e5\u671f\u7684\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"DateDifFun_2", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (this.end.getReturnType(env) != FunReturnType.Date) {
            throw new ParseException(ResManager.loadKDString((String)"@DateDif \u7b2c2\u4e2a\u53c2\u6570\u5fc5\u987b\u662fDate\u51fd\u6570\u6216\u8005\u53f3\u5f0f\u5ea6\u91cf\u4e3a\u65e5\u671f\u7684\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"DateDifFun_3", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (this.dateType instanceof StringExpr && !StringUtils.equalsAnyIgnoreCase((CharSequence)(dateStr = ((StringExpr)this.dateType).toMdx()), (CharSequence[])dateFmt)) {
            throw new ParseException(ResManager.loadKDString((String)"@DateDif \u7b2c3\u4e2a\u53c2\u6570\u5fc5\u987b\u662fD,M,Y\u6216d,m,y\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"DateDifFun_4", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map<String, Set<String>> leftAnalyzeRange = this.begin.analyzeRange(leftRange, evaluator);
        Map<String, Set<String>> rightAnalyzeRange = this.end.analyzeRange(leftRange, evaluator);
        return RangeMapUtils.union(evaluator.getDimensionNum(), leftAnalyzeRange, rightAnalyzeRange);
    }

    public IExpress getBegin() {
        return this.begin;
    }

    public void setBegin(IExpress begin) {
        this.begin = begin;
    }

    public IExpress getEnd() {
        return this.end;
    }

    public void setEnd(IExpress end) {
        this.end = end;
    }

    public IExpress getDateType() {
        return this.dateType;
    }

    public void setDateType(IExpress dateType) {
        this.dateType = dateType;
    }

    @Override
    public boolean checkRightHasNumber() {
        return true;
    }

    @Override
    public boolean checkRightHasCalcFuncValue() {
        return true;
    }
}

