/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.var.TemplateVarCommonUtil;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.CurrentMemberFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.StringExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class DateFun
extends SetFun {
    private SetFun setFun;
    private StringExpr expr;

    @Override
    public List<IExpress> getChildren() {
        return Lists.newArrayList((Object[])new IExpress[]{this.setFun});
    }

    public StringExpr getExpr() {
        return this.expr;
    }

    public void setExpr(StringExpr expr) {
        this.expr = expr;
    }

    public void setSetFun(SetFun setFun) {
        setFun.setDimNumber(this.getDimNumber());
        this.setFun = setFun;
    }

    public SetFun getSetFun() {
        return this.setFun;
    }

    @Override
    public String toMdx(Environment env) {
        if (this.setFun != null) {
            if (this.setFun instanceof CurrentMemberFun) {
                return "Date(" + this.setFun.toMdx(env) + ")";
            }
            if (this.setFun instanceof SingleMemberExpr) {
                String memNumber = ((SingleMemberExpr)this.setFun).getMemNumber();
                if (TemplateVarCommonUtil.checkIsVar((String)memNumber, (String)SysDimensionEnum.BudgetPeriod.getNumber()).booleanValue()) {
                    DynamicObject variable = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"id,offset", (QFilter[])new QFilter("model", "=", (Object)env.getModelCache().getModelobj().getId()).and("number", "=", (Object)memNumber).toArray());
                    Dimension dimension = env.getModelCache().getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
                    return "Date(`" + dimension.getShortNumber() + "`.CurrentMember.Lead(" + variable.getInt("offset") + "))";
                }
                Member member = env.getModelCache().getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, memNumber);
                return "Date(" + member.getPeriodDate().getTime() + ".0)";
            }
            return "Date(" + this.setFun.toMdx(env) + ")";
        }
        String name = this.expr.getName();
        Date date = ConvertUtils.toDate((Object)name);
        return "Date(" + date.getTime() + ".0)";
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        String format = "";
        Object mockCalcValue = this.getFuncMockCalcValue(env);
        if (mockCalcValue instanceof BigDecimal) {
            long time = ((BigDecimal)mockCalcValue).longValue();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            format = sdf.format(new Date(time));
            String funKey = this.getFunKey();
            this.handleFuncValueMap(env, funKey, format, "@Date(");
        }
        LinkedList exprPanelList = Lists.newLinkedList();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        String finalFormat = format;
        LambdaUtils.run(() -> {
            ExprPanel exprPanel = new ExprPanel(this.getFunKey() + atomicInteger.get(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue("@Date(", finalFormat);
            exprPanel.addBackStageKeyAndSeq(this.getFunKey(), atomicInteger.get());
            exprPanelList.add(exprPanel);
        });
        if (this.setFun != null) {
            exprPanelList.addAll(this.setFun.toPanel(env));
        }
        if (this.expr != null) {
            exprPanelList.addAll(this.expr.toPanel(env));
        }
        LambdaUtils.run(() -> {
            atomicInteger.incrementAndGet();
            ExprPanel exprPanel = new ExprPanel(this.getFunKey() + atomicInteger.get(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue(")", null);
            exprPanel.addBackStageKeyAndSeq(this.getFunKey(), atomicInteger.get());
            exprPanelList.add(exprPanel);
        });
        return exprPanelList;
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        env.setParentToolEnum(ToolEnum.Date);
        env.setParentExpress(this);
        env.setDateFun(true);
        if (this.setFun != null) {
            this.setFun.doCheck(env);
        }
        if (this.expr != null) {
            this.expr.doCheck(env);
        }
        env.setParentExpress(null);
        env.setParentToolEnum(null);
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        return this.setFun.analyzeRange(leftRange, evaluator);
    }

    @Override
    public FunReturnType getReturnType(CheckEnvironment env) {
        return FunReturnType.Date;
    }

    @Override
    public boolean checkRightHasCalcFuncValue() {
        return true;
    }
}

