/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AttributeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class GetAttributeFun
extends SetFun {
    private SingleMemberExpr memberExpr;
    private String attribute;

    @Override
    public List<IExpress> getChildren() {
        return Lists.newArrayList((Object[])new IExpress[]{this.memberExpr});
    }

    public SingleMemberExpr getMemberExpr() {
        return this.memberExpr;
    }

    public void setMemberExpr(SingleMemberExpr memberExpr) {
        memberExpr.setDimNumber(this.getDimNumber());
        this.memberExpr = memberExpr;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute.substring(1, this.attribute.length() - 1);
    }

    @Override
    public String toMdx(Environment env) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.memberExpr.toMdx(env));
        String attribute = this.getAttribute();
        sb.append(".Properties('").append(attribute).append("')");
        env.addDimAttribute(this.getDimNumber(), attribute);
        return sb.toString();
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        int seq = 0;
        ExprPanel panel1 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        Dimension dimension = env.getModelCache().getDimension(this.getDimNumber());
        panel1.addShowStringAndValue("@GetAttribute(" + dimension.getName() + ",", null);
        panel1.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel1);
        panels.addAll(this.memberExpr.toPanel(env));
        MemberPropCache memberPropCache = env.getMemberPropCache();
        CustomProperty property = memberPropCache.getProperty(dimension.getNumber(), this.getAttribute());
        ExprPanel panel2 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel2.addShowStringAndValue("," + property.getName() + ")", null);
        panel2.addBackStageKeyAndSeq(this.getFunKey(), seq);
        panels.add(panel2);
        return panels;
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        if (!ToolEnum.rangeFunctionBoolean((ToolEnum)env.getParentToolEnum())) {
            ParseExceptionCatcher.throwRangeException();
        }
        String currentFunDimNumber = this.getDimNumber();
        if (!env.getCurrentDataSetDimSet().contains(currentFunDimNumber)) {
            ParseExceptionCatcher.throwException4();
        }
        env.addFunRefDimension(this.getFunKey(), currentFunDimNumber);
        IExpress parentExpress = env.getParentExpress();
        if (parentExpress != null) {
            String parentDimNumber;
            boolean parentIsAttribute = parentExpress instanceof AttributeFun;
            if (!parentIsAttribute) {
                ParseExceptionCatcher.throwGetAttributeNotInAttributeException();
            }
            if (!currentFunDimNumber.equals(parentDimNumber = ParseUtils.getExpressDimNumber(parentExpress))) {
                ParseExceptionCatcher.throwException2(parentDimNumber, this.getDimNumber());
            }
            String parentAttributeNumber = ParseUtils.getExpressAttributeNumber(parentExpress);
            String currentAttributeNumber = this.getAttribute();
            if (!currentAttributeNumber.equals(parentAttributeNumber)) {
                ParseExceptionCatcher.throwGetAttributeNotEqualsAttributeException(parentAttributeNumber, currentAttributeNumber);
            }
        } else {
            ParseExceptionCatcher.throwGetAttributeNotInAttributeException();
        }
        if (this.memberExpr != null) {
            env.setParentExpress(this);
            this.memberExpr.doCheck(env);
            env.setParentExpress(null);
        }
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map<String, Set<String>> childResultMap = this.memberExpr.analyzeRange(leftRange, evaluator);
        return childResultMap;
    }

    @Override
    public FunReturnType getReturnType(CheckEnvironment env) {
        return FunReturnType.String;
    }
}

