/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.AggType;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AbstractFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class MaxRangeFun
extends AbstractFun {
    private IExpress arg0;
    private IExpress arg1;

    @Override
    public List<IExpress> getChildren() {
        return Lists.newArrayList((Object[])new IExpress[]{this.arg0, this.arg1});
    }

    @Override
    public String toMdx(Environment env) {
        String memberMdx = ((MdxMemberExpr)this.arg0).toMdx(env, true);
        String setMdx = this.arg1.toMdx(env);
        if (this.arg1 instanceof SingleMemberExpr) {
            setMdx = "{" + setMdx + "}";
        }
        setMdx = "Distinct(" + setMdx + ")";
        if (memberMdx.isEmpty()) {
            return "Max({" + setMdx + "})";
        }
        return "Max({" + setMdx + '*' + memberMdx + "})";
    }

    @Override
    public FunReturnType getReturnType() {
        return FunReturnType.Numeric;
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList exprPanelList = Lists.newLinkedList();
        AtomicInteger seq = new AtomicInteger(0);
        LambdaUtils.run(() -> {
            ExprPanel exprPanel = new ExprPanel(this.getFunKey() + seq.getAndIncrement(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue("@MaxRange(", null);
            exprPanel.addBackStageKeyAndSeq(this.getFunKey(), 0);
            exprPanelList.add(exprPanel);
        });
        exprPanelList.addAll(this.arg0.toPanel(env));
        ExprPanel panel2 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel2.addShowStringAndValue(",", null);
        panel2.addBackStageKeyAndSeq(this.getFunKey(), seq.getAndIncrement());
        exprPanelList.add(panel2);
        exprPanelList.addAll(this.arg1.toPanel(env));
        LambdaUtils.run(() -> {
            ExprPanel exprPanel = new ExprPanel(this.getFunKey() + seq.getAndIncrement(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue(")", null);
            exprPanel.addBackStageKeyAndSeq(this.getFunKey(), seq.getAndIncrement());
            exprPanelList.add(exprPanel);
        });
        return exprPanelList;
    }

    @Override
    public String toShrekString(Environment env) {
        throw new KDBizException("unsupported toShrek");
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map<String, Set<String>> rangeMap;
        Map<String, Set<String>> setMap = null;
        try {
            setMap = this.arg1.analyzeRange(leftRange, evaluator);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String dimNumber = ((SetFun)this.arg1).getDimNumber();
        Map<String, Set<String>> leftRange2 = leftRange.entrySet().stream().filter(k -> !((String)k.getKey()).equals(dimNumber)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (n1, n2) -> n2));
        if (setMap != null && setMap.containsKey(dimNumber)) {
            leftRange2.put(dimNumber, setMap.get(dimNumber));
        }
        if ((rangeMap = this.arg0.analyzeRange(leftRange2, evaluator)).isEmpty()) {
            return rangeMap;
        }
        rangeMap.put(dimNumber, leftRange.get(dimNumber));
        return rangeMap;
    }

    @Override
    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        Set<String> args0 = this.arg0.checkRuleEnlarge(evaluator);
        Set<String> args1 = this.arg1.checkRuleEnlarge(evaluator);
        return this.getRuleEnlarge(args0, args1);
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        env.setParentToolEnum(ToolEnum.MaxRange);
        SetFun setFun = (SetFun)this.arg1;
        MdxMemberExpr mdxMemberExpr = (MdxMemberExpr)this.arg0;
        ParseUtils.checkReturnIsNumber(this.arg0, env);
        mdxMemberExpr.doCheck(env);
        env.setRangeDataSetId(this.getRangeDatasetId(env, mdxMemberExpr.getName()));
        setFun.doCheck(env);
        env.addFunKeyRefMemKey(setFun.getFunKey(), mdxMemberExpr.getName());
        env.addFunKeyRefParentFunKey(setFun.getFunKey(), this.getFunKey());
        env.addMemberAggType(mdxMemberExpr.getName(), AggType.MAX.getIndex());
        env.checkFunAndMemberRefDim(setFun.getFunKey(), mdxMemberExpr.getName());
        env.setParentToolEnum(null);
    }

    public IExpress getArg0() {
        return this.arg0;
    }

    public void setArg0(IExpress arg0) {
        this.arg0 = arg0;
    }

    public IExpress getArg1() {
        return this.arg1;
    }

    public void setArg1(IExpress arg1) {
        this.arg1 = arg1;
    }
}

