/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.RangeMapUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AbstractFun;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class MinFun
extends AbstractFun {
    private List<IExpress> args;

    @Override
    public List<IExpress> getChildren() {
        return Lists.newArrayList(this.args);
    }

    @Override
    public String toMdx(Environment env) {
        StringBuilder sb = new StringBuilder("Min(");
        for (IExpress arg : this.args) {
            String s = arg.toMdx(env);
            sb.append(s).append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public FunReturnType getReturnType() {
        return FunReturnType.Numeric;
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList exprPanelList = Lists.newLinkedList();
        AtomicInteger seq = new AtomicInteger(0);
        LambdaUtils.run(() -> {
            ExprPanel exprPanel = new ExprPanel(this.getFunKey() + seq.getAndIncrement(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue("@Min(", null);
            exprPanel.addBackStageKeyAndSeq(this.getFunKey(), seq.getAndIncrement());
            exprPanelList.add(exprPanel);
        });
        for (int i = 0; i < this.args.size(); ++i) {
            IExpress arg = this.args.get(i);
            exprPanelList.addAll(arg.toPanel(env));
            if (i >= this.args.size() - 1) continue;
            ExprPanel splitPanel = new ExprPanel(env.createKey() + seq.getAndIncrement(), ExprPanelType.String, false);
            splitPanel.addShowStringAndValue(",", null);
            exprPanelList.add(splitPanel);
        }
        LambdaUtils.run(() -> {
            ExprPanel exprPanel = new ExprPanel(this.getFunKey() + seq.getAndIncrement(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue(")", null);
            exprPanel.addBackStageKeyAndSeq(this.getFunKey(), seq.getAndIncrement());
            exprPanelList.add(exprPanel);
        });
        return exprPanelList;
    }

    @Override
    public String toShrekString(Environment env) {
        throw new KDBizException("unsupported toShrek");
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map<String, Set<String>> arg0 = this.args.get(0).analyzeRange(leftRange, evaluator);
        Map<String, Set<String>> arg1 = this.args.get(1).analyzeRange(leftRange, evaluator);
        return RangeMapUtils.union(evaluator.getDimensionNum(), arg0, arg1);
    }

    @Override
    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        Set<String> leftDim = this.args.get(0).checkRuleEnlarge(evaluator);
        Set<String> rightDim = this.args.get(1).checkRuleEnlarge(evaluator);
        return this.getRuleEnlarge(leftDim, rightDim);
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        ParseUtils.checkReturnIsNumber(this.args.get(0), env);
        ParseUtils.checkReturnIsNumber(this.args.get(1), env);
        this.args.get(0).doCheck(env);
        this.args.get(1).doCheck(env);
    }

    public List<IExpress> getArgs() {
        return this.args;
    }

    public void setArgs(List<IExpress> args) {
        this.args = args;
    }

    @Override
    public boolean checkRightHasNumber() {
        boolean leftHave = this.args.get(0).checkRightHasNumber();
        boolean rightHave = this.args.get(1).checkRightHasNumber();
        return leftHave || rightHave;
    }
}

