/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.ParseException;

public class NumberExpr
implements IExpress {
    private Number number = null;

    public NumberExpr() {
    }

    public NumberExpr(String numeric) {
        if (numeric.endsWith("%")) {
            numeric = numeric.substring(0, numeric.length() - 1);
            this.number = new BigDecimal(numeric).divide(new BigDecimal(100));
        } else {
            this.number = new BigDecimal(numeric);
        }
    }

    public Number getNumber() {
        return this.number;
    }

    public String toString() {
        if (this.number instanceof BigDecimal) {
            return ((BigDecimal)this.number).stripTrailingZeros().toPlainString();
        }
        return String.valueOf(this.number.toString());
    }

    @Override
    public FunReturnType getReturnType() {
        return FunReturnType.Numeric;
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        ExprPanel panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue(this.toString(), null);
        panels.add(panel);
        return panels;
    }

    @Override
    public String toMdx(Environment env) {
        return this.toMdx();
    }

    @Override
    public String toShrekString(Environment env) {
        return this.toMdx();
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        return this.createIgnoreRange();
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        BigDecimal _num = (BigDecimal)this.number;
        if (_num.compareTo(BgConstant.MAX_VALUE) >= 0 || _num.compareTo(BgConstant.MIN_VALUE) <= 0) {
            throw new ParseException(ResManager.loadResFormat((String)"\u89e3\u6790\u51fa\u9519,\u5b57\u6bb5\u8d85\u957f\uff1a%1\u3002", (String)"RuleManagePlugin2_41", (String)"epm-eb-formplugin", (Object[])new Object[]{this.number}));
        }
        if (_num.scale() > 15) {
            throw new ParseException(ResManager.loadResFormat((String)"\u6570\u503c\u503c(%1)\u7cbe\u5ea6(%2)\u8d85\u8fc715\u4f4d", (String)"RuleManagePlugin2_12", (String)"epm-eb-formplugin", (Object[])new Object[]{this.number, _num.scale()}));
        }
    }

    public String toMdx() {
        if (this.number instanceof BigDecimal) {
            return ((BigDecimal)this.number).stripTrailingZeros().toPlainString();
        }
        return String.valueOf(this.number.toString());
    }

    @Override
    public boolean checkRightHasNumber() {
        return true;
    }

    @Override
    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        return null;
    }
}

