/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionTypeEnum;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.showbizrule.ReportShowBizRuleMemberBo;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.NumberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import kd.epm.eb.olap.impl.execute.impl.visit.FormulaVisitContext;
import kd.epm.eb.olap.impl.execute.impl.visit.FormulaVisitResult;

public class OtherFun
implements IExpress {
    private String functionName = null;
    private String functionKey = null;
    private List<Object> params = new ArrayList<Object>();
    private String baseStr;

    public OtherFun() {
    }

    public OtherFun(String baseStr) {
        this.baseStr = baseStr;
    }

    @Override
    public FunReturnType getReturnType() {
        return FunReturnType.Numeric;
    }

    @Override
    public String toShrekString(Environment env) {
        if (this.functionKey.equals("Round")) {
            return this.roundFunToShrek(env);
        }
        throw new KDBizException("unsupported toShrek");
    }

    @Override
    public boolean checkRightHasNumber() {
        if ("Round".equals(this.functionName)) {
            return ((IExpress)this.params.get(0)).checkRightHasNumber();
        }
        if ("Count".equals(this.functionName)) {
            return true;
        }
        return "RecognitionP".equals(this.functionName) || "RecognitionPC".equals(this.functionName) || "RecognitionSP".equals(this.functionName);
    }

    @Override
    public boolean checkRightHasCalcFuncValue() {
        return RuleFunctionEnum.IsChild.getName().equals(this.functionName);
    }

    @Override
    public String toMdx(Environment env) {
        if ("Round".equals(this.functionName)) {
            return this.roundFunToMdx(env);
        }
        RuleFunction ruleFunction = env.getFunctionMap().get(this.functionKey);
        StringBuilder stringBuilder = new StringBuilder();
        if (ruleFunction != null) {
            Map allVal = ruleFunction.getAllValues();
            String name = ruleFunction.getFunctionName();
            RuleFunctionEnum ruleFunctionEnum = RuleFunctionEnum.valueOf((String)name);
            switch (ruleFunctionEnum) {
                case RecognitionP: {
                    this.rpFuncToMdx(stringBuilder, allVal, env);
                    break;
                }
                case RecognitionSP: {
                    this.rspFuncToMdx(stringBuilder, allVal, env);
                    break;
                }
                case Count: {
                    this.countFuncToMdx(stringBuilder, allVal, env);
                    break;
                }
                case RecognitionPC: {
                    this.rpcFuncToMdx(stringBuilder, allVal, env);
                    break;
                }
                case IsChild: {
                    this.isChildFunToMdx(stringBuilder, allVal, env);
                }
            }
        }
        return stringBuilder.toString();
    }

    private String roundFunToShrek(Environment env) {
        Object fisrtMemb = this.params.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("ROUND").append('(');
        if (!(fisrtMemb instanceof IExpress)) {
            throw new KDBizException(ResManager.loadKDString((String)"Round\u51fd\u6570\u53c2\u6570\u9519\u8bef\u3002", (String)"FunctionExpr_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        IExpress iExpress = (IExpress)fisrtMemb;
        sb.append(iExpress.toShrekString(env));
        sb.append(',');
        NumberExpr numberExpr = (NumberExpr)this.params.get(1);
        sb.append(numberExpr).append(')');
        return sb.toString();
    }

    private String roundFunToMdx(Environment env) {
        Object fisrtMemb = this.params.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("ROUND").append('(');
        if (!(fisrtMemb instanceof IExpress)) {
            throw new KDBizException(ResManager.loadKDString((String)"Round\u51fd\u6570\u53c2\u6570\u9519\u8bef\u3002", (String)"FunctionExpr_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        IExpress iExpress = (IExpress)fisrtMemb;
        sb.append(iExpress.toMdx(env));
        sb.append(',');
        NumberExpr numberExpr = (NumberExpr)this.params.get(1);
        sb.append(numberExpr).append(')');
        return sb.toString();
    }

    private void rpFuncToMdx(StringBuilder stringBuilder, Map<String, Object> allVal, Environment env) {
        String accountRangeMembStr = this.getDimRangeInfoToString(allVal, FunctionItemEnum.ACCOUNT.getKey(), '*', false, env);
        int returnPeriodNum = (Integer)allVal.get(FunctionItemEnum.RETURNPERIODNUM.getKey());
        int confirmPeriodNum = (Integer)allVal.get(FunctionItemEnum.CONFIRMPERIOD.getKey());
        BigDecimal tax = (BigDecimal)allVal.get(FunctionItemEnum.TAXRATE.getKey());
        stringBuilder.setLength(0);
        stringBuilder.append("Sum(");
        tax = tax.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal(1) : tax.add(new BigDecimal(1));
        tax = tax.multiply(new BigDecimal(returnPeriodNum));
        stringBuilder.append('{').append('{');
        stringBuilder.append("`BP`.CurrentMember.Lag(");
        stringBuilder.append(confirmPeriodNum + returnPeriodNum - 1);
        stringBuilder.append(')').append(':');
        stringBuilder.append("`BP`.CurrentMember.Lag(");
        stringBuilder.append(confirmPeriodNum).append(')').append('}').append('*');
        stringBuilder.append(accountRangeMembStr);
        stringBuilder.append('}').append(')');
        stringBuilder.append('/');
        stringBuilder.append(tax);
    }

    private void rspFuncToMdx(StringBuilder stringBuilder, Map<String, Object> allVal, Environment env) {
        String accountRangeMembStr = this.getDimRangeInfoToString(allVal, FunctionItemEnum.ACCOUNT.getKey(), ',', false, env);
        BigDecimal tax1 = (BigDecimal)allVal.get(FunctionItemEnum.TAXRATE.getKey());
        stringBuilder.append(accountRangeMembStr);
        stringBuilder.append(",`BP`.CurrentMember.Lag(");
        String preMembStr = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append('(');
        List returnEntityRows = (List)SerializationUtils.fromJsonString((String)((String)allVal.get(FunctionItemEnum.RETURNENTITY.getKey())), List.class);
        for (Map progress : returnEntityRows) {
            stringBuilder.append('(');
            stringBuilder.append(preMembStr);
            stringBuilder.append(progress.get(FunctionItemEnum.RETURNCYCLE.getKey()));
            stringBuilder.append("))*");
            stringBuilder.append(progress.get(FunctionItemEnum.RETURNSCALE.getKey()));
            stringBuilder.append('+');
        }
        stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
        stringBuilder.append('/');
        tax1 = tax1.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal(1) : tax1.add(new BigDecimal(1));
        stringBuilder.append(tax1);
    }

    private void countFuncToMdx(StringBuilder stringBuilder, Map<String, Object> allVal, Environment env) {
        String dimNumber = (String)allVal.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        String membRange = (String)allVal.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
        List memberConditions = (List)SerializationUtils.deSerializeFromBase64((String)membRange);
        IModelCacheHelper modelCache = env.getModelCache();
        Long viewId = env.getRuleDto().getViewMap().getOrDefault(dimNumber, 0L);
        int count = 0;
        for (MemberCondition condition : memberConditions) {
            String membNum = condition.getNumber();
            String range = condition.getRange();
            count += modelCache.getMember(dimNumber, viewId, membNum, Integer.parseInt(range)).size();
        }
        stringBuilder.append(count);
    }

    private void rpcFuncToMdx(StringBuilder stringBuilder, Map<String, Object> allVal, Environment env) {
        String accountRangeMembStr = this.getDimRangeInfoToString(allVal, FunctionItemEnum.ACCOUNT.getKey(), '*', false, env);
        int confirmPeriodNum = (Integer)allVal.get(FunctionItemEnum.CONFIRMPERIOD.getKey());
        String backPeriodRangeMembStr = this.getDimRangeInfoToString(allVal, FunctionItemEnum.RETURNPERIOD.getKey(), ',', true, env);
        BigDecimal tax = (BigDecimal)allVal.get(FunctionItemEnum.TAXRATE.getKey());
        stringBuilder.setLength(0);
        stringBuilder.append("Sum(");
        tax = tax.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal(1) : tax.add(new BigDecimal(1));
        stringBuilder.append('{').append('{');
        stringBuilder.append("`BP`.CurrentMember.Lag(");
        stringBuilder.append(confirmPeriodNum - 1).append('+');
        stringBuilder.append("CoalesceEmpty(");
        stringBuilder.append(backPeriodRangeMembStr).append(",1)");
        stringBuilder.append(')').append(':');
        stringBuilder.append("`BP`.CurrentMember.Lag(");
        stringBuilder.append(confirmPeriodNum).append(')').append('}').append('*');
        stringBuilder.append(accountRangeMembStr);
        stringBuilder.append('}').append(')');
        stringBuilder.append('/');
        stringBuilder.append(tax);
        stringBuilder.append('/');
        stringBuilder.append(backPeriodRangeMembStr);
    }

    private void isChildFunToMdx(StringBuilder stringBuilder, Map<String, Object> allVal, Environment env) {
        String dimNumber = (String)allVal.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        String memberNum = (String)allVal.get(FunctionItemEnum.DIMEMBER.getKey());
        Long viewId = 0L;
        if (allVal.containsKey("allvals_view_id")) {
            String viewIdStr = (String)allVal.get("allvals_view_id");
            viewId = IDUtils.toLong((Object)viewIdStr);
        }
        stringBuilder.append("(IsAncestor(");
        String shortNum = env.getModelCache().getDimension(dimNumber).getShortNumber();
        String membLongNum = env.getModelCache().getMember(dimNumber, viewId, memberNum).getLongNumber();
        stringBuilder.append('`').append(shortNum).append('`').append('.');
        stringBuilder.append(MemberServiceHelper.getMdx((String)membLongNum)).append(',');
        stringBuilder.append('`').append(shortNum).append('`').append('.');
        stringBuilder.append("CurrentMember").append(')').append(" OR ");
        stringBuilder.append('`').append(shortNum).append('`').append('.');
        stringBuilder.append(MemberServiceHelper.getMdx((String)membLongNum)).append('=');
        stringBuilder.append('`').append(shortNum).append('`').append('.').append("CurrentMember");
        stringBuilder.append(')');
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        if ("Round".equals(this.functionName) && this.params.get(0) instanceof IExpress) {
            return ((IExpress)this.params.get(0)).analyzeRange(leftRange, evaluator);
        }
        return this.createIgnoreRange();
    }

    @Override
    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        if ("Round".equals(this.functionName) && this.params.get(0) instanceof IExpress) {
            return ((IExpress)this.params.get(0)).checkRuleEnlarge(evaluator);
        }
        return Sets.newLinkedHashSet();
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        if (this.getFunctionName().equals("Round")) {
            ParseUtils.checkReturnIsNumber((IExpress)this.getParams().get(0), env);
            ((IExpress)this.getParams().get(0)).doCheck(env);
        }
    }

    @Override
    public FunReturnType getReturnType(CheckEnvironment env) {
        RuleFunctionEnum ruleFunctionEnum = RuleFunctionEnum.getFunctionEnumByNameNoError((String)this.getFunctionName());
        if (ruleFunctionEnum != null && ruleFunctionEnum.getFunctionType() == RuleFunctionTypeEnum.Bool) {
            return FunReturnType.Boolean;
        }
        return FunReturnType.Numeric;
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        if ("Round".equals(this.functionName)) {
            this.roundFunToPanel(env, panels);
        } else {
            IRuleFunction ruleFunction = (IRuleFunction)env.getFunctionMap().get(this.functionKey);
            if (ruleFunction != null) {
                Map allVal = ruleFunction.getAllValues();
                String name = ruleFunction.getFunctionName();
                RuleFunctionEnum ruleFunctionEnum = RuleFunctionEnum.valueOf((String)name);
                switch (ruleFunctionEnum) {
                    case RecognitionP: {
                        this.rpFuncToPanel(env, panels, allVal);
                        break;
                    }
                    case RecognitionSP: {
                        this.rspFuncToPanel(env, panels, allVal);
                        break;
                    }
                    case Count: {
                        this.countFuncToPanel(env, panels, allVal);
                        break;
                    }
                    case RecognitionPC: {
                        this.rpcFuncToPanel(env, panels, allVal);
                        break;
                    }
                    case IsChild: {
                        this.isChildFunToPanel(env, panels, allVal);
                    }
                }
            }
        }
        return panels;
    }

    private void roundFunToPanel(PanelEnvironment env, List<ExprPanel> panels) {
        ExprPanel panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue("@Round(", null);
        panels.add(panel);
        Object fisrtMemb = this.params.get(0);
        IExpress express = null;
        if (!(fisrtMemb instanceof IExpress)) {
            throw new KDBizException(ResManager.loadKDString((String)"Round\u51fd\u6570\u53c2\u6570\u9519\u8bef\u3002", (String)"FunctionExpr_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        express = (IExpress)fisrtMemb;
        panels.addAll(express.toPanel(env));
        panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue(",", null);
        panels.add(panel);
        express = (NumberExpr)this.params.get(1);
        panels.addAll(express.toPanel(env));
        panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue(")", null);
        panels.add(panel);
    }

    private void rpFuncToPanel(PanelEnvironment env, List<ExprPanel> panels, Map<String, Object> allVal) {
        ExprPanel panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue("@RecognitionP(", null);
        panels.add(panel);
        this.addAccountPanel(env, panels, allVal);
        BigDecimal taxrate = ConvertUtils.toDecimal((Object)allVal.get("taxrate"));
        Integer returnperiodnum = (Integer)allVal.get("returnperiodnum");
        Integer confirmperiod = (Integer)allVal.get("confirmperiod");
        panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        String showString = "," + returnperiodnum + "," + confirmperiod + "," + this.dealTaxRate(taxrate) + ")";
        panel.addShowStringAndValue(showString, null);
        panels.add(panel);
    }

    private String dealTaxRate(BigDecimal taxrate) {
        return taxrate.multiply(new BigDecimal(100)).setScale(2).toString() + '%';
    }

    private void addAccountPanel(PanelEnvironment env, List<ExprPanel> panels, Map<String, Object> allVal) {
        String keyInfo = (String)allVal.get(FunctionItemEnum.ACCOUNT.getKey());
        FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)keyInfo, FormulaMemberPojo.class);
        String key = (String)allVal.get("accountmemberkey");
        this.addAccountPanel(env, key, panels, formulaMemberPojo);
    }

    private void addAccountPanel(PanelEnvironment env, String memberKey, List<ExprPanel> panels, FormulaMemberPojo formulaMemberPojo) {
        List refDimMembers = formulaMemberPojo.getRefDimMembers();
        for (DimMemberPojo refDimMember : refDimMembers) {
            String dimNumber = refDimMember.getDimNumber();
            if (!SysDimensionEnum.Account.getNumber().equals(dimNumber)) continue;
            Map<String, ReportShowBizRuleMemberBo> ruleMemberMap = env.getRuleMemberMap();
            ReportShowBizRuleMemberBo ruleMemberBo = ruleMemberMap.get(memberKey);
            ExprPanel panel = new ExprPanel(memberKey, ExprPanelType.Member, true);
            String val = ruleMemberBo.getValue() == null ? null : ruleMemberBo.getValue().toString();
            panel.addShowStringAndValue(ruleMemberBo.getName(), val);
            panels.add(panel);
            break;
        }
    }

    private void rspFuncToPanel(PanelEnvironment env, List<ExprPanel> panels, Map<String, Object> allVal) {
        ExprPanel panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue("@RecognitionSP(", null);
        panels.add(panel);
        this.addAccountPanel(env, panels, allVal);
        BigDecimal taxrate = ConvertUtils.toDecimal((Object)allVal.get("taxrate"));
        String returnentity = (String)allVal.get("returnentity");
        StringBuilder sb = new StringBuilder();
        sb.append(this.dealTaxRate(taxrate)).append(",");
        List returnentityList = (List)JsonUtils.readValue((String)returnentity, List.class);
        for (Map map : returnentityList) {
            String returnscale = (String)map.get("returnscale");
            String returncycle = (String)map.get("returncycle");
            BigDecimal rate = new BigDecimal(returnscale).multiply(new BigDecimal(100)).setScale(2);
            sb.append(returncycle).append('|').append(rate.toString()).append('%').append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue(sb.toString(), null);
        panels.add(panel);
    }

    private void rpcFuncToPanel(PanelEnvironment env, List<ExprPanel> panels, Map<String, Object> allVal) {
        ExprPanel panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue("@RecognitionPC(", null);
        panels.add(panel);
        this.addAccountPanel(env, panels, allVal);
        panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue(",", null);
        panels.add(panel);
        String returnperiod = (String)allVal.get("returnperiod");
        FormulaMemberPojo periodMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)returnperiod, FormulaMemberPojo.class);
        String returnperiodmemberkey = (String)allVal.get("returnperiodmemberkey");
        this.addAccountPanel(env, returnperiodmemberkey, panels, periodMemberPojo);
        BigDecimal taxrate = ConvertUtils.toDecimal((Object)allVal.get("taxrate"));
        Integer confirmperiod = (Integer)allVal.get("confirmperiod");
        panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        String showString = "," + confirmperiod + "," + this.dealTaxRate(taxrate) + ")";
        panel.addShowStringAndValue(showString, null);
        panels.add(panel);
    }

    private void countFuncToPanel(PanelEnvironment env, List<ExprPanel> panels, Map<String, Object> allVal) {
        StringBuilder sb = new StringBuilder();
        String dimNumber = (String)allVal.get("dimensionlist");
        sb.append("@Count(").append(env.getModelCache().getDimension(dimNumber).getName()).append(",");
        String memberNumber = (String)allVal.get("dimmemberrange");
        List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)memberNumber);
        for (MemberCondition memberCondition : memberConditionList) {
            RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)Convert.toInt((Object)memberCondition.getRange()));
            sb.append(memberCondition.getNumber()).append(".").append(rangeEnum.getName()).append(",");
        }
        sb.setCharAt(sb.length() - 1, ')');
        ExprPanel panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue(sb.toString(), null);
        panels.add(panel);
    }

    private void isChildFunToPanel(PanelEnvironment env, List<ExprPanel> panels, Map<String, Object> allVal) {
        String funcValue = ObjUtils.getString((Object)this.getFuncMockCalcValue(env));
        String funKey = this.functionKey;
        this.handleFuncValueMap(env, funKey, funcValue, "@IsChild(");
        int seq = 0;
        ExprPanel panel = new ExprPanel(funKey + seq, ExprPanelType.String, false);
        panel.addShowStringAndValue("@IsChild(", funcValue);
        panel.addBackStageKeyAndSeq(funKey, seq++);
        panels.add(panel);
        String dimNumber = (String)allVal.get("dimensionlist");
        ExprPanel panel1 = new ExprPanel(funKey + seq, ExprPanelType.String, false);
        panel1.addShowStringAndValue(env.getModelCache().getDimension(dimNumber).getName() + ",", null);
        panel1.addBackStageKeyAndSeq(funKey, seq++);
        panels.add(panel1);
        String memberNumber = (String)allVal.get("dimmember");
        Long viewId = 0L;
        if (allVal.containsKey("allvals_view_id")) {
            String viewIdStr = (String)allVal.get("allvals_view_id");
            viewId = IDUtils.toLong((Object)viewIdStr);
        }
        Member member = env.getModelCache().getMember(dimNumber, viewId, memberNumber);
        ExprPanel panel2 = new ExprPanel(funKey + seq, ExprPanelType.String, false);
        panel2.addShowStringAndValue(member.getName(), null);
        panel2.addBackStageKeyAndSeq(funKey, seq++);
        panels.add(panel2);
        ExprPanel panel3 = new ExprPanel(funKey + seq, ExprPanelType.String, false);
        panel3.addShowStringAndValue(")", null);
        panel3.addBackStageKeyAndSeq(funKey, seq);
        panels.add(panel3);
    }

    public FormulaVisitResult formulaVisit(FormulaVisitContext formulaVisitContext) {
        return new FormulaVisitResult(this.baseStr);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionKey() {
        return this.functionKey;
    }

    public void setFunctionKey(String functionKey) {
        this.functionKey = functionKey;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public void setParams(List<Object> params) {
        this.params = params;
    }
}

