/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RangeMemberSetFun
extends SetFun {
    private String functionKey;

    @Override
    public List<IExpress> getChildren() {
        return null;
    }

    public RangeMemberSetFun(String tupleKey) {
        this.functionKey = tupleKey;
    }

    @Override
    public String toMdx(Environment env) {
        IModelCacheHelper modelCache = env.getModelCache();
        String dimNumber = this.getDimNumber();
        Long viewId = env.getRuleDto().getViewMap().getOrDefault(dimNumber, 0L);
        Dimension dimension = modelCache.getDimension(dimNumber);
        Map<String, RuleFunction> functionMap = env.getFunctionMap();
        RuleFunction ruleFunction = functionMap.get(this.functionKey);
        String memberNumber = (String)ruleFunction.getValue("dimmemberrange");
        List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)memberNumber);
        Set longMemberNumberStringSet = (Set)LambdaUtils.get(() -> {
            Pair matchedAndNotMatchedListPair = LambdaUtils.getMatchedAndNotMatchedListPair((Collection)memberConditionList, item -> !Boolean.TRUE.equals(item.getRemoveBoolean()));
            List normalMemberConditionList = (List)matchedAndNotMatchedListPair.getLeft();
            Set normalLongMemberNumberStringSet = normalMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, viewId, item.getNumber(), Integer.parseInt(item.getRange())).stream().map(Member::getLongNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            List removeMemberConditionList = (List)matchedAndNotMatchedListPair.getRight();
            if (CollectionUtils.isEmpty((Collection)removeMemberConditionList)) {
                return normalLongMemberNumberStringSet;
            }
            Set removeLongMemberNumberStringSet = removeMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, viewId, item.getNumber(), Integer.parseInt(item.getRange())).stream().map(Member::getLongNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
            normalLongMemberNumberStringSet.removeAll(removeLongMemberNumberStringSet);
            return normalLongMemberNumberStringSet;
        });
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(this.getDimNumber())) {
            List allMembers = env.getModelCache().getDimension(SysDimensionEnum.BudgetPeriod.getNumber()).getAllMemberSort();
            LinkedList filter = Lists.newLinkedList();
            for (Member member : allMembers) {
                if (!longMemberNumberStringSet.contains(member.getLongNumber())) continue;
                filter.add(member);
            }
            return filter.stream().map(item -> ParseUtils.genLongNumberMdx(dimension.getShortNumber(), item.getLongNumber())).collect(Collectors.joining(",", "{", "}"));
        }
        return longMemberNumberStringSet.stream().map(item -> ParseUtils.genLongNumberMdx(dimension.getShortNumber(), item)).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        Map<String, RuleFunction> functionMap = env.getFunctionMap();
        RuleFunction ruleFunction = functionMap.get(this.functionKey);
        String memberNumberString = (String)ruleFunction.getValue("dimmemberrange");
        ExprPanel exprPanel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)memberNumberString);
        exprPanel.addShowStringAndValue(RuleFunctionUtils.getFunctionShowString((List)memberConditionList), null);
        return Lists.newArrayList((Object[])new ExprPanel[]{exprPanel});
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        String dimNumber = this.getDimNumber();
        if (!SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            return;
        }
        Long leftDataSetId = env.getDataSetId();
        IModelCacheHelper modelCache = env.getModelCache();
        Map<String, IRuleFunction> functionMap = env.getFunctionMap();
        IRuleFunction ruleFunction = functionMap.get(this.functionKey);
        String memberNumber = (String)ruleFunction.getValue("dimmemberrange");
        List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)memberNumber);
        for (MemberCondition memberCondition : memberConditionList) {
            String memNumber = memberCondition.getNumber();
            Member member = modelCache.getMember(dimNumber, null, memNumber);
            if (leftDataSetId.equals(member.getDatasetId())) continue;
            throw new KDBizException(ParseExceptionCatcher.loadNoLink());
        }
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        String dimNumber = this.getDimNumber();
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        List<RuleFunction> functions = evaluator.getRuleDto().getFunctions();
        Optional<RuleFunction> optional = functions.stream().filter(fun -> this.functionKey.equals(fun.getFunctionKey())).findFirst();
        if (!optional.isPresent()) {
            LinkedHashSet members = Sets.newLinkedHashSet();
            resultMap.put(dimNumber, members);
            return resultMap;
        }
        IModelCacheHelper modelCache = evaluator.getModelCache();
        RuleFunction ruleFunction = optional.get();
        String memberNumber = (String)ruleFunction.getValue("dimmemberrange");
        List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)memberNumber);
        Pair matchedAndNotMatchedListPair = LambdaUtils.getMatchedAndNotMatchedListPair((Collection)memberConditionList, item -> !Boolean.TRUE.equals(item.getRemoveBoolean()));
        List normalMemberConditionList = (List)matchedAndNotMatchedListPair.getLeft();
        Set normalMemberNumberStringSet = normalMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, IDUtils.toLong((Object)item.getViewId()), item.getNumber(), Integer.parseInt(item.getRange())).stream().map(BaseCache::getNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
        resultMap.put(dimNumber, normalMemberNumberStringSet);
        List removeMemberConditionList = (List)matchedAndNotMatchedListPair.getRight();
        if (CollectionUtils.isEmpty((Collection)removeMemberConditionList)) {
            return resultMap;
        }
        Set removeMemberNumberStringSet = removeMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, IDUtils.toLong((Object)item.getViewId()), item.getNumber(), Integer.parseInt(item.getRange())).stream().map(BaseCache::getNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
        normalMemberNumberStringSet.removeAll(removeMemberNumberStringSet);
        return resultMap;
    }
}

