/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class SiblingFun
extends SetFun {
    private SingleMemberExpr memberExpr;

    @Override
    public List<IExpress> getChildren() {
        return Lists.newArrayList((Object[])new IExpress[]{this.memberExpr});
    }

    public void setMemberExpr(SingleMemberExpr memberExpr) {
        memberExpr.setDimNumber(this.getDimNumber());
        this.memberExpr = memberExpr;
    }

    public SingleMemberExpr getMemberExpr() {
        return this.memberExpr;
    }

    @Override
    public String toMdx(Environment env) {
        return "SiblingsExcludeSelf(" + this.memberExpr.toMdx(env) + ")";
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        int seq = 0;
        ExprPanel panel1 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        Dimension dimension = env.getModelCache().getDimension(this.getDimNumber());
        panel1.addShowStringAndValue("@Sibling(" + dimension.getName() + ",", null);
        panel1.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel1);
        panels.addAll(this.memberExpr.toPanel(env));
        ExprPanel panel2 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel2.addShowStringAndValue(")", null);
        panel2.addBackStageKeyAndSeq(this.getFunKey(), seq);
        panels.add(panel2);
        return panels;
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        String parentDimNumber;
        if (!ToolEnum.rangeFunctionBoolean((ToolEnum)env.getParentToolEnum())) {
            ParseExceptionCatcher.throwRangeException();
        }
        String currentFunDimNumber = this.getDimNumber();
        if (!env.getCurrentDataSetDimSet().contains(currentFunDimNumber)) {
            ParseExceptionCatcher.throwException4();
        }
        env.addFunRefDimension(this.getFunKey(), currentFunDimNumber);
        IExpress parentExpress = env.getParentExpress();
        if (parentExpress != null && !currentFunDimNumber.equals(parentDimNumber = ParseUtils.getExpressDimNumber(parentExpress))) {
            ParseExceptionCatcher.throwException2(parentDimNumber, this.getDimNumber());
        }
        env.setParentExpress(this);
        this.memberExpr.doCheck(env);
        env.setParentExpress(null);
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        String dimNumber = this.getDimNumber();
        Map<String, Set<String>> childMap = this.memberExpr.analyzeRange(leftRange, evaluator);
        Set<String> childMembers = childMap.get(dimNumber);
        IModelCacheHelper modelCache = evaluator.getModelCache();
        Long viewId = evaluator.getRuleDto().getViewMap().getOrDefault(dimNumber, 0L);
        LinkedHashSet members = Sets.newLinkedHashSet();
        for (String childMember : childMembers) {
            Member member = modelCache.getMember(dimNumber, viewId, childMember);
            List brother = modelCache.getBrother(viewId, member, false);
            Set memNumbers = brother.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            members.addAll(memNumbers);
        }
        childMap.put(dimNumber, members);
        return childMap;
    }
}

