/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class SimpleMemberSetFun
extends SetFun {
    private String functionKey;

    @Override
    public List<IExpress> getChildren() {
        return null;
    }

    public SimpleMemberSetFun(String tupleKey) {
        this.functionKey = tupleKey;
    }

    @Override
    public String toMdx(Environment env) {
        IModelCacheHelper modelCache = env.getModelCache();
        String dimNumber = this.getDimNumber();
        Map<String, Long> viewMap = env.getRuleDto().getViewMap();
        Long viewId = viewMap.get(dimNumber);
        Dimension dimension = modelCache.getDimension(dimNumber);
        Map<String, RuleFunction> functionMap = env.getFunctionMap();
        RuleFunction ruleFunction = functionMap.get(this.functionKey);
        String memberNumber = (String)ruleFunction.getValue("dimmember");
        String[] split = memberNumber.split(",");
        LinkedHashSet longNumbers = Sets.newLinkedHashSet();
        for (String memNumber : split) {
            Member member = modelCache.getMember(dimNumber, viewId, memNumber);
            longNumbers.add(member.getLongNumber());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (String longNumber : longNumbers) {
            String mdxStr = ParseUtils.genLongNumberMdx(dimension.getShortNumber(), longNumber);
            stringBuilder.append(mdxStr).append(",");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        Map allValues;
        IModelCacheHelper modelCache = env.getModelCache();
        String dimNumber = this.getDimNumber();
        Dimension dimension = modelCache.getDimension(dimNumber);
        Map<String, RuleFunction> functionMap = env.getFunctionMap();
        RuleFunction ruleFunction = functionMap.get(this.functionKey);
        String memberNumber = (String)ruleFunction.getValue("dimmember");
        String[] split = memberNumber.split(",");
        StringBuilder sb = new StringBuilder();
        Long viewId = 0L;
        Map<String, Long> viewMap = env.getViewMap();
        if (viewMap != null && !viewMap.isEmpty()) {
            viewId = viewMap.get(dimNumber);
        }
        if ((allValues = ruleFunction.getAllValues()).containsKey("allvals_view_id")) {
            viewId = IDUtils.toLong(allValues.get("allvals_view_id"));
        }
        for (String memNumber : split) {
            Member member = dimension.getMember(viewId, memNumber);
            sb.append(member.getName()).append(",");
        }
        sb.setLength(sb.length() - 1);
        LinkedList panels = Lists.newLinkedList();
        ExprPanel panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue(sb.toString(), null);
        panels.add(panel);
        return panels;
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        String dimNumber = this.getDimNumber();
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            String[] split;
            Long leftDataSetId = env.getDataSetId();
            IModelCacheHelper modelCache = env.getModelCache();
            Map<String, IRuleFunction> functionMap = env.getFunctionMap();
            IRuleFunction ruleFunction = functionMap.get(this.functionKey);
            String memberNumber = (String)ruleFunction.getValue("dimmember");
            for (String memNumber : split = memberNumber.split(",")) {
                Member member = modelCache.getMember(dimNumber, null, memNumber);
                if (leftDataSetId.equals(member.getDatasetId())) continue;
                throw new KDBizException(ParseExceptionCatcher.loadNoLink());
            }
        }
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        String dimNumber = this.getDimNumber();
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        LinkedHashSet members = Sets.newLinkedHashSet();
        resultMap.put(dimNumber, members);
        List<RuleFunction> functions = evaluator.getRuleDto().getFunctions();
        Optional<RuleFunction> optional = functions.stream().filter(fun -> this.functionKey.equals(fun.getFunctionKey())).findFirst();
        if (!optional.isPresent()) {
            return resultMap;
        }
        IModelCacheHelper modelCache = evaluator.getModelCache();
        RuleFunction ruleFunction = optional.get();
        String memberNumbers = (String)ruleFunction.getValue("dimmember");
        String[] split = memberNumbers.split(",");
        Long viewId = evaluator.getRuleDto().getViewMap().getOrDefault(dimNumber, 0L);
        for (String memberNumber : split) {
            List member = modelCache.getMember(dimNumber, viewId, memberNumber, RangeEnum.ALL_DETAIL.getIndex());
            Set collect = member.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            members.addAll(collect);
        }
        return resultMap;
    }
}

