/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.var.TemplateVarCommonUtil;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class SingleMemberExpr
extends SetFun {
    private String memNumber;

    @Override
    public List<IExpress> getChildren() {
        return null;
    }

    public SingleMemberExpr() {
    }

    public SingleMemberExpr(String memNumber) {
        this.memNumber = memNumber;
    }

    public String getMemNumber() {
        return this.memNumber;
    }

    public void setMemNumber(String memNumber) {
        this.memNumber = memNumber;
    }

    @Override
    public FunReturnType getReturnType() {
        return FunReturnType.Member;
    }

    @Override
    public String toMdx(Environment env) {
        IModelCacheHelper modelCache = env.getModelCache();
        Dimension dimension = modelCache.getDimension(this.getDimNumber());
        Map<String, Long> viewMap = env.getRuleDto().getViewMap();
        Long viewId = viewMap.get(dimension.getNumber());
        Member member = modelCache.getMember(this.getDimNumber(), viewId, this.getMemNumber());
        return ParseUtils.genLongNumberMdx(dimension.getShortNumber(), member.getLongNumber());
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        int seq = 0;
        ExprPanel panel1 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        IModelCacheHelper modelCache = env.getModelCache();
        Dimension dimension = modelCache.getDimension(this.getDimNumber());
        Long bizCtrlRangeId = env.getRuleDto().getBizCtrlRangeId();
        if (TemplateVarCommonUtil.checkIsVar((String)this.getMemNumber(), (String)this.getDimNumber()).booleanValue()) {
            DynamicObject variable = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"id,name", (QFilter[])new QFilter("model", "=", (Object)modelCache.getModelobj().getId()).and("number", "=", (Object)this.getMemNumber()).toArray());
            panel1.addShowStringAndValue(variable.getString("name"), null);
        } else {
            Member member = modelCache.getMemberByAnyView(bizCtrlRangeId, dimension.getNumber(), this.getMemNumber());
            panel1.addShowStringAndValue(member.getName(), null);
        }
        panel1.addBackStageKeyAndSeq(this.getFunKey(), seq);
        panels.add(panel1);
        return panels;
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        if (SysDimensionEnum.Account.getNumber().equals(this.getDimNumber())) {
            IModelCacheHelper modelCache = env.getModelCache();
            Member member = modelCache.getMember(this.getDimNumber(), null, this.getMemNumber());
            Long datasetId = member.getDatasetId();
            Long leftDataSetId = env.getDataSetId();
            if (!leftDataSetId.equals(datasetId)) {
                throw new KDBizException(ParseExceptionCatcher.loadNoLink());
            }
        }
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        map.put(this.getDimNumber(), Sets.newHashSet((Object[])new String[]{this.getMemNumber()}));
        return map;
    }
}

